/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import docking.options.editor.StringWithChoicesEditor;
import generic.stl.Pair;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.program.database.SpecExtension;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadCallfixup;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlParseException;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ProgramCompilerSpec
extends BasicCompilerSpec {
    public static final String DECOMPILER_PROPERTY_LIST_NAME = "Decompiler";
    public static final String DECOMPILER_OUTPUT_LANGUAGE = "Output Language";
    public static final DecompilerLanguage DECOMPILER_OUTPUT_DEF = DecompilerLanguage.C_LANGUAGE;
    public static final String DECOMPILER_OUTPUT_DESC = "Select the source language output by the decompiler.";
    public static final String EVALUATION_MODEL_PROPERTY_NAME = "Prototype Evaluation";
    private Program program;
    private Map<String, PrototypeModel> usermodels = null;
    private int versionCounter = 0;

    private ProgramCompilerSpec(Program program, BasicCompilerSpec langSpec) {
        super(langSpec);
        this.program = program;
    }

    public static void enableJavaLanguageDecompilation(Program program) {
        Options decompilerPropertyList = program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        decompilerPropertyList.registerOption(DECOMPILER_OUTPUT_LANGUAGE, (Object)DECOMPILER_OUTPUT_DEF, null, DECOMPILER_OUTPUT_DESC);
        decompilerPropertyList.setEnum(DECOMPILER_OUTPUT_LANGUAGE, (Enum)DecompilerLanguage.JAVA_LANGUAGE);
    }

    @Override
    public DecompilerLanguage getDecompilerOutputLanguage() {
        Options options = this.program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        if (options.contains(DECOMPILER_OUTPUT_LANGUAGE)) {
            return (DecompilerLanguage)options.getEnum(DECOMPILER_OUTPUT_LANGUAGE, (Enum)DECOMPILER_OUTPUT_DEF);
        }
        return DECOMPILER_OUTPUT_DEF;
    }

    private void installPrototypeExtensions(List<PrototypeModel> extensions) {
        if (this.usermodels == null) {
            if (extensions.isEmpty()) {
                return;
            }
            this.usermodels = new TreeMap<String, PrototypeModel>();
        }
        ArrayList<PrototypeModel> finalList = new ArrayList<PrototypeModel>();
        TreeSet<String> currentNames = new TreeSet<String>();
        for (PrototypeModel model : this.allmodels) {
            if (this.usermodels.containsKey(model.getName())) continue;
            currentNames.add(model.getName());
            finalList.add(model);
        }
        this.usermodels.clear();
        for (PrototypeModel model : extensions) {
            if (currentNames.contains(model.getName())) {
                Msg.warn((Object)this, (Object)("Cannot override prototype model " + model.getName() + " with extension"));
                continue;
            }
            ProgramCompilerSpec.markPrototypeAsExtension(model);
            finalList.add(model);
            this.usermodels.put(model.getName(), model);
        }
        String defaultName = null;
        String evalName = null;
        String evalCalledName = null;
        if (this.defaultModel != null) {
            defaultName = this.defaultModel.getName();
        }
        if (this.evalCurrentModel != null) {
            evalName = this.evalCurrentModel.getName();
        }
        if (this.evalCalledModel != null) {
            evalCalledName = this.evalCalledModel.getName();
        }
        try {
            this.modelXrefs(finalList, defaultName, evalName, evalCalledName);
        }
        catch (XmlParseException e) {
            Msg.warn((Object)this, (Object)("Prototype model extensions NOT installed: " + e.getMessage()));
            this.usermodels.clear();
        }
        if (this.usermodels.isEmpty()) {
            this.usermodels = null;
        }
    }

    private static ArrayList<String> addPrototypeError(ArrayList<String> errList, PrototypeModel model) {
        if (model.isErrorPlaceholder()) {
            if (errList == null) {
                errList = new ArrayList();
            } else if (errList.size() > 4) {
                errList.add("...");
                return errList;
            }
            String message = "prototype: " + model.getName();
            errList.add(message);
        }
        return errList;
    }

    private static ArrayList<String> addPayloadError(ArrayList<String> errList, InjectPayload payload) {
        if (payload.isErrorPlaceholder()) {
            if (errList == null) {
                errList = new ArrayList();
            } else if (errList.size() > 4) {
                errList.add("...");
                return errList;
            }
            String message = payload instanceof InjectPayloadCallfixup ? "callfixup: " + payload.getName() : "callotherfixup: " + payload.getName();
            errList.add(message);
        }
        return errList;
    }

    private void updateModelChoices() {
        Options decompilerPropertyList = this.program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        PropertyEditor editor = decompilerPropertyList.getRegisteredPropertyEditor(EVALUATION_MODEL_PROPERTY_NAME);
        if (editor == null) {
            return;
        }
        if (!(editor instanceof StringWithChoicesEditor)) {
            return;
        }
        String[] evalChoices = this.establishEvaluationModelChoices(this.evalCurrentModel);
        StringWithChoicesEditor choiceEditor = (StringWithChoicesEditor)editor;
        choiceEditor.setChoices(evalChoices);
    }

    private void reportExtensionErrors(ArrayList<String> errorList) {
        if (errorList == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<HTML>User-defined extensions failed to parse: ");
        buffer.append("<ul>");
        for (String line : errorList) {
            buffer.append("<li>").append(line).append("</li>");
        }
        buffer.append("</ul>");
        buffer.append("See Program Options - Specification Extensions</HTML>");
        Msg.showError(BasicCompilerSpec.class, null, (String)"Specification Extension Errors", (Object)buffer.toString());
    }

    protected void installExtensions() {
        int storedVersion = SpecExtension.getVersionCounter(this.program);
        if (storedVersion == this.versionCounter) {
            return;
        }
        this.versionCounter = storedVersion;
        List<Pair<String, String>> pairList = SpecExtension.getCompilerSpecExtensions(this.program);
        if (pairList.isEmpty() && this.usermodels == null && this.pcodeInject.getProgramPayloads() == null) {
            return;
        }
        if (this.usermodels != null) {
            this.removeProgramMechanismPayloads(this.usermodels.values());
        }
        ArrayList<PrototypeModel> modelExtensions = new ArrayList<PrototypeModel>();
        ArrayList<InjectPayloadSleigh> injectExtensions = new ArrayList<InjectPayloadSleigh>();
        ArrayList<String> errorList = null;
        for (Pair<String, String> pair : pairList) {
            try {
                Object obj = SpecExtension.parseExtension((String)pair.first, (String)pair.second, this, true);
                if (obj instanceof PrototypeModel) {
                    PrototypeModel prototypeModel = (PrototypeModel)obj;
                    modelExtensions.add(prototypeModel);
                    errorList = ProgramCompilerSpec.addPrototypeError(errorList, prototypeModel);
                    continue;
                }
                if (!(obj instanceof InjectPayloadSleigh)) continue;
                InjectPayloadSleigh payload = (InjectPayloadSleigh)obj;
                injectExtensions.add(payload);
                errorList = ProgramCompilerSpec.addPayloadError(errorList, payload);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Bad compiler spec extension: " + (String)pair.first + " - " + e.getMessage()));
            }
        }
        this.installPrototypeExtensions(modelExtensions);
        this.registerProgramInject(injectExtensions);
        this.updateModelChoices();
        this.reportExtensionErrors(errorList);
    }

    private String[] establishEvaluationModelChoices(PrototypeModel defaultEval) {
        String[] evalChoices = new String[this.allmodels.length];
        int defaultnum = -1;
        for (int i = 0; i < this.allmodels.length; ++i) {
            PrototypeModel curModel = this.allmodels[i];
            evalChoices[i] = curModel.getName();
            if (curModel != defaultEval) continue;
            defaultnum = i;
        }
        if (defaultnum > 0) {
            String tmp = evalChoices[defaultnum];
            for (int i = defaultnum; i > 0; --i) {
                evalChoices[i] = evalChoices[i - 1];
            }
            evalChoices[0] = tmp;
        }
        return evalChoices;
    }

    @Override
    public PrototypeModel getPrototypeEvaluationModel(CompilerSpec.EvaluationModelType modelType) {
        Options options = this.program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        switch (modelType) {
            case EVAL_CURRENT: {
                String name = options.getString(EVALUATION_MODEL_PROPERTY_NAME, this.evalCurrentModel.getName());
                for (PrototypeModel model : this.allmodels) {
                    if (!model.getName().equals(name)) continue;
                    return model;
                }
                break;
            }
            case EVAL_CALLED: {
                return this.evalCalledModel;
            }
        }
        return this.defaultModel;
    }

    protected void registerProgramOptions() {
        String[] evalChoices = this.establishEvaluationModelChoices(this.evalCurrentModel);
        Options decompilerPropertyList = this.program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        decompilerPropertyList.setOptionsHelpLocation(new HelpLocation("DecompilePlugin", "ProgramOptions"));
        decompilerPropertyList.registerOption(EVALUATION_MODEL_PROPERTY_NAME, OptionType.STRING_TYPE, (Object)evalChoices[0], new HelpLocation("DecompilePlugin", "OptionProtoEval"), "Select the default function prototype/evaluation model to be used during Decompiler analysis", (PropertyEditor)new StringWithChoicesEditor(evalChoices));
        if (decompilerPropertyList.contains(DECOMPILER_OUTPUT_LANGUAGE)) {
            decompilerPropertyList.registerOption(DECOMPILER_OUTPUT_LANGUAGE, (Object)DECOMPILER_OUTPUT_DEF, null, DECOMPILER_OUTPUT_DESC);
        }
        Options analysisPropertyList = this.program.getOptions("Analyzers.Decompiler Parameter ID");
        analysisPropertyList.createAlias(EVALUATION_MODEL_PROPERTY_NAME, decompilerPropertyList, EVALUATION_MODEL_PROPERTY_NAME);
    }

    protected void resetProgramOptions(TaskMonitor monitor) throws CancelledException {
        Options decompilerPropertyList = this.program.getOptions(DECOMPILER_PROPERTY_LIST_NAME);
        decompilerPropertyList.restoreDefaultValue(EVALUATION_MODEL_PROPERTY_NAME);
        if (decompilerPropertyList.contains(DECOMPILER_OUTPUT_LANGUAGE)) {
            decompilerPropertyList.restoreDefaultValue(DECOMPILER_OUTPUT_LANGUAGE);
        }
        SpecExtension.clearAllExtensions(this.program, monitor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProgramCompilerSpec)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ProgramCompilerSpec op2 = (ProgramCompilerSpec)obj;
        return SystemUtilities.isEqual(this.usermodels, op2.usermodels);
    }

    static CompilerSpec getProgramCompilerSpec(Program program, CompilerSpec langSpec) {
        if (langSpec instanceof ProgramCompilerSpec) {
            throw new IllegalArgumentException("Cannot instantiate ProgramCompilerSpec from another ProgramCompilerSpec");
        }
        if (langSpec instanceof BasicCompilerSpec) {
            return new ProgramCompilerSpec(program, (BasicCompilerSpec)langSpec);
        }
        return langSpec;
    }
}

