/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.floatformat;

import ghidra.pcode.floatformat.FloatFormat;
import ghidra.pcode.floatformat.FloatKind;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigFloat
implements Comparable<BigFloat> {
    final int fracbits;
    final int expbits;
    final int maxScale;
    final int minScale;
    FloatKind kind;
    int sign;
    BigInteger unscaled;
    int scale;

    BigFloat(int fracbits, int expbits, FloatKind kind, int sign, BigInteger unscaled, int scale) {
        this.fracbits = fracbits;
        this.expbits = expbits;
        this.kind = kind;
        this.sign = sign;
        this.unscaled = unscaled;
        this.scale = scale;
        this.maxScale = (1 << expbits - 1) - 1;
        this.minScale = 1 - this.maxScale;
        if (unscaled.bitLength() > fracbits + 1) {
            throw new IllegalArgumentException("unscaled value exceeds " + (fracbits + 1) + " bits in length (length=" + unscaled.bitLength() + ")");
        }
        if (scale < this.minScale || scale > this.maxScale) {
            throw new IllegalArgumentException("scale out of bounds " + this.minScale + " to " + this.maxScale + " (scale=" + scale + ")");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.expbits;
        result = 31 * result + this.fracbits;
        result = 31 * result + this.kind.hashCode();
        switch (this.kind) {
            case FINITE: {
                result = 31 * result + this.sign;
                result = 31 * result + this.scale;
                result = 31 * result + this.unscaled.hashCode();
                break;
            }
            case INFINITE: {
                result = 31 * result + this.sign;
                break;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigFloat other = (BigFloat)obj;
        if (this.expbits != other.expbits) {
            return false;
        }
        if (this.fracbits != other.fracbits) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        switch (this.kind) {
            case FINITE: {
                if (this.sign != other.sign) {
                    return false;
                }
                if (this.scale != other.scale) {
                    return false;
                }
                if (this.unscaled.equals(other.unscaled)) break;
                return false;
            }
            case INFINITE: {
                if (this.sign == other.sign) break;
                return false;
            }
        }
        return true;
    }

    public static BigFloat valueOf(int fracbits, int expbits, BigInteger i) {
        BigFloat f = new BigFloat(fracbits, expbits, FloatKind.FINITE, i.signum() >= 0 ? 1 : -1, i.abs(), fracbits);
        f.scaleUpTo(fracbits + 1);
        return f;
    }

    public static BigFloat zero(int fracbits, int expbits, int sign) {
        return new BigFloat(fracbits, expbits, FloatKind.FINITE, sign, BigInteger.ZERO, 2 - (1 << expbits - 1));
    }

    public static BigFloat zero(int fracbits, int expbits) {
        return BigFloat.zero(fracbits, expbits, 1);
    }

    public static BigFloat infinity(int fracbits, int expbits, int sign) {
        return new BigFloat(fracbits, expbits, FloatKind.INFINITE, sign, BigInteger.ONE.shiftLeft(fracbits), (1 << expbits - 1) - 1);
    }

    public static BigFloat quietNaN(int fracbits, int expbits, int sign) {
        return new BigFloat(fracbits, expbits, FloatKind.QUIET_NAN, sign, BigInteger.ZERO, (1 << expbits - 1) - 1);
    }

    private void upscale(int nbits) {
        this.unscaled = this.unscaled.shiftLeft(nbits);
        this.scale -= nbits;
    }

    protected void scaleUpTo(int newLength) {
        if (this.kind != FloatKind.FINITE) {
            throw new AssertionError((Object)"scaling of non-finite float!");
        }
        int d = newLength - this.unscaled.bitLength();
        if (d > 0) {
            this.upscale(d);
        }
    }

    public boolean isNormal() {
        return this.kind == FloatKind.FINITE && this.unscaled.bitLength() == this.fracbits + 1;
    }

    public boolean isDenormal() {
        return this.kind == FloatKind.FINITE && !this.unscaled.equals(BigInteger.ZERO) && this.unscaled.bitLength() <= this.fracbits;
    }

    protected void internalRound(boolean eps) {
        if (this.kind != FloatKind.FINITE) {
            throw new AssertionError((Object)"Rounding non-finite float");
        }
        if (this.unscaled.signum() == 0) {
            if (eps) {
                throw new AssertionError((Object)"Rounding zero + epsilon, need bit length");
            }
            this.makeZero();
            return;
        }
        int extrabits = Math.max(this.unscaled.bitLength() - (this.fracbits + 1), this.minScale - this.scale);
        if (extrabits <= 0) {
            throw new AssertionError((Object)"Rounding with no extra bits of precision");
        }
        int midbit = extrabits - 1;
        boolean midbitset = this.unscaled.testBit(midbit);
        this.unscaled = this.unscaled.shiftRight(extrabits);
        this.scale += extrabits;
        boolean odd = this.unscaled.testBit(0);
        if (midbitset && ((eps |= this.unscaled.getLowestSetBit() < midbit) || odd)) {
            this.unscaled = this.unscaled.add(BigInteger.ONE);
            if (this.unscaled.bitLength() > this.fracbits + 1) {
                assert (this.unscaled.bitLength() == this.unscaled.getLowestSetBit() + 1);
                this.unscaled = this.unscaled.shiftRight(1);
                ++this.scale;
            }
        }
        if (this.scale > this.maxScale) {
            this.kind = FloatKind.INFINITE;
        }
    }

    protected int getLeadBitPos() {
        if (this.kind != FloatKind.FINITE || this.unscaled.signum() == 0) {
            throw new AssertionError((Object)"lead bit of non-finite or zero");
        }
        return this.unscaled.bitLength() - this.fracbits + this.scale;
    }

    public BigDecimal toBigDecimal() {
        switch (this.kind) {
            case FINITE: {
                BigDecimal x;
                if (this.isZero()) {
                    return BigDecimal.ZERO;
                }
                int unusedBits = Math.max(this.unscaled.getLowestSetBit(), 0);
                BigInteger val = this.unscaled;
                int iscale = this.scale - this.fracbits;
                if (iscale >= -unusedBits) {
                    x = new BigDecimal(val.shiftLeft(iscale));
                } else {
                    if (unusedBits > 0) {
                        val = this.unscaled.shiftRight(unusedBits);
                        iscale += unusedBits;
                    }
                    x = new BigDecimal(val.multiply(BigInteger.valueOf(5L).pow(-iscale)), -iscale);
                }
                if (this.sign < 0) {
                    x = x.negate();
                }
                return x;
            }
            case INFINITE: {
                return this.sign < 0 ? FloatFormat.BIG_NEGATIVE_INFINITY : FloatFormat.BIG_POSITIVE_INFINITY;
            }
            case QUIET_NAN: 
            case SIGNALING_NAN: {
                return FloatFormat.BIG_NaN;
            }
        }
        throw new AssertionError((Object)("unknown BigFloat kind: " + this.kind));
    }

    public String toBinaryString() {
        switch (this.kind) {
            case QUIET_NAN: {
                return "qNaN";
            }
            case SIGNALING_NAN: {
                return "sNaN";
            }
            case INFINITE: {
                if (this.sign < 0) {
                    return "-inf";
                }
                return "+inf";
            }
            case FINITE: {
                Object binary;
                String s = this.sign < 0 ? "-" : "";
                int ascale = this.scale;
                if (this.isNormal()) {
                    binary = "1." + this.unscaled.toString(2).substring(1);
                    ascale += this.unscaled.bitLength() - (this.fracbits + 1);
                } else {
                    assert (this.unscaled.bitLength() <= this.fracbits);
                    if (this.unscaled.equals(BigInteger.ZERO)) {
                        return String.format("%s0b0.0", s);
                    }
                    binary = "0." + "0".repeat(this.fracbits - this.unscaled.bitLength()) + this.unscaled.toString(2);
                }
                binary = ((String)binary).replaceAll("0*$", "");
                if (((String)binary).endsWith(".")) {
                    binary = (String)binary + "0";
                }
                return String.format("%s0b%s * 2^%d", s, binary, ascale);
            }
        }
        throw new AssertionError((Object)("unexpected kind " + this.kind));
    }

    protected void makeSignalingNaN() {
        this.kind = FloatKind.SIGNALING_NAN;
    }

    protected void makeQuietNaN() {
        this.kind = FloatKind.QUIET_NAN;
    }

    public boolean isNaN() {
        return this.kind == FloatKind.QUIET_NAN || this.kind == FloatKind.SIGNALING_NAN;
    }

    protected void makeZero() {
        this.kind = FloatKind.FINITE;
        this.unscaled = BigInteger.ZERO;
        this.scale = this.minScale;
    }

    public boolean isInfinite() {
        return this.kind == FloatKind.INFINITE;
    }

    public boolean isZero() {
        return this.kind == FloatKind.FINITE && this.unscaled.equals(BigInteger.ZERO);
    }

    public BigFloat copy() {
        return new BigFloat(this.fracbits, this.expbits, this.kind, this.sign, this.unscaled, this.scale);
    }

    protected void copyFrom(BigFloat other) {
        this.kind = other.kind;
        this.sign = other.sign;
        this.unscaled = other.unscaled;
        this.scale = other.scale;
    }

    public static BigFloat div(BigFloat a, BigFloat b) {
        BigFloat c = a.copy();
        c.div(b);
        return c;
    }

    public void div(BigFloat other) {
        if (this.isNaN() || other.isNaN()) {
            this.makeQuietNaN();
            return;
        }
        if (this.isInfinite()) {
            if (other.isInfinite()) {
                this.makeQuietNaN();
            } else {
                this.sign *= other.sign;
            }
            return;
        }
        switch (other.kind) {
            case QUIET_NAN: 
            case SIGNALING_NAN: {
                this.makeQuietNaN();
                return;
            }
            case INFINITE: {
                this.makeZero();
                this.sign *= other.sign;
                return;
            }
            case FINITE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected kind " + other.kind));
            }
        }
        if (other.isZero()) {
            if (this.isZero()) {
                this.makeQuietNaN();
            } else {
                this.kind = FloatKind.INFINITE;
                this.sign *= other.sign;
            }
            return;
        }
        int lshift = this.fracbits + 2 + other.unscaled.bitLength() - this.unscaled.bitLength();
        this.upscale(lshift);
        BigInteger[] qr = this.unscaled.divideAndRemainder(other.unscaled);
        BigInteger q = qr[0];
        BigInteger r = qr[1];
        this.sign *= other.sign;
        this.scale -= other.scale - this.fracbits;
        this.unscaled = q;
        this.internalRound(r.signum() != 0);
    }

    public static BigFloat mul(BigFloat a, BigFloat b) {
        BigFloat c = a.copy();
        c.mul(b);
        return c;
    }

    public void mul(BigFloat other) {
        if (this.isNaN() || other.isNaN()) {
            this.makeQuietNaN();
            return;
        }
        if (this.isZero() && other.isInfinite() || this.isInfinite() && other.isZero()) {
            this.makeQuietNaN();
            return;
        }
        if (this.isInfinite() || other.isInfinite()) {
            this.kind = FloatKind.INFINITE;
            this.sign *= other.sign;
            return;
        }
        this.sign *= other.sign;
        this.unscaled = this.unscaled.multiply(other.unscaled);
        this.scale += other.scale - this.fracbits;
        this.scaleUpTo(this.fracbits + 2);
        this.internalRound(false);
    }

    public static BigFloat add(BigFloat a, BigFloat b) {
        BigFloat c = a.copy();
        c.add(b);
        return c;
    }

    public void add(BigFloat other) {
        if (this.isNaN() || other.isNaN()) {
            this.makeQuietNaN();
            return;
        }
        if (this.isInfinite() && other.isInfinite()) {
            if (this.sign != other.sign) {
                this.makeQuietNaN();
            }
            return;
        }
        if (this.isInfinite()) {
            return;
        }
        if (other.isInfinite()) {
            this.copyFrom(other);
            return;
        }
        if (other.isZero()) {
            if (this.isZero()) {
                this.sign = this.sign < 0 && other.sign < 0 ? -1 : 1;
            }
            return;
        }
        if (this.isZero()) {
            this.copyFrom(other);
            return;
        }
        if (this.sign == other.sign) {
            this.add0(other);
        } else {
            this.sub0(other);
        }
    }

    public static BigFloat sub(BigFloat a, BigFloat b) {
        BigFloat c = b.copy();
        c.sign *= -1;
        c.add(a);
        if (c.isZero()) {
            c.sign = a.sign < 0 && b.sign > 0 ? -1 : 1;
        }
        return c;
    }

    public void sub(BigFloat other) {
        int thissign = this.sign;
        BigFloat nother = other.copy();
        nother.sign *= -1;
        this.add(nother);
        if (this.isZero()) {
            this.sign = thissign < 0 && nother.sign < 0 ? -1 : 1;
        }
    }

    protected void add0(BigFloat other) {
        BigFloat b;
        BigFloat a;
        int d = this.scale - other.scale;
        if (d > this.fracbits + 1) {
            return;
        }
        if (d < -(this.fracbits + 1)) {
            this.copyFrom(other);
            return;
        }
        if (d >= 0) {
            a = this;
            b = other;
        } else {
            d = -d;
            a = other;
            b = this;
        }
        boolean residue = b.unscaled.getLowestSetBit() < d - 1;
        this.scale = a.scale - 1;
        this.unscaled = a.unscaled.shiftLeft(1).add(b.unscaled.shiftRight(d - 1));
        this.scaleUpTo(this.fracbits + 2);
        this.internalRound(residue);
    }

    protected void sub0(BigFloat other) {
        BigFloat b;
        BigFloat a;
        int d = this.scale - other.scale;
        if (d > this.fracbits + 2) {
            return;
        }
        if (d < -(this.fracbits + 2)) {
            this.copyFrom(other);
            return;
        }
        if (d >= 0) {
            a = this;
            b = other;
        } else {
            d = -d;
            a = other;
            b = this;
        }
        boolean residue = b.unscaled.getLowestSetBit() < d - 2;
        this.sign = a.sign;
        this.scale = a.scale - 2;
        BigInteger x = b.unscaled;
        x = x.shiftRight(d - 2);
        if (residue) {
            x = x.add(BigInteger.ONE);
        }
        this.unscaled = a.unscaled.shiftLeft(2).subtract(x);
        if (this.unscaled.signum() == 0) {
            this.sign = 1;
        } else if (this.unscaled.signum() < 0) {
            this.sign *= -1;
            this.unscaled = this.unscaled.negate();
        }
        this.scaleUpTo(this.fracbits + 2);
        this.internalRound(residue);
    }

    public static BigFloat sqrt(BigFloat a) {
        BigFloat c = a.copy();
        c.sqrt();
        return c;
    }

    public void sqrt() {
        if (this.isZero()) {
            return;
        }
        if (this.isNaN() || this.sign == -1) {
            this.makeQuietNaN();
            return;
        }
        if (this.isInfinite()) {
            return;
        }
        int sigbits = 2 * this.fracbits + 3;
        this.scaleUpTo(sigbits);
        if ((this.scale + this.fracbits & 1) != 0) {
            this.upscale(1);
        }
        BigInteger residue = this.unscaled;
        BigInteger result = BigInteger.ZERO;
        int pow = residue.bitLength() - 1;
        pow -= pow & 1;
        BigInteger bit = BigInteger.ONE.shiftLeft(pow);
        while (bit.signum() != 0) {
            BigInteger resp1 = result.add(bit);
            if (residue.compareTo(resp1) >= 0) {
                residue = residue.subtract(resp1);
                result = result.add(bit.shiftLeft(1));
            }
            result = result.shiftRight(1);
            bit = bit.shiftRight(2);
        }
        this.unscaled = result;
        this.scale = (this.scale + this.fracbits) / 2;
        this.internalRound(residue.signum() != 0);
    }

    private void floor0() {
        if (this.scale < 0) {
            this.makeZero();
            return;
        }
        int nbitsUnderOne = this.fracbits - this.scale;
        this.unscaled = this.unscaled.shiftRight(nbitsUnderOne).shiftLeft(nbitsUnderOne);
    }

    private void makeOne() {
        this.kind = FloatKind.FINITE;
        this.scale = 0;
        this.unscaled = BigInteger.ONE.shiftLeft(this.fracbits);
    }

    private void ceil0() {
        if (this.isZero()) {
            return;
        }
        if (this.scale < 0) {
            this.makeOne();
            return;
        }
        int nbitsUnderOne = this.fracbits - this.scale;
        boolean increment = this.unscaled.getLowestSetBit() < nbitsUnderOne;
        this.unscaled = this.unscaled.shiftRight(nbitsUnderOne).shiftLeft(nbitsUnderOne);
        if (increment) {
            this.unscaled = this.unscaled.add(BigInteger.ONE.shiftLeft(nbitsUnderOne));
        }
        if (this.unscaled.bitLength() > this.fracbits + 1) {
            this.upscale(-1);
        }
    }

    public static BigFloat floor(BigFloat a) {
        BigFloat b = a.copy();
        b.floor();
        return b;
    }

    public void floor() {
        switch (this.kind) {
            case INFINITE: {
                return;
            }
            case SIGNALING_NAN: {
                this.makeQuietNaN();
            }
            case QUIET_NAN: {
                return;
            }
        }
        if (this.sign >= 0) {
            this.floor0();
        } else {
            this.ceil0();
        }
    }

    public static BigFloat ceil(BigFloat a) {
        BigFloat b = a.copy();
        b.ceil();
        return b;
    }

    public void ceil() {
        switch (this.kind) {
            case INFINITE: {
                return;
            }
            case SIGNALING_NAN: {
                this.makeQuietNaN();
            }
            case QUIET_NAN: {
                return;
            }
        }
        if (this.sign >= 0) {
            this.ceil0();
        } else {
            this.floor0();
        }
    }

    public static BigFloat trunc(BigFloat a) {
        BigFloat b = a.copy();
        b.trunc();
        return b;
    }

    public void trunc() {
        this.floor0();
    }

    public void negate() {
        this.sign *= -1;
    }

    public static BigFloat negate(BigFloat a) {
        BigFloat b = a.copy();
        b.negate();
        return b;
    }

    public static BigFloat abs(BigFloat a) {
        BigFloat b = a.copy();
        b.abs();
        return b;
    }

    public void abs() {
        this.sign = 1;
    }

    public BigInteger toBigInteger() {
        BigInteger res = this.unscaled.shiftRight(this.fracbits - this.scale);
        if (this.sign < 0) {
            return res.negate();
        }
        return res;
    }

    public static BigFloat round(BigFloat a) {
        BigFloat b = a.copy();
        b.round();
        return b;
    }

    public void round() {
        BigFloat half = new BigFloat(this.fracbits, this.expbits, FloatKind.FINITE, 1, BigInteger.ONE.shiftLeft(this.fracbits), -1);
        this.add(half);
        this.floor();
    }

    @Override
    public int compareTo(BigFloat other) {
        if (this.isNaN()) {
            if (other.isNaN()) {
                return 0;
            }
            return 1;
        }
        if (other.isNaN()) {
            return -1;
        }
        if (this.isInfinite()) {
            if (this.sign < 0) {
                if (other.isInfinite() && other.sign < 0) {
                    return 0;
                }
                return -1;
            }
            if (other.isInfinite() && other.sign > 0) {
                return 0;
            }
            return 1;
        }
        if (other.isInfinite()) {
            return -other.sign;
        }
        if (this.sign != other.sign) {
            return this.sign;
        }
        int c = Integer.compare(this.scale, other.scale);
        if (c != 0) {
            return c * this.sign;
        }
        return this.sign * this.unscaled.compareTo(other.unscaled);
    }
}

