/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.Next2InstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.SpecificSymbol;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class Next2Symbol
extends SpecificSymbol {
    private PatternExpression patexp;

    @Override
    public PatternExpression getPatternExpression() {
        return this.patexp;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) {
        hand.space = walker.getCurSpace();
        hand.offset_space = null;
        hand.offset_offset = walker.getN2addr().getOffset();
        hand.size = hand.space.getPointerSize();
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        long val = walker.getN2addr().getOffset();
        return "0x" + Long.toHexString(val);
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) {
        list.add(walker.getParentHandle());
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement element = parser.start(new String[]{"next2_sym"});
        this.patexp = new Next2InstructionValue();
        parser.end(element);
    }
}

