/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.error.DebuggerModelTypeException;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetAttachable;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointLocationContainer;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetConfigurable;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetDataTypeMember;
import ghidra.dbg.target.TargetDataTypeNamespace;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetDetachable;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetModuleContainer;
import ghidra.dbg.target.TargetNamedDataType;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.TargetSectionContainer;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetSymbol;
import ghidra.dbg.target.TargetSymbolNamespace;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.TargetTogglable;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.dbg.util.ValueUtils;
import ghidra.lifecycle.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public interface TargetObject
extends Comparable<TargetObject> {
    public static final Set<Class<? extends TargetObject>> ALL_INTERFACES = Set.of(TargetAccessConditioned.class, TargetActiveScope.class, TargetAggregate.class, TargetAttachable.class, TargetAttacher.class, TargetBreakpointLocation.class, TargetBreakpointLocationContainer.class, TargetBreakpointSpec.class, TargetBreakpointSpecContainer.class, TargetConfigurable.class, TargetConsole.class, TargetDataTypeMember.class, TargetDataTypeNamespace.class, TargetDeletable.class, TargetDetachable.class, TargetEnvironment.class, TargetEventScope.class, TargetExecutionStateful.class, TargetFocusScope.class, TargetInterpreter.class, TargetInterruptible.class, TargetKillable.class, TargetLauncher.class, TargetMemory.class, TargetMemoryRegion.class, TargetMethod.class, TargetModule.class, TargetModuleContainer.class, TargetNamedDataType.class, TargetProcess.class, TargetRegister.class, TargetRegisterBank.class, TargetRegisterContainer.class, TargetResumable.class, TargetSection.class, TargetSectionContainer.class, TargetStack.class, TargetStackFrame.class, TargetSteppable.class, TargetSymbol.class, TargetSymbolNamespace.class, TargetThread.class, TargetTogglable.class);
    public static final Map<String, Class<? extends TargetObject>> INTERFACES_BY_NAME = TargetObject.initInterfacesByName();
    public static final String PREFIX_INVISIBLE = "_";
    public static final String DISPLAY_ATTRIBUTE_NAME = "_display";
    public static final String SHORT_DISPLAY_ATTRIBUTE_NAME = "_short_display";
    public static final String KIND_ATTRIBUTE_NAME = "_kind";
    public static final String ORDER_ATTRIBUTE_NAME = "_order";
    public static final String MODIFIED_ATTRIBUTE_NAME = "_modified";
    public static final String TYPE_ATTRIBUTE_NAME = "_type";
    public static final String VALUE_ATTRIBUTE_NAME = "_value";

    @Internal
    public static Map<String, Class<? extends TargetObject>> initInterfacesByName() {
        return ALL_INTERFACES.stream().collect(Collectors.toUnmodifiableMap(DebuggerObjectModel::requireIfaceName, i -> i));
    }

    public static List<Class<? extends TargetObject>> getInterfacesByName(Collection<String> names) {
        return names.stream().filter(INTERFACES_BY_NAME::containsKey).map(INTERFACES_BY_NAME::get).collect(Collectors.toList());
    }

    default public boolean doEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetObject)) {
            return false;
        }
        TargetObject that = (TargetObject)obj;
        return this.getModel() == that.getModel() && Objects.equals(this.getPath(), that.getPath());
    }

    default public int computeHashCode() {
        return System.identityHashCode(this.getModel()) * 31 + Objects.hash(this.getPath().toArray());
    }

    public boolean equals(Object var1);

    public int hashCode();

    @Override
    default public int compareTo(TargetObject that) {
        DebuggerObjectModel thatModel;
        if (this == that) {
            return 0;
        }
        DebuggerObjectModel thisModel = this.getModel();
        if (thisModel != (thatModel = that.getModel())) {
            if (thisModel == null) {
                return -1;
            }
            if (thatModel == null) {
                return 1;
            }
            int result = thisModel.toString().compareTo(thatModel.toString());
            if (result == 0) {
                return Integer.compare(System.identityHashCode(thisModel), System.identityHashCode(thatModel));
            }
            return result;
        }
        return PathUtils.PathComparator.KEYED.compare(this.getPath(), that.getPath());
    }

    public DebuggerObjectModel getModel();

    public List<String> getPath();

    default public String getJoinedPath(String sep) {
        return PathUtils.toString(this.getPath(), sep);
    }

    default public String getName() {
        return PathUtils.getKey(this.getPath());
    }

    default public String getIndex() {
        return PathUtils.getIndex(this.getPath());
    }

    default public boolean isRoot() {
        return this.getPath().isEmpty();
    }

    public TargetObject getParent();

    public String getTypeHint();

    default public TargetObjectSchema getSchema() {
        return EnumerableTargetObjectSchema.OBJECT;
    }

    default public Collection<? extends Class<? extends TargetObject>> getInterfaces() {
        return Protected.getInterfacesOf(this.getClass());
    }

    default public Collection<String> getInterfaceNames() {
        return Protected.doGetInterfaceNamesOf(this.getClass());
    }

    public boolean isValid();

    default public CompletableFuture<? extends Map<String, ?>> fetchAttributes(boolean refresh) {
        return this.getModel().fetchObjectAttributes(this.getPath(), refresh);
    }

    default public CompletableFuture<? extends Map<String, ?>> fetchAttributes() {
        return this.fetchAttributes(false);
    }

    default public CompletableFuture<?> fetchAttribute(String name) {
        if (!PathUtils.isInvocation(name)) {
            return this.fetchAttributes().thenApply(m -> m.get(name));
        }
        Map<String, ?> cached = this.getCachedAttributes();
        if (cached.containsKey(name)) {
            return CompletableFuture.completedFuture(cached.get(name));
        }
        Map.Entry<String, String> invocation = PathUtils.parseInvocation(name);
        return this.fetchAttribute(invocation.getKey()).thenCompose(obj -> {
            if (!(obj instanceof TargetMethod)) {
                throw new DebuggerModelTypeException((String)invocation.getKey() + " is not a method");
            }
            TargetMethod method = (TargetMethod)obj;
            return method.invoke(Map.of("arg", (String)invocation.getValue()));
        });
    }

    public Map<String, ? extends TargetObject> getCachedElements();

    public Map<String, ? extends TargetObject> getCallbackElements();

    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchElements(boolean refresh) {
        return this.getModel().fetchObjectElements(this.getPath(), refresh);
    }

    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchElements() {
        return this.fetchElements(false);
    }

    default public CompletableFuture<? extends TargetObject> fetchElement(String index) {
        return this.getModel().fetchModelObject(PathUtils.index(this.getPath(), index));
    }

    default public CompletableFuture<? extends Map<String, ?>> fetchChildren(boolean refresh) {
        AsyncFence fence = new AsyncFence();
        TreeMap children = new TreeMap(PathUtils.TargetObjectKeyComparator.CHILD);
        fence.include((CompletableFuture)this.fetchElements(refresh).thenAccept(elements -> {
            for (Map.Entry ent : elements.entrySet()) {
                children.put(PathUtils.makeKey((String)ent.getKey()), ent.getValue());
            }
        }));
        fence.include((CompletableFuture)this.fetchAttributes(refresh).thenAccept(children::putAll));
        return fence.ready().thenApply(__ -> children);
    }

    default public CompletableFuture<? extends Map<String, ?>> fetchChildren() {
        return this.fetchChildren(false);
    }

    default public CompletableFuture<?> fetchChild(String key) {
        if (PathUtils.isIndex(key)) {
            return this.fetchElement(PathUtils.parseIndex(key));
        }
        return this.fetchAttribute(key);
    }

    default public <T extends TargetObject> CompletableFuture<? extends Map<String, ? extends T>> fetchChildrenSupporting(Class<T> iface) {
        return this.fetchChildren().thenApply(m -> m.entrySet().stream().filter(e -> iface.isAssignableFrom(e.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, e -> (TargetObject)iface.cast(e.getValue()))));
    }

    default public CompletableFuture<?> fetchValue(List<String> sub) {
        return this.getModel().fetchModelObject(PathUtils.extend(this.getPath(), sub));
    }

    default public CompletableFuture<?> fetchValue(String ... sub) {
        return this.fetchValue(List.of(sub));
    }

    default public CompletableFuture<? extends TargetObject> fetchSuccessor(List<String> sub) {
        return this.getModel().fetchModelObject(PathUtils.extend(this.getPath(), sub));
    }

    default public CompletableFuture<? extends TargetObject> fetchSuccessor(String ... sub) {
        return this.fetchSuccessor(List.of(sub));
    }

    default public TargetObject getSuccessor(List<String> sub) {
        return this.getModel().getModelObject(PathUtils.extend(this.getPath(), sub));
    }

    default public TargetObject getSuccessor(String ... sub) {
        return this.getSuccessor(List.of(sub));
    }

    default public CompletableFuture<? extends Map<String, ?>> fetchSubAttributes(List<String> sub) {
        return this.getModel().fetchObjectAttributes(PathUtils.extend(this.getPath(), sub));
    }

    default public CompletableFuture<? extends Map<String, ?>> fetchSubAttributes(String ... sub) {
        return this.fetchSubAttributes(List.of(sub));
    }

    default public CompletableFuture<?> fetchSubAttribute(List<String> sub) {
        return this.getModel().fetchObjectAttribute(PathUtils.extend(this.getPath(), sub));
    }

    default public CompletableFuture<?> fetchSubAttribute(String ... sub) {
        return this.fetchSubAttribute(List.of(sub));
    }

    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchSubElements(List<String> sub) {
        return this.getModel().fetchObjectElements(PathUtils.extend(this.getPath(), sub));
    }

    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchSubElements(String ... sub) {
        return this.fetchSubElements(List.of(sub));
    }

    @TargetAttributeType(name="_display", hidden=true)
    default public String getDisplay() {
        return this.getTypedAttributeNowByName(DISPLAY_ATTRIBUTE_NAME, String.class, this.getName());
    }

    @TargetAttributeType(name="_short_display", hidden=true)
    default public String getShortDisplay() {
        return this.getTypedAttributeNowByName(SHORT_DISPLAY_ATTRIBUTE_NAME, String.class, this.getDisplay());
    }

    @TargetAttributeType(name="_kind", fixed=true, hidden=true)
    default public String getKind() {
        return this.getTypedAttributeNowByName(KIND_ATTRIBUTE_NAME, String.class, this.getDisplay());
    }

    @TargetAttributeType(name="_order", hidden=true)
    default public Integer getOrder() {
        return this.getTypedAttributeNowByName(ORDER_ATTRIBUTE_NAME, Integer.class, null);
    }

    @TargetAttributeType(name="_modified", hidden=true)
    default public Boolean isModified() {
        return this.getTypedAttributeNowByName(MODIFIED_ATTRIBUTE_NAME, Boolean.class, null);
    }

    @TargetAttributeType(name="_type", hidden=true)
    default public String getType() {
        return this.getTypedAttributeNowByName(TYPE_ATTRIBUTE_NAME, String.class, null);
    }

    @TargetAttributeType(name="_value", hidden=true)
    default public Object getValue() {
        return this.getCachedAttribute(VALUE_ATTRIBUTE_NAME);
    }

    public CompletableFuture<Void> resync(boolean var1, boolean var2);

    default public CompletableFuture<Void> resync() {
        return this.resync(false, true);
    }

    public Object getProtocolID();

    default public <T extends TargetObject> T as(Class<T> iface) {
        return DebuggerObjectModel.requireIface(iface, this, this.getPath());
    }

    public Map<String, ?> getCachedAttributes();

    public Map<String, ?> getCallbackAttributes();

    default public Object getCachedAttribute(String name) {
        return this.getCachedAttributes().get(name);
    }

    default public <T> T getTypedAttributeNowByName(String name, Class<T> cls, T fallback) {
        Object obj = this.getCachedAttribute(name);
        TargetObjectSchema schema = this.getSchema();
        boolean required = schema.getAttributeSchema(name).isRequired();
        return ValueUtils.expectType(obj, cls, this, name, fallback, required);
    }

    default public CompletableFuture<Void> invalidateCaches() {
        return AsyncUtils.NIL;
    }

    default public void addListener(DebuggerModelListener l) {
        throw new UnsupportedOperationException();
    }

    default public void removeListener(DebuggerModelListener l) {
        throw new UnsupportedOperationException();
    }

    public static final class Protected
    extends Enum<Protected> {
        protected static final Map<Class<? extends TargetObject>, Collection<Class<? extends TargetObject>>> INTERFACES_BY_CLASS;
        protected static final Map<Class<? extends TargetObject>, Collection<String>> INTERFACE_NAMES_BY_CLASS;
        private static final /* synthetic */ Protected[] $VALUES;

        public static Protected[] values() {
            return (Protected[])$VALUES.clone();
        }

        public static Protected valueOf(String name) {
            return Enum.valueOf(Protected.class, name);
        }

        protected static Collection<Class<? extends TargetObject>> getInterfacesOf(Class<? extends TargetObject> cls) {
            return INTERFACES_BY_CLASS.computeIfAbsent(cls, Protected::doGetInterfacesOf);
        }

        protected static Collection<Class<? extends TargetObject>> doGetInterfacesOf(Class<? extends TargetObject> cls) {
            ArrayList<Class<? extends TargetObject>> result = new ArrayList<Class<? extends TargetObject>>();
            Protected.doCollectInterfaces(cls, result);
            return result;
        }

        protected static void doCollectInterfaces(Class<?> cls, Collection<Class<? extends TargetObject>> result) {
            Class<?> sup;
            if (TargetObject.class == cls) {
                return;
            }
            if (!TargetObject.class.isAssignableFrom(cls)) {
                return;
            }
            if (cls.isInterface()) {
                result.add(cls.asSubclass(TargetObject.class));
            }
            if ((sup = cls.getSuperclass()) != null) {
                Protected.doCollectInterfaces(sup, result);
            }
            for (Class<?> si : cls.getInterfaces()) {
                Protected.doCollectInterfaces(si, result);
            }
        }

        public static Collection<String> getInterfaceNamesOf(Class<? extends TargetObject> cls) {
            return INTERFACE_NAMES_BY_CLASS.computeIfAbsent(cls, Protected::doGetInterfaceNamesOf);
        }

        protected static Collection<String> doGetInterfaceNamesOf(Class<? extends TargetObject> cls) {
            ArrayList<String> result = new ArrayList<String>();
            for (Class<? extends TargetObject> iface : Protected.getInterfacesOf(cls)) {
                DebuggerTargetObjectIface annot = iface.getAnnotation(DebuggerTargetObjectIface.class);
                if (annot == null) continue;
                result.add(annot.value());
            }
            result.sort(Comparator.naturalOrder());
            return result;
        }

        private static /* synthetic */ Protected[] $values() {
            return new Protected[0];
        }

        static {
            $VALUES = Protected.$values();
            INTERFACES_BY_CLASS = new HashMap<Class<? extends TargetObject>, Collection<Class<? extends TargetObject>>>();
            INTERFACE_NAMES_BY_CLASS = new HashMap<Class<? extends TargetObject>, Collection<String>>();
        }
    }
}

