/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@DebuggerTargetObjectIface(value="Launcher")
public interface TargetLauncher
extends TargetObject {
    @TargetAttributeType(name="_parameters", required=true, hidden=true)
    default public TargetMethod.TargetParameterMap getParameters() {
        return TargetMethod.getParameters(this);
    }

    public CompletableFuture<Void> launch(Map<String, ?> var1);

    public static class CmdLineParser
    extends StreamTokenizer {
        public static List<String> tokenize(String cmdLine) {
            return new CmdLineParser(cmdLine).tokens();
        }

        public CmdLineParser(Reader r) {
            super(r);
            this.resetSyntax();
            this.wordChars(0, 255);
            this.whitespaceChars(32, 32);
            this.quoteChar(34);
        }

        public CmdLineParser(String cmdLine) {
            this(new StringReader(cmdLine));
        }

        public List<String> tokens() {
            ArrayList<String> list = new ArrayList<String>();
            try {
                while (-1 != this.nextToken()) {
                    list.add(this.sval);
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return list;
        }
    }

    public static interface TargetCmdLineLauncher
    extends TargetLauncher {
        public static final String CMDLINE_ARGS_NAME = "args";
        public static final TargetMethod.ParameterDescription<String> PARAMETER_CMDLINE_ARGS = TargetMethod.ParameterDescription.create(String.class, "args", true, "", "Command Line", "space-separated command-line arguments");
        public static final TargetMethod.TargetParameterMap PARAMETERS = TargetMethod.makeParameters(PARAMETER_CMDLINE_ARGS);

        @Override
        default public TargetMethod.TargetParameterMap getParameters() {
            return PARAMETERS;
        }

        public CompletableFuture<Void> launch(List<String> var1);

        default public CompletableFuture<Void> launch(String ... args) {
            return this.launch(Arrays.asList(args));
        }

        @Override
        default public CompletableFuture<Void> launch(Map<String, ?> args) {
            return this.launch(CmdLineParser.tokenize(PARAMETER_CMDLINE_ARGS.get(args)));
        }
    }
}

