/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import generic.concurrent.QCallback;
import generic.io.NullPrintWriter;
import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.extension.datatype.finder.AnonymousVariableAccessDR;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.app.extension.datatype.finder.DecompilerVariableType;
import ghidra.app.extension.datatype.finder.LocalVariableDR;
import ghidra.app.extension.datatype.finder.ParameterDR;
import ghidra.app.extension.datatype.finder.ReturnTypeDR;
import ghidra.app.extension.datatype.finder.VariableAccessDR;
import ghidra.app.extension.datatype.finder.VariableDR;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.DataTypeReference;
import ghidra.app.services.DataTypeReferenceFinder;
import ghidra.app.services.FieldMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.SetAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;

public class DecompilerDataTypeReferenceFinder
implements DataTypeReferenceFinder {
    public void findReferences(Program program, DataType dataType, Consumer<DataTypeReference> callback, TaskMonitor monitor) throws CancelledException {
        this.findReferences(program, dataType, null, callback, monitor);
    }

    public void findReferences(Program program, DataType dataType, String fieldName, Consumer<DataTypeReference> consumer, TaskMonitor monitor) throws CancelledException {
        FieldMatcher fieldMatcher = new FieldMatcher(dataType, fieldName);
        DecompilerDataTypeFinderQCallback qCallback = new DecompilerDataTypeFinderQCallback(program, dataType, fieldMatcher, consumer);
        this.doFindReferences(program, dataType, qCallback, consumer, monitor);
    }

    public void findReferences(Program program, FieldMatcher fieldMatcher, Consumer<DataTypeReference> consumer, TaskMonitor monitor) throws CancelledException {
        DataType dataType = fieldMatcher.getDataType();
        DecompilerDataTypeFinderQCallback qCallback = new DecompilerDataTypeFinderQCallback(program, dataType, fieldMatcher, consumer);
        this.doFindReferences(program, dataType, qCallback, consumer, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFindReferences(Program program, DataType dataType, DecompilerDataTypeFinderQCallback qCallback, Consumer<DataTypeReference> consumer, TaskMonitor monitor) throws CancelledException {
        Set<Function> functions = this.filterFunctions(program, dataType, monitor);
        try {
            ParallelDecompiler.decompileFunctions((QCallback)qCallback, functions, (TaskMonitor)monitor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!monitor.isCancelled()) {
                Msg.debug((Object)this, (Object)"Interrupted while decompiling functions");
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Encountered an exception decompiling functions", (Throwable)e);
        }
        finally {
            qCallback.dispose();
        }
    }

    private Set<Function> filterFunctions(Program program, DataType dt, TaskMonitor monitor) throws CancelledException {
        HashSet<DataType> types = new HashSet<DataType>();
        this.buildTypeLineage(dt, types);
        HashSet<Function> results = new HashSet<Function>();
        this.accumulateFunctionCallsToDefinedData(program, dt, types, results, monitor);
        Listing listing = program.getListing();
        FunctionIterator it = listing.getFunctions(true);
        for (Function f : it) {
            monitor.checkCanceled();
            if (results.contains(f) || !this.usesAnyType(f, types)) continue;
            results.add(f);
        }
        HashSet callers = new HashSet();
        for (Function f : results) {
            monitor.checkCanceled();
            Set callingFunctions = f.getCallingFunctions(monitor);
            callers.addAll(callingFunctions);
        }
        results.addAll(callers);
        return results;
    }

    private void accumulateFunctionCallsToDefinedData(Program program, DataType dataType, Set<DataType> potentialTypes, Set<Function> results, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        AtomicInteger counter = new AtomicInteger();
        SetAccumulator accumulator = new SetAccumulator();
        Predicate<Data> dataMatcher = data -> {
            counter.incrementAndGet();
            DataType dt = data.getDataType();
            boolean matches = potentialTypes.contains(dt);
            return matches;
        };
        FieldMatcher emptyMatcher = new FieldMatcher(dataType);
        ReferenceUtils.findDataTypeMatchesInDefinedData((Accumulator)accumulator, (Program)program, dataMatcher, (FieldMatcher)emptyMatcher, (TaskMonitor)monitor);
        for (LocationReference ref : accumulator) {
            Address address = ref.getLocationOfUse();
            Function f = listing.getFunctionContaining(address);
            if (f == null) continue;
            results.add(f);
        }
    }

    private void buildTypeLineage(DataType sourceType, Set<DataType> types) {
        if (types.contains(sourceType)) {
            return;
        }
        this.gatherRelatedTypes(sourceType, types);
        DataType baseType = DataTypeUtils.getBaseDataType((DataType)sourceType);
        if (types.contains(baseType)) {
            return;
        }
        if (baseType instanceof BuiltInDataType) {
            return;
        }
        this.gatherRelatedTypes(baseType, types);
    }

    private void gatherRelatedTypes(DataType dt, Set<DataType> types) {
        types.add(dt);
        for (DataType parent : dt.getParents()) {
            this.buildTypeLineage(parent, types);
        }
    }

    private boolean usesAnyType(Function f, Set<DataType> types) {
        Variable[] variables;
        DataType returnType = f.getReturnType();
        if (types.contains(returnType)) {
            return true;
        }
        for (Variable v : variables = f.getAllVariables()) {
            DataType paramType = v.getDataType();
            if (!types.contains(paramType) && !types.contains(ReferenceUtils.getBaseDataType((DataType)paramType))) continue;
            return true;
        }
        return false;
    }

    private static class DecompilerDataTypeFinderQCallback
    extends DecompilerCallback<List<DataTypeReference>> {
        private Consumer<DataTypeReference> callback;
        private DataType dataType;
        private FieldMatcher fieldMatcher;

        DecompilerDataTypeFinderQCallback(Program program, DataType dataType, FieldMatcher fieldMatcher, Consumer<DataTypeReference> callback) {
            super(program, (DecompileConfigurer)new DecompilerConfigurer());
            this.dataType = dataType;
            this.fieldMatcher = fieldMatcher;
            this.callback = callback;
        }

        public List<DataTypeReference> process(DecompileResults results, TaskMonitor monitor) throws Exception {
            Function function = results.getFunction();
            if (function.isThunk()) {
                return null;
            }
            DecompilerDataTypeFinder finder = new DecompilerDataTypeFinder(results, function, this.dataType, this.fieldMatcher);
            List<DataTypeReference> refs = finder.findUsage();
            refs.forEach(r -> this.callback.accept((DataTypeReference)r));
            return refs;
        }
    }

    private static class DecompilerDataTypeFinder {
        private DecompileResults decompilation;
        private Function function;
        private DataType dataType;
        private FieldMatcher fieldMatcher;
        private ByteArrayOutputStream debugBytes = new ByteArrayOutputStream();
        private PrintWriter debugWriter = new PrintWriter(this.debugBytes);

        DecompilerDataTypeFinder(DecompileResults results, Function function, DataType dataType, FieldMatcher fieldMatcher) {
            this.decompilation = results;
            this.function = function;
            this.dataType = dataType;
            this.fieldMatcher = fieldMatcher;
            this.debugWriter = SystemUtilities.isInTestingMode() ? new PrintWriter(this.debugBytes) : new NullPrintWriter();
        }

        List<DataTypeReference> findUsage() {
            ArrayList<DataTypeReference> refs = new ArrayList<DataTypeReference>();
            this.searchDecompilation(refs);
            return refs;
        }

        private void searchDecompilation(List<DataTypeReference> results) {
            ClangTokenGroup tokens = this.decompilation.getCCodeMarkup();
            if (tokens == null) {
                Msg.trace((Object)this, (Object)("Unable to get decompilation tokens for " + this.function.getName()));
                return;
            }
            this.debugWriter.println("f: " + this.function + "\n\tchecking vars...");
            List<DecompilerReference> variables = this.findVariableReferences(tokens);
            this.debugWriter.println("f: " + this.function + "\n\t...done checking");
            this.debugWriter.flush();
            String output = this.debugBytes.toString();
            if (!StringUtils.isBlank((CharSequence)output)) {
                Msg.debug((Object)this, (Object)("Final Debug:\n" + output));
            }
            variables.forEach(v -> this.matchUsage((DecompilerReference)v, results));
        }

        private void matchUsage(DecompilerReference reference, List<DataTypeReference> results) {
            reference.accumulateMatches(this.dataType, this.fieldMatcher, results);
        }

        private List<DecompilerReference> findVariableReferences(ClangTokenGroup tokens) {
            ArrayList lines = DecompilerUtils.toLines((ClangTokenGroup)tokens);
            ArrayList<DecompilerReference> result = new ArrayList<DecompilerReference>();
            for (ClangLine line : lines) {
                this.findVariablesInLine(line, result);
            }
            return result;
        }

        private void findVariablesInLine(ClangLine line, List<DecompilerReference> results) {
            ArrayList allTokens = line.getAllTokens();
            Iterable filteredTokens = IterableUtils.filteredIterable((Iterable)allTokens, token -> token instanceof ClangTypeToken || token instanceof ClangVariableToken || token instanceof ClangFieldToken);
            ArrayList<DecompilerVariableType> castsSoFar = new ArrayList<DecompilerVariableType>();
            VariableDR declaration = null;
            DecompilerReference access = null;
            for (ClangToken token2 : filteredTokens) {
                ArrayList<DecompilerVariable> casts;
                this.debugWriter.println("f: " + this.function + "\n\tchecking token: " + token2);
                if (token2 instanceof ClangTypeToken) {
                    if (token2.Parent() instanceof ClangReturnType) {
                        this.debugWriter.println("f: " + this.function + "\n\t\treturn type: " + line);
                        results.add(new ReturnTypeDR(line, (ClangTypeToken)token2));
                        continue;
                    }
                    if (token2.isVariableRef()) {
                        if (this.isFunctionPrototype(token2.Parent())) {
                            this.debugWriter.println("f: " + this.function + "\n\t\tparameter: " + line);
                            declaration = new ParameterDR(line, (ClangTypeToken)token2);
                        } else {
                            this.debugWriter.println("f: " + this.function + "\n\t\tlocal var: " + line);
                            declaration = new LocalVariableDR(line, (ClangTypeToken)token2);
                        }
                        results.add(declaration);
                        continue;
                    }
                    this.debugWriter.println("f: " + this.function + "\n\t\tadding a cast");
                    castsSoFar.add(new DecompilerVariableType(token2));
                    continue;
                }
                if (token2 instanceof ClangVariableToken) {
                    if (declaration != null) {
                        this.debugWriter.println("f: " + this.function + "\n\t\thave declaration - " + declaration);
                        declaration.setVariable((ClangVariableToken)token2);
                        declaration = null;
                        continue;
                    }
                    if (access == null || access.getVariable() != null) {
                        this.debugWriter.println("f: " + this.function + "\n\t\tcreating variable access: " + line);
                        access = new VariableAccessDR(line);
                        results.add(access);
                    }
                    casts = new ArrayList(castsSoFar);
                    ((VariableAccessDR)access).setVariable((ClangVariableToken)token2, casts);
                    castsSoFar.clear();
                    continue;
                }
                if (!(token2 instanceof ClangFieldToken)) continue;
                casts = new ArrayList<DecompilerVariable>(castsSoFar);
                if (access == null && (access = this.getLastAccess(results)) == null) {
                    Msg.debug((Object)this, (Object)("Found a field access without a preceding variable for\n\tline: " + line + "\n\tfield: " + token2 + "\n\tfunction: " + this.function));
                    continue;
                }
                ClangFieldToken field = (ClangFieldToken)token2;
                if (this.typesDoNotMatch((VariableAccessDR)access, field)) {
                    this.debugWriter.println("f: " + this.function + "\n\t\tcreating an anonymous variable access: " + line);
                    results.add(new AnonymousVariableAccessDR(line, field));
                    continue;
                }
                ((VariableAccessDR)access).addField(field, casts);
                castsSoFar.clear();
            }
        }

        private boolean typesDoNotMatch(VariableAccessDR access, ClangFieldToken field) {
            DecompilerVariable variable = access.getVariable();
            if (variable == null) {
                return false;
            }
            DataType fieldDt = DecompilerReference.getFieldDataType(field);
            DataType variableDt = variable.getDataType();
            return !DecompilerReference.isEqual(variableDt, fieldDt);
        }

        private VariableAccessDR getLastAccess(List<DecompilerReference> variables) {
            if (variables.isEmpty()) {
                return null;
            }
            DecompilerReference last = variables.get(variables.size() - 1);
            if (last instanceof VariableAccessDR) {
                return (VariableAccessDR)last;
            }
            return null;
        }

        private boolean isFunctionPrototype(ClangNode node) {
            while (!(node instanceof ClangFuncProto) && node != null) {
                node = node.Parent();
            }
            return node instanceof ClangFuncProto;
        }

        private void dumpTokens(ClangTokenGroup tokens, int depth) {
            int n = tokens.numChildren();
            for (int i = 0; i < n; ++i) {
                ClangNode child = tokens.Child(i);
                this.doDumpTokens(child, depth);
            }
        }

        private void doDumpTokens(ClangNode node, int depth) {
            if (node instanceof ClangTokenGroup) {
                this.dumpTokens((ClangTokenGroup)node, depth + 1);
                return;
            }
            if (node instanceof ClangBreak) {
                System.err.print("\n");
                int tabs = depth * 4;
                String asString = StringUtilities.pad((String)"", (char)' ', (int)tabs);
                System.err.print(asString);
            } else {
                String text = node.toString();
                System.err.print(" '" + text + "' ");
            }
            ClangToken token = (ClangToken)node;
            int n = node.numChildren();
            for (int i = 0; i < n; ++i) {
                ClangNode child = token.Child(i);
                this.doDumpTokens(child, depth + 1);
            }
        }

        private void dumpTokenNames(ClangTokenGroup tokens, int depth) {
            System.err.print(" '" + tokens.getClass().getSimpleName());
            int n = tokens.numChildren();
            for (int i = 0; i < n; ++i) {
                ClangNode child = tokens.Child(i);
                this.doDumpTokenNames(child, depth);
            }
        }

        private void doDumpTokenNames(ClangNode node, int depth) {
            if (node instanceof ClangTokenGroup) {
                this.dumpTokenNames((ClangTokenGroup)node, depth + 1);
                return;
            }
            if (node instanceof ClangBreak) {
                System.err.print("\n");
                int tabs = depth * 4;
                String asString = StringUtilities.pad((String)"", (char)' ', (int)tabs);
                System.err.print(asString);
            } else {
                System.err.print(" '" + node.getClass().getSimpleName() + "' ['" + node.toString() + "'] ");
            }
            ClangToken token = (ClangToken)node;
            int n = node.numChildren();
            for (int i = 0; i < n; ++i) {
                ClangNode child = token.Child(i);
                this.doDumpTokenNames(child, depth + 1);
            }
        }
    }

    private static class DecompilerConfigurer
    implements DecompileConfigurer {
        private DecompilerConfigurer() {
        }

        public void configure(DecompInterface decompiler) {
            decompiler.toggleCCode(true);
            decompiler.toggleSyntaxTree(true);
            decompiler.setSimplificationStyle("decompile");
            DecompileOptions xmlOptions = new DecompileOptions();
            xmlOptions.setDefaultTimeout(60);
            decompiler.setOptions(xmlOptions);
        }
    }
}

