/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyContext;
import ghidra.feature.vt.gui.task.ClearMatchTask;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class ClearMatchAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_UnEdit";
    private static final Icon ICON = ResourceManager.loadImage((String)"images/undo-apply.png");
    private final VTController controller;

    public ClearMatchAction(VTController controller) {
        super("Clear", VTPlugin.OWNER);
        this.controller = controller;
        this.setToolBarData(new ToolBarData(ICON, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{"Clear"}, ICON, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Clear_Match"));
    }

    public void actionPerformed(ActionContext context) {
        List<VTMatch> selectedMatches;
        if (context instanceof VTMatchContext) {
            matchContext = (VTMatchContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else if (context instanceof VTMatchOneToManyContext) {
            matchContext = (VTMatchOneToManyContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else {
            return;
        }
        ClearMatchTask task = new ClearMatchTask(this.controller, selectedMatches);
        this.controller.runVTTask(task);
        this.controller.refresh();
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMatch> selectedMatches;
        if (context instanceof VTMatchContext) {
            VTMatchContext matchContext = (VTMatchContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else if (context instanceof VTMatchOneToManyContext) {
            VTMatchOneToManyContext matchContext = (VTMatchOneToManyContext)context;
            selectedMatches = matchContext.getSelectedMatches();
        } else {
            selectedMatches = new ArrayList<VTMatch>();
        }
        return selectedMatches.size() > 0;
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

