/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.widgets.EventTrigger;
import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.support.BackgroundColorModel;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.bookmark.BookmarkNavigator;
import ghidra.app.plugin.core.codebrowser.MarkerServiceBackgroundColorModel;
import ghidra.app.plugin.core.diff.ApplyDiffCommand;
import ghidra.app.plugin.core.diff.CreateDiffTask;
import ghidra.app.plugin.core.diff.DiffActionManager;
import ghidra.app.plugin.core.diff.DiffApplySettingsOptionManager;
import ghidra.app.plugin.core.diff.DiffApplySettingsProvider;
import ghidra.app.plugin.core.diff.DiffController;
import ghidra.app.plugin.core.diff.DiffControllerListener;
import ghidra.app.plugin.core.diff.DiffDetailsProvider;
import ghidra.app.plugin.core.diff.DiffNavigatable;
import ghidra.app.plugin.core.diff.DiffServiceProvider;
import ghidra.app.plugin.core.diff.DiffTaskListener;
import ghidra.app.plugin.core.diff.ExecuteDiffDialog;
import ghidra.app.plugin.core.diff.NextDiffCommand;
import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.CoordinatedListingPanelListener;
import ghidra.app.services.DiffService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.listingpanel.ProgramSelectionListener;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.app.util.viewer.util.FieldNavigator;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.main.OpenVersionedFileDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffDetails;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramMemoryComparator;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.program.util.ProgramSelection;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import help.Help;
import help.HelpService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays Program differences", description="Extends the CodeBrowser plugin to show a second program side-by-side with the current program.  This plugin also computes differences between the two programs and allows the user to apply differences from the second program ontothe first.", servicesRequired={GoToService.class, CodeViewerService.class, MarkerService.class}, servicesProvided={DiffService.class}, eventsProduced={ProgramSelectionPluginEvent.class, ViewChangedPluginEvent.class}, eventsConsumed={ProgramClosedPluginEvent.class, ViewChangedPluginEvent.class})
public class ProgramDiffPlugin
extends ProgramPlugin
implements ProgramLocationListener,
ProgramSelectionListener,
DiffControllerListener,
DiffService,
OptionsChangeListener,
DomainObjectListener {
    private ImageIcon CURSOR_LOC_ICON = ResourceManager.loadImage((String)"images/cursor_arrow.gif");
    private static final String SELECTION_GROUP = "Selection Colors";
    private static final String DIFF_HIGHLIGHT_COLOR_NAME = "Selection Colors.Difference Color";
    private Color diffHighlightColor = new Color(255, 230, 180);
    private Color cursorHighlightColor;
    protected static final HelpService help = Help.getHelpService();
    private GoToService goToService;
    private CodeViewerService codeViewerService;
    private MarkerManager markerManager;
    private MarkerSet p2SelectionMarkers;
    private MarkerSet p2DiffMarkers;
    private MarkerSet p1DiffMarkers;
    private MarkerSet p2CursorMarkers;
    private Map<BookmarkType, BookmarkNavigator> bookmarkMap;
    private boolean isLimitedToSelection;
    private ProgramDiffFilter execDiffFilter;
    private ProgramMergeFilter applyFilter;
    private boolean showDetails = false;
    private boolean showApplySettings = false;
    private boolean showingSecondProgram = false;
    private boolean sameProgramContext = false;
    private DiffActionManager actionManager;
    private ListingPanel diffListingPanel;
    private Navigatable diffNavigatable;
    private FieldNavigator diffFieldNavigator;
    private volatile boolean taskInProgress;
    private ExecuteDiffDialog executeDiffDialog;
    private AddressSetView p1ViewAddrSet;
    private AddressSetView addressesOnlyInP1;
    private AddressSetView compatibleOnlyInP2;
    private DiffController diffControl;
    private Program primaryProgram;
    private Program secondaryDiffProgram;
    private AddressFactory p2AddressFactory;
    private ProgramDiffDetails diffDetails;
    private ProgramSelection p2DiffHighlight;
    private ProgramSelection p2Selection;
    private DiffApplySettingsProvider diffApplySettingsProvider;
    private DiffDetailsProvider diffDetailsProvider;
    private boolean settingLocation;
    private ActionListener okListener;
    private DiffTaskListener diffTaskListener = DiffTaskListener.NULL_LISTENER;
    private ProgramLocation previousP1Location;
    private ApplySettingsActionListener applySettingsListener;
    private DiffDetailsActionListener diffDetailsListener;
    DiffApplySettingsOptionManager applySettingsMgr;
    private boolean isHighlightCursorLine;
    private Program activeProgram;
    private OpenVersionedFileDialog openProgramDialog;

    public ProgramDiffPlugin(PluginTool tool) {
        super(tool);
        this.markerManager = new MarkerManager((Plugin)this);
        this.actionManager = new DiffActionManager(this);
        this.p2Selection = new ProgramSelection();
        this.p2DiffHighlight = new ProgramSelection();
        this.bookmarkMap = new HashMap<BookmarkType, BookmarkNavigator>();
        this.addressesOnlyInP1 = new AddressSet();
        this.compatibleOnlyInP2 = new AddressSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void programLocationChanged(ProgramLocation p2Loc, EventTrigger trigger) {
        AddressSpace p1Space;
        AddressSpace p2Space;
        ProgramLocation equivalentP1Loc;
        if (trigger == EventTrigger.MODEL_CHANGE) {
            return;
        }
        if (this.primaryProgram == null || this.primaryProgram != this.currentProgram || !this.showingSecondProgram) {
            return;
        }
        Address p2LocationAddress = p2Loc.getAddress();
        ProgramLocation p1Loc = p2Loc;
        if (p2LocationAddress.getAddressSpace().isOverlaySpace() && (equivalentP1Loc = DiffUtility.getCompatibleProgramLocation((Program)this.secondaryDiffProgram, (ProgramLocation)p2Loc, (Program)this.primaryProgram)) != null && !(p2Space = p2LocationAddress.getAddressSpace()).equals(p1Space = equivalentP1Loc.getAddress().getAddressSpace())) {
            p1Loc = equivalentP1Loc;
        }
        if (!this.settingLocation && !p1Loc.equals((Object)this.currentLocation)) {
            MarkerSet cursorMarkers = this.getCursorMarkers();
            Address p1LocationAddress = p1Loc.getAddress();
            cursorMarkers.setAddressSet((AddressSetView)new AddressSet(p2LocationAddress));
            this.previousP1Location = this.currentLocation;
            this.currentLocation = p1Loc;
            if (this.diffControl != null) {
                try {
                    this.settingLocation = true;
                    this.diffControl.setLocation(p1LocationAddress);
                }
                finally {
                    this.settingLocation = false;
                }
            }
            if (this.secondaryDiffProgram != null) {
                try {
                    this.settingLocation = true;
                    this.codeViewerServiceGoTo(p1Loc);
                }
                finally {
                    this.settingLocation = false;
                }
            }
            if (this.diffDetailsProvider != null && this.diffDetails != null) {
                this.diffDetailsProvider.locationChanged(p1Loc);
            }
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ViewChangedPluginEvent) {
            AddressSet set = ((ViewChangedPluginEvent)event).getView();
            if (this.primaryProgram != null && this.showingSecondProgram) {
                this.addressesOnlyInP1 = new AddressSet();
                this.compatibleOnlyInP2 = new AddressSet();
                AddressSet addressSet = new AddressSet((AddressSetView)this.primaryProgram.getMemory());
                if (set.equals((Object)addressSet) && this.secondaryDiffProgram != null) {
                    try {
                        ProgramMemoryComparator programMemoryComparator = new ProgramMemoryComparator(this.primaryProgram, this.secondaryDiffProgram);
                        set = ProgramMemoryComparator.getCombinedAddresses((Program)this.primaryProgram, (Program)this.secondaryDiffProgram);
                        this.addressesOnlyInP1 = programMemoryComparator.getAddressesOnlyInOne();
                        this.compatibleOnlyInP2 = programMemoryComparator.getCompatibleAddressesOnlyInTwo();
                    }
                    catch (ProgramConflictException e) {
                        Msg.error((Object)this, (Object)("Diff encountered a problem while changing the view. " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            this.viewChanged((AddressSetView)set);
        } else {
            super.processEvent(event);
        }
    }

    protected void programClosed(Program program) {
        if (this.primaryProgram == program) {
            this.primaryProgram.removeListener((DomainObjectListener)this);
            if (this.secondaryDiffProgram != null) {
                this.closeProgram2();
            }
            this.actionManager.programClosed(program);
        }
    }

    private void viewChanged(AddressSetView p1AddressSet) {
        if (this.primaryProgram != null && !this.showingSecondProgram) {
            return;
        }
        this.p1ViewAddrSet = p1AddressSet;
        if (this.showingSecondProgram) {
            ProgramSelection previousP1Selection = this.currentSelection;
            ProgramSelection previousP2DiffHighlight = this.p2DiffHighlight;
            ProgramSelection previousP2Selection = this.p2Selection;
            FieldPanel fp = this.diffListingPanel.getFieldPanel();
            AddressSet p1AddressSetAsP2 = DiffUtility.getCompatibleAddressSet((AddressSetView)p1AddressSet, (Program)this.secondaryDiffProgram);
            AddressIndexMap p2IndexMap = new AddressIndexMap((AddressSetView)p1AddressSetAsP2);
            this.markerManager.getOverviewProvider().setProgram(this.secondaryDiffProgram, p2IndexMap);
            fp.setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel((MarkerService)this.markerManager, p2IndexMap));
            this.currentSelection = previousP1Selection;
            this.p2DiffHighlight = previousP2DiffHighlight;
            this.p2Selection = previousP2Selection;
            this.setProgram2Selection(this.p2Selection);
            if (this.p2DiffHighlight != null) {
                this.setDiffHighlight(this.p2DiffHighlight);
            }
        }
    }

    @Override
    public void differencesChanged(DiffController diffController) {
        this.setDiffHighlight();
        this.updatePgm2Enablement();
        if (this.diffDetailsProvider != null) {
            this.diffDetailsProvider.refreshDetails(this.currentLocation);
        }
    }

    @Override
    public void diffLocationChanged(DiffController diffController, Address program1Location) {
        if (!this.settingLocation) {
            this.goToServiceGoTo(new ProgramLocation(this.primaryProgram, program1Location));
        }
        this.updatePgm2Enablement();
    }

    @Override
    public boolean inProgress() {
        return this.taskInProgress;
    }

    private boolean launchDiffOnOpenProgram() {
        try {
            if (this.diffControl != null) {
                this.clearDiff();
            }
            this.diff(this.p1ViewAddrSet);
            return true;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean launchDiff(DomainFile otherProgram) {
        if (this.openSecondProgram(otherProgram)) {
            return this.launchDiffOnOpenProgram();
        }
        return false;
    }

    @Override
    public boolean launchDiff(Program otherProgram) {
        try {
            if (this.diffControl != null) {
                this.clearDiff();
            }
            if (this.openSecondProgram(otherProgram, null)) {
                this.secondaryDiffProgram.addConsumer((Object)this);
                this.diff(this.p1ViewAddrSet);
            }
            return true;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void optionsChanged(ToolOptions options, String optionsName, Object oldValue, Object newValue) {
        Color panelColor;
        MarkerSet selectionMarkers;
        Color markColor;
        boolean diffHighlightChanged = false;
        if (options.getName().equals("Listing Fields")) {
            if (optionsName.equals(DIFF_HIGHLIGHT_COLOR_NAME)) {
                this.diffHighlightColor = (Color)newValue;
                diffHighlightChanged = true;
            } else if (optionsName.equals("Cursor.Highlight Cursor Line Color")) {
                this.cursorHighlightColor = (Color)newValue;
                if (this.p2CursorMarkers != null) {
                    this.p2CursorMarkers.setMarkerColor(this.cursorHighlightColor);
                }
            } else if (optionsName.equals("Cursor.Highlight Cursor Line")) {
                this.isHighlightCursorLine = (Boolean)newValue;
                if (this.p2CursorMarkers != null) {
                    this.p2CursorMarkers.setColoringBackground(this.isHighlightCursorLine);
                }
            }
        }
        if (this.secondaryDiffProgram == null) {
            return;
        }
        if (diffHighlightChanged) {
            this.diffHighlightColor = (Color)newValue;
            MarkerSet diffMarkers = this.getDiffMarkers();
            diffMarkers.setMarkerColor(this.diffHighlightColor);
            MarkerSet codeViewerDiffMarkers = this.getCodeViewerMarkers();
            codeViewerDiffMarkers.setMarkerColor(this.diffHighlightColor);
            this.adjustDiffDisplay();
        }
        if (!(markColor = (selectionMarkers = this.getSelectionMarkers()).getMarkerColor()).equals(panelColor = this.diffListingPanel.getFieldPanel().getSelectionColor())) {
            selectionMarkers.setMarkerColor(panelColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void locationChanged(ProgramLocation location) {
        if (!this.showingSecondProgram) {
            return;
        }
        if (location == null) {
            return;
        }
        if (this.settingLocation) {
            return;
        }
        if (location.equals((Object)this.previousP1Location)) {
            return;
        }
        if (location.isValid(this.primaryProgram)) {
            this.previousP1Location = location;
        } else {
            ProgramLocation newP1Location;
            Address addr = location.getAddress();
            Address byteAddr = location.getByteAddress();
            Address refAddr = location.getRefAddress();
            Address primaryAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.secondaryDiffProgram, (Address)addr, (Program)this.primaryProgram);
            if (primaryAddr == null) {
                return;
            }
            Address primaryByteAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.secondaryDiffProgram, (Address)byteAddr, (Program)this.primaryProgram);
            if (primaryByteAddr == null) {
                primaryByteAddr = primaryAddr;
            }
            Address primaryRefAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.secondaryDiffProgram, (Address)refAddr, (Program)this.primaryProgram);
            this.previousP1Location = newP1Location = new ProgramLocation(this.primaryProgram, primaryAddr, primaryByteAddr, location.getComponentPath(), primaryRefAddr, 0, 0, 0);
        }
        Address p1LocationAddress = this.previousP1Location.getAddress();
        Address p2LocationAddress = SimpleDiffUtility.getCompatibleAddress((Program)this.primaryProgram, (Address)p1LocationAddress, (Program)this.secondaryDiffProgram);
        if (p2LocationAddress != null) {
            MarkerSet cursorMarkers = this.getCursorMarkers();
            cursorMarkers.setAddressSet((AddressSetView)new AddressSet(p2LocationAddress));
        }
        try {
            ProgramLocation previousP1LocationAsP2;
            this.settingLocation = true;
            if (this.diffControl != null) {
                this.diffControl.setLocation(this.previousP1Location.getAddress());
            }
            if ((previousP1LocationAsP2 = DiffUtility.getCompatibleProgramLocation((Program)this.primaryProgram, (ProgramLocation)location, (Program)this.secondaryDiffProgram)) != null) {
                this.diffListingPanel.setCursorPosition(previousP1LocationAsP2);
            }
            if (this.diffDetailsProvider != null && this.diffDetails != null) {
                this.diffDetailsProvider.locationChanged(this.previousP1Location);
            }
        }
        finally {
            this.settingLocation = false;
        }
    }

    void setOpenDiffProgramDialog(OpenVersionedFileDialog dialog) {
        this.openProgramDialog = dialog;
    }

    private void setActiveProgram(Program newActiveProgram) {
        if (this.primaryProgram == null && newActiveProgram != null) {
            this.p1ViewAddrSet = newActiveProgram.getMemory();
        }
        this.actionManager.setActiveProgram(newActiveProgram);
        if (this.activeProgram == this.primaryProgram) {
            this.hideDiff();
        } else if (newActiveProgram == this.primaryProgram && newActiveProgram != null) {
            this.showDiff(newActiveProgram);
        }
        this.activeProgram = newActiveProgram;
    }

    protected void hideDiff() {
        boolean isShowingApplySettings;
        boolean isShowingDiffDetails;
        this.actionManager.removeActions();
        this.removeSecondView();
        boolean bl = isShowingDiffDetails = this.diffDetailsProvider != null && this.tool.isVisible((ComponentProvider)this.diffDetailsProvider);
        if (isShowingDiffDetails) {
            this.hideDiffDetails();
        }
        this.showDetails = isShowingDiffDetails;
        boolean bl2 = isShowingApplySettings = this.diffApplySettingsProvider != null && this.tool.isVisible((ComponentProvider)this.diffApplySettingsProvider);
        if (isShowingApplySettings) {
            this.hideDiffApplySettings();
        }
        this.showApplySettings = isShowingApplySettings;
        this.clearMarkers();
    }

    protected void showDiff(Program program) {
        this.actionManager.addActions();
        this.showSecondView();
        if (this.showDetails) {
            this.showDiffDetails();
        }
        if (this.showApplySettings) {
            this.showDiffApplySettings();
        }
    }

    protected void selectionChanged(ProgramSelection p1Selection) {
        if (!this.showingSecondProgram) {
            return;
        }
        if (this.currentSelection == null) {
            AddressFactory p1AddressFactory = this.primaryProgram != null ? this.primaryProgram.getAddressFactory() : null;
            this.currentSelection = new ProgramSelection(p1AddressFactory);
        }
        this.actionManager.setP1SelectToP2ActionEnabled(this.secondaryDiffProgram != null && !this.currentSelection.isEmpty());
    }

    protected void dispose() {
        if (this.secondaryDiffProgram != null) {
            this.closeProgram2();
        }
        if (this.diffListingPanel != null) {
            this.diffListingPanel.removeButtonPressedListener((ButtonPressedListener)this.diffFieldNavigator);
            this.diffFieldNavigator = null;
            this.diffNavigatable = null;
            this.diffListingPanel = null;
        }
        if (this.diffApplySettingsProvider != null) {
            this.diffApplySettingsProvider.removeActionListener(this.applySettingsListener);
        }
        if (this.diffDetailsProvider != null) {
            this.diffDetailsProvider.removeActionListener(this.diffDetailsListener);
        }
        this.actionManager.dispose();
        this.applySettingsMgr.dispose();
        this.markerManager.dispose();
        this.codeViewerService.setCoordinatedListingPanelListener(null);
    }

    protected void init() {
        this.codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class);
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        FormatManager formatManager = this.codeViewerService.getFormatManager();
        DiffServiceProvider diffServiceProvider = new DiffServiceProvider(formatManager.getServiceProvider(), this);
        this.diffListingPanel = new ListingPanel(formatManager);
        this.diffListingPanel.setProgramLocationListener((ProgramLocationListener)this);
        this.diffListingPanel.setProgramSelectionListener((ProgramSelectionListener)this);
        this.diffListingPanel.getFieldPanel().addFieldMouseListener((FieldMouseListener)new MyFieldMouseListener());
        this.diffListingPanel.addMarginProvider((MarginProvider)this.markerManager.getMarginProvider());
        this.diffListingPanel.addOverviewProvider(this.markerManager.getOverviewProvider());
        this.diffNavigatable = new DiffNavigatable(this, this.codeViewerService.getNavigatable());
        this.diffFieldNavigator = new FieldNavigator((ServiceProvider)diffServiceProvider, this.diffNavigatable);
        this.diffListingPanel.addButtonPressedListener((ButtonPressedListener)this.diffFieldNavigator);
        help.registerHelp((Object)this.diffListingPanel, new HelpLocation("Diff", "Program_Differences"));
        GoToService diffMarkerGoToService = (GoToService)diffServiceProvider.getService(GoToService.class);
        this.markerManager.setGoToService(diffMarkerGoToService);
        this.actionManager.setCodeViewerService(this.codeViewerService);
        this.setupOptions();
        this.execDiffFilter = new ProgramDiffFilter(Short.MAX_VALUE);
        this.isLimitedToSelection = false;
        this.applySettingsMgr = new DiffApplySettingsOptionManager((Plugin)this);
        this.applyFilter = this.applySettingsMgr.getDefaultApplyFilter();
        this.codeViewerService.setCoordinatedListingPanelListener(new CoordinatedListingPanelListener(){

            public void activeProgramChanged(Program newActiveProgram) {
                ProgramDiffPlugin.this.setActiveProgram(newActiveProgram);
            }

            public boolean listingClosed() {
                if (ProgramDiffPlugin.this.primaryProgram != null) {
                    ProgramDiffPlugin.this.closeProgram2();
                    return true;
                }
                return false;
            }
        });
    }

    synchronized boolean isTaskInProgress() {
        return this.taskInProgress;
    }

    synchronized void setTaskInProgress(boolean inProgress) {
        this.taskInProgress = inProgress;
        this.updatePgm2Enablement();
        this.diffTaskListener.taskInProgress(inProgress);
    }

    void setDiffTaskListener(DiffTaskListener listener) {
        this.diffTaskListener = listener;
    }

    Address getCurrentAddress() {
        if (this.currentLocation != null) {
            return this.currentLocation.getAddress();
        }
        return null;
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    DiffController getDiffController() {
        return this.diffControl;
    }

    void setDiffController(DiffController dc) {
        this.diffControl = dc;
        this.execDiffFilter = this.diffControl.getDiffFilter();
        this.diffControl.addDiffControllerListener(this);
    }

    ProgramSelection getCurrentSelection() {
        if (this.currentSelection == null) {
            AddressFactory p1AddressFactory = this.primaryProgram != null ? this.primaryProgram.getAddressFactory() : null;
            this.currentSelection = new ProgramSelection(p1AddressFactory);
        }
        return this.currentSelection;
    }

    DiffApplySettingsProvider getDiffApplySettingsProvider() {
        if (this.diffApplySettingsProvider == null) {
            this.diffApplySettingsProvider = new DiffApplySettingsProvider(this);
        }
        if (this.secondaryDiffProgram != null && this.applySettingsListener == null) {
            this.addApplySettingsProviderComponent();
        }
        return this.diffApplySettingsProvider;
    }

    void addApplySettingsProviderComponent() {
        this.tool.addComponentProvider((ComponentProvider)this.diffApplySettingsProvider, false);
        this.applySettingsListener = new ApplySettingsActionListener();
        this.diffApplySettingsProvider.addActionListener(this.applySettingsListener);
        this.diffApplySettingsProvider.addActions();
    }

    void removeApplySettingsProviderComponent() {
        this.diffApplySettingsProvider.removeActionListener(this.applySettingsListener);
        this.applySettingsListener = null;
        this.tool.removeComponentProvider((ComponentProvider)this.diffApplySettingsProvider);
    }

    DiffDetailsProvider getDiffDetailsProvider() {
        if (this.diffDetailsProvider == null) {
            this.diffDetailsProvider = new DiffDetailsProvider(this);
        }
        if (this.secondaryDiffProgram != null && this.diffDetailsListener == null) {
            this.addDiffDetailsProviderComponent();
        }
        return this.diffDetailsProvider;
    }

    void addDiffDetailsProviderComponent() {
        this.tool.addComponentProvider((ComponentProvider)this.diffDetailsProvider, false);
        this.diffDetailsListener = new DiffDetailsActionListener();
        this.diffDetailsProvider.addActionListener(this.diffDetailsListener);
        this.diffDetailsProvider.addActions();
    }

    void removeDiffDetailsProviderComponent() {
        this.diffDetailsProvider.removeActionListener(this.diffDetailsListener);
        this.diffDetailsListener = null;
        this.tool.removeComponentProvider((ComponentProvider)this.diffDetailsProvider);
    }

    public void programSelectionChanged(ProgramSelection newP2Selection, EventTrigger trigger) {
        if (trigger != EventTrigger.GUI_ACTION) {
            return;
        }
        this.setProgram2Selection(newP2Selection);
    }

    void setProgram2Selection(ProgramSelection newP2Selection) {
        ProgramSelection intersection;
        if (this.primaryProgram == null || this.primaryProgram != this.currentProgram || !this.showingSecondProgram) {
            return;
        }
        ProgramSelection p2CodeUnitSelection = new ProgramSelection((AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)newP2Selection, (Program)this.secondaryDiffProgram));
        AddressFactory p1AddressFactory = this.primaryProgram != null ? this.primaryProgram.getAddressFactory() : null;
        this.p2Selection = intersection = new ProgramSelection(this.p2AddressFactory, (AddressSetView)p2CodeUnitSelection.intersect((AddressSetView)this.p2DiffHighlight));
        AddressSet p2SelectionAsP1Set = DiffUtility.getCompatibleAddressSet((AddressSetView)this.p2Selection, (Program)this.primaryProgram);
        ProgramSelection p2SelectionAsP1 = new ProgramSelection(p1AddressFactory, (AddressSetView)p2SelectionAsP1Set);
        this.runSwing(() -> {
            MarkerSet selectionMarkers = this.getSelectionMarkers();
            selectionMarkers.clearAll();
            selectionMarkers.add((AddressSetView)this.p2Selection);
        });
        this.diffListingPanel.setSelection(p2SelectionAsP1);
        this.updatePgm2Enablement();
        if (!SystemUtilities.isEqual((Object)p2SelectionAsP1, (Object)this.currentSelection)) {
            this.currentSelection = p2SelectionAsP1;
            this.actionManager.setP1SelectToP2ActionEnabled(this.secondaryDiffProgram != null && !this.currentSelection.isEmpty());
            this.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), new ProgramSelection(p1AddressFactory, (AddressSetView)this.currentSelection), this.primaryProgram));
        }
    }

    ProgramSelection getProgram2Selection() {
        return this.p2Selection;
    }

    boolean isShowingDiff() {
        return this.showingSecondProgram;
    }

    void applyDiffAndGoNext() {
        this.applyDiff();
        NextDiffCommand nextCmd = new NextDiffCommand(this);
        this.tool.executeBackgroundCommand((BackgroundCommand)nextCmd, (UndoableDomainObject)this.primaryProgram);
    }

    void applyDiff() {
        if (!this.applyIsSet()) {
            this.tool.setStatusInfo("At least one difference type must be set to 'Replace' or 'Merge' in the " + this.diffApplySettingsProvider.getName() + ".", true);
            return;
        }
        if (this.primaryProgram.getCurrentTransaction() != null) {
            String msg = "Cannot apply differences while another task is modifying \"" + this.primaryProgram.getName() + "\".\nTry again when the currently executing task has completed.";
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Apply Differences", (Object)msg);
            return;
        }
        AddressSet p2SelectionAsP1 = DiffUtility.getCompatibleAddressSet((AddressSetView)this.p2Selection, (Program)this.primaryProgram);
        AddressSet p1ApplySet = p2SelectionAsP1.intersect(this.p1ViewAddrSet).subtract(this.addressesOnlyInP1).subtract(this.compatibleOnlyInP2);
        if (p1ApplySet.isEmpty()) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Apply Differences", (Object)(this.p2Selection.isEmpty() ? "No diff selection in the current view." : "Nothing can be applied from the current selection."));
            return;
        }
        ApplyDiffCommand applyCmd = new ApplyDiffCommand(this, (AddressSetView)p1ApplySet, this.diffControl);
        this.tool.executeBackgroundCommand((BackgroundCommand)applyCmd, (UndoableDomainObject)this.primaryProgram);
    }

    private boolean applyIsSet() {
        if (this.diffControl == null) {
            return false;
        }
        ProgramMergeFilter filter = this.diffControl.getMergeFilter();
        filter.setFilter(32768, 0);
        return filter.isSet();
    }

    void adjustDiffDisplay() {
        this.tool.getToolFrame().setCursor(Cursor.getPredefinedCursor(0));
        this.setDiffHighlight();
        MarkerSet diffMarkers = this.getDiffMarkers();
        diffMarkers.setMarkerColor(this.diffHighlightColor);
        this.setProgram2Selection(this.p2Selection);
        this.updatePgm2Enablement();
    }

    private void setDiffHighlight() {
        ProgramSelection p2DiffSelection;
        if (this.diffControl == null) {
            return;
        }
        AddressSetView p1DiffSet = null;
        try {
            p1DiffSet = this.diffControl.getFilteredDifferences(TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        AddressSet p2DiffSet = DiffUtility.getCompatibleAddressSet((AddressSetView)p1DiffSet, (Program)this.secondaryDiffProgram);
        this.p2DiffHighlight = p2DiffSelection = new ProgramSelection(this.p2AddressFactory, (AddressSetView)p2DiffSet);
        AddressSet p2DiffSetAsP1 = DiffUtility.getCompatibleAddressSet((AddressSetView)p2DiffSet, (Program)this.primaryProgram);
        this.runSwing(() -> {
            MarkerSet diffMarkers = this.getDiffMarkers();
            diffMarkers.clearAll();
            diffMarkers.add((AddressSetView)p2DiffSet);
            MarkerSet codeViewerDiffMarkers = this.getCodeViewerMarkers();
            codeViewerDiffMarkers.clearAll();
            codeViewerDiffMarkers.add((AddressSetView)p2DiffSetAsP1);
            this.diffListingPanel.getFieldPanel().repaint();
        });
    }

    private void setDiffHighlight(ProgramSelection p2Highlight) {
        if (this.diffControl == null) {
            return;
        }
        MarkerSet diffMarkers = this.getDiffMarkers();
        MarkerSet codeViewerDiffMarkers = this.getCodeViewerMarkers();
        diffMarkers.clearAll();
        codeViewerDiffMarkers.clearAll();
        if (p2Highlight != null && this.secondaryDiffProgram != null && this.diffControl != null) {
            AddressSet p1DiffHighlightSet = DiffUtility.getCompatibleAddressSet((AddressSetView)p2Highlight, (Program)this.primaryProgram);
            this.p2DiffHighlight = p2Highlight;
            diffMarkers.add((AddressSetView)p2Highlight);
            codeViewerDiffMarkers.add((AddressSetView)p1DiffHighlightSet);
        }
        this.updatePgm2Enablement();
    }

    void nextDiff() {
        this.tool.clearStatusInfo();
        if (this.diffControl.hasNext()) {
            this.diffControl.next();
        }
        this.setProgram2Selection(new ProgramSelection(this.p2AddressFactory, this.getDiffHighlightBlock()));
    }

    void previousDiff() {
        this.tool.clearStatusInfo();
        if (this.diffControl.hasPrevious()) {
            this.diffControl.previous();
        }
        this.setProgram2Selection(new ProgramSelection(this.p2AddressFactory, this.getDiffHighlightBlock()));
    }

    private void clearDiff() {
        if (this.diffApplySettingsProvider != null) {
            this.removeApplySettingsProviderComponent();
        }
        if (this.diffDetailsProvider != null) {
            this.removeDiffDetailsProviderComponent();
        }
        if (this.executeDiffDialog != null) {
            this.executeDiffDialog.close();
        }
        if (this.diffControl != null) {
            this.clearDiffMarkers();
            this.p2DiffHighlight = new ProgramSelection();
            this.clearCodeViewerDiffMarkers();
            this.setProgram2Selection(new ProgramSelection());
            this.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), new ProgramSelection(), this.primaryProgram));
            this.diffControl.removeDiffControllerListener(this);
            this.diffControl = null;
        }
        this.updatePgm2Enablement();
    }

    void diff() {
        this.diff(this.createLimitingSet());
    }

    void diff(AddressSetView p1LimitSet) {
        boolean reload;
        if (this.taskInProgress) {
            Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Can't Start Another Diff", (Object)"A Diff or Apply is already in progress.");
            return;
        }
        boolean bl = reload = this.diffControl != null;
        if (reload) {
            this.reloadDiff(p1LimitSet);
        } else {
            this.createDiff(p1LimitSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ignoreDiff() {
        JFrame frame = this.tool.getToolFrame();
        try {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            this.tool.clearStatusInfo();
            AddressSet p2ViewAddrSet = DiffUtility.getCompatibleAddressSet((AddressSetView)this.p1ViewAddrSet, (Program)this.secondaryDiffProgram);
            AddressSet p2IgnoreSet = this.p2Selection.intersect((AddressSetView)p2ViewAddrSet);
            if (p2IgnoreSet.isEmpty()) {
                Msg.showError(this.getClass(), (Component)frame, (String)"Ignore Selection and Goto Next Difference", (Object)"No diff selection in the current view.");
                return;
            }
            AddressSet p1IgnoreSet = DiffUtility.getCompatibleAddressSet((AddressSetView)p2IgnoreSet, (Program)this.primaryProgram);
            this.diffControl.ignore((AddressSetView)p1IgnoreSet, null);
            this.p2DiffHighlight = new ProgramSelection(this.p2AddressFactory, (AddressSetView)this.p2DiffHighlight.subtract((AddressSetView)p2IgnoreSet));
            this.adjustDiffDisplay();
        }
        finally {
            this.diffListingPanel.getFieldPanel().requestFocus();
            frame.setCursor(Cursor.getDefaultCursor());
            NextDiffCommand nextCmd = new NextDiffCommand(this);
            this.tool.executeBackgroundCommand((BackgroundCommand)nextCmd, (UndoableDomainObject)this.primaryProgram);
        }
    }

    void hideDiffApplySettings() {
        this.tool.showComponentProvider((ComponentProvider)this.diffApplySettingsProvider, false);
    }

    void showDiffApplySettings() {
        if (!this.tool.isVisible((ComponentProvider)this.diffApplySettingsProvider)) {
            this.tool.showComponentProvider((ComponentProvider)this.diffApplySettingsProvider, true);
        }
    }

    void hideDiffDetails() {
        if (this.diffDetailsProvider != null) {
            this.tool.showComponentProvider((ComponentProvider)this.diffDetailsProvider, false);
        }
    }

    void showDiffDetails() {
        DiffDetailsProvider detailsProvider = this.getDiffDetailsProvider();
        if (this.tool.isVisible((ComponentProvider)detailsProvider)) {
            detailsProvider.refreshDetails(this.currentLocation);
        } else {
            this.tool.showComponentProvider((ComponentProvider)detailsProvider, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectAllDiffs() {
        JFrame frame = this.tool.getToolFrame();
        try {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            this.tool.clearStatusInfo();
            AddressSetView adjustedView = this.p1ViewAddrSet;
            if (this.secondaryDiffProgram != null && this.primaryProgram != null && this.p1ViewAddrSet.contains((AddressSetView)new AddressSet((AddressSetView)this.primaryProgram.getMemory()))) {
                adjustedView = ProgramMemoryComparator.getCombinedAddresses((Program)this.primaryProgram, (Program)this.secondaryDiffProgram);
            }
            AddressSet p2ViewAddrSet = DiffUtility.getCompatibleAddressSet((AddressSetView)adjustedView, (Program)this.secondaryDiffProgram);
            this.setProgram2Selection(new ProgramSelection(this.p2AddressFactory, (AddressSetView)p2ViewAddrSet));
        }
        finally {
            this.diffListingPanel.getFieldPanel().requestFocus();
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    void closeProgram2() {
        this.codeViewerService.removeListingPanel(this.diffListingPanel);
        this.showingSecondProgram = false;
        this.diffListingPanel.setProgram(null);
        this.p2Selection = new ProgramSelection();
        this.setProgram2Selection(this.p2Selection);
        this.clearDiff();
        if (this.secondaryDiffProgram != null) {
            for (BookmarkNavigator nav : this.bookmarkMap.values()) {
                nav.dispose();
            }
            this.bookmarkMap.clear();
            this.actionManager.secondProgramClosed();
            this.secondaryDiffProgram.release((Object)this);
            this.diffDetails = null;
            this.clearMarkers();
            this.addressesOnlyInP1 = new AddressSet();
            this.compatibleOnlyInP2 = new AddressSet();
            this.primaryProgram.removeListener((DomainObjectListener)this);
            this.primaryProgram = null;
            this.secondaryDiffProgram = null;
            this.p2AddressFactory = null;
        }
        this.sameProgramContext = false;
        this.updatePgm2Enablement();
    }

    CodeViewerService getCodeViewerService() {
        return this.codeViewerService;
    }

    void selectProgram2() {
        if (this.primaryProgram != null) {
            String msg = this.primaryProgram.getDomainFile().getName() + " already has a Diff view. Only one is allowed at a time.";
            this.tool.setStatusInfo(msg, true);
            Msg.showWarn((Object)this, (Component)this.diffListingPanel, (String)"Diff Already In Progress", (Object)msg);
            return;
        }
        OpenVersionedFileDialog dialog = this.getOpenProgramDialog();
        this.okListener = e -> {
            this.tool.clearStatusInfo();
            JComponent component = dialog.getComponent();
            DomainObject dobj = dialog.getVersionedDomainObject((Object)this, false);
            if (dobj != null) {
                if (this.openSecondProgram((Program)dobj, component)) {
                    dialog.close();
                    this.launchDiffOnOpenProgram();
                }
                return;
            }
            DomainFile df = dialog.getDomainFile();
            if (df != null) {
                if (this.openSecondProgram(df)) {
                    dialog.close();
                    this.launchDiffOnOpenProgram();
                }
                return;
            }
            this.displayStatus(component, "Can't Open Selected Program", "Please select a file, not a folder.", 1);
        };
        dialog.addOkActionListener(this.okListener);
        dialog.showComponent();
        this.actionManager.setOpenCloseActionSelected(this.secondaryDiffProgram != null);
        this.getDiffDetailsProvider();
    }

    private OpenVersionedFileDialog getOpenProgramDialog() {
        if (this.openProgramDialog != null) {
            return this.openProgramDialog;
        }
        OpenVersionedFileDialog dialog = new OpenVersionedFileDialog(this.tool, "Select Other Program", f -> {
            Class c = f.getDomainObjectClass();
            return Program.class.isAssignableFrom(c);
        });
        dialog.setTreeSelectionMode(1);
        dialog.setHelpLocation(new HelpLocation("Diff", "Open_Close_Program_View"));
        return dialog;
    }

    void displayExecuteDiff() {
        if (this.executeDiffDialog == null) {
            this.executeDiffDialog = new ExecuteDiffDialog();
            this.executeDiffDialog.addActionListener(new DiffActionListener());
        }
        if (this.executeDiffDialog != null) {
            this.executeDiffDialog.configure(this.primaryProgram, this.secondaryDiffProgram, (AddressSetView)this.currentSelection, this.execDiffFilter);
            this.executeDiffDialog.setPgmContextEnabled(this.sameProgramContext);
            this.tool.showDialog((DialogComponentProvider)this.executeDiffDialog);
        }
    }

    void setP1SelectionOnP2() {
        if (!this.currentSelection.isEmpty()) {
            AddressSet p2SelectionSet = DiffUtility.getCompatibleAddressSet((AddressSetView)this.currentSelection, (Program)this.secondaryDiffProgram);
            this.setProgram2Selection(new ProgramSelection(this.p2AddressFactory, (AddressSetView)DiffUtility.getCodeUnitSet((AddressSetView)p2SelectionSet, (Program)this.secondaryDiffProgram)));
        }
        if (this.p2Selection.isEmpty()) {
            this.tool.setStatusInfo("No highlights in second program for the selection.", true);
        }
    }

    Program getFirstProgram() {
        return this.primaryProgram;
    }

    Program getSecondProgram() {
        return this.secondaryDiffProgram;
    }

    void activeProgram(Program program) {
        ProgramManager programManager = (ProgramManager)this.tool.getService(ProgramManager.class);
        programManager.setCurrentProgram(program);
    }

    void addDiffDetails(Address p1Address, StyledDocument doc) {
        if (this.diffDetails != null) {
            this.diffDetails.getAllDetails(p1Address, doc, this.getDiffCountInfo(p1Address));
        } else {
            try {
                doc.insertString(doc.getLength(), "Don't have a second program open.", new SimpleAttributeSet());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    void addFilteredDiffDetails(Address p1Address, ProgramDiffFilter filter, StyledDocument doc) {
        if (this.diffDetails != null) {
            this.diffDetails.getDetails(p1Address, filter, doc, this.getDiffCountInfo(p1Address));
        } else {
            try {
                doc.insertString(doc.getLength(), "Don't have a second program open.", new SimpleAttributeSet());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    ListingPanel getListingPanel() {
        return this.diffListingPanel;
    }

    ProgramSelection getDiffHighlightSelection() {
        return this.p2DiffHighlight;
    }

    AddressSetView getDetailsAddressSet(Address p1Address) {
        if (this.diffDetails != null) {
            return this.diffDetails.getDetailsAddressSet(p1Address);
        }
        return null;
    }

    private AddressSetView createLimitingSet() {
        if (this.primaryProgram == null) {
            return null;
        }
        if (this.executeDiffDialog != null) {
            return this.executeDiffDialog.getAddressSet();
        }
        AddressSet limitSet = new AddressSet((AddressSetView)this.primaryProgram.getMemory());
        limitSet = limitSet.union(this.compatibleOnlyInP2);
        if (this.currentSelection != null && !this.currentSelection.isEmpty()) {
            limitSet = limitSet.intersect((AddressSetView)this.currentSelection);
        }
        return limitSet;
    }

    private void reloadDiff(AddressSetView p1LimitSet) {
        if (this.diffControl == null) {
            this.createDiff(p1LimitSet);
        } else {
            this.tool.clearStatusInfo();
            if (p1LimitSet == null) {
                p1LimitSet = this.createLimitingSet();
            }
            this.displayExecuteDiff();
        }
    }

    private void createDiff(AddressSetView p1LimitSet) {
        JFrame frame = this.tool.getToolFrame();
        try {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            this.tool.clearStatusInfo();
            if (this.secondaryDiffProgram == null) {
                this.selectProgram2();
                if (this.secondaryDiffProgram == null) {
                    return;
                }
            }
            if (this.executeDiffDialog != null) {
                this.executeDiffDialog.close();
                this.executeDiffDialog = null;
            }
            if (p1LimitSet == null) {
                p1LimitSet = this.createLimitingSet();
            }
            this.displayExecuteDiff();
        }
        finally {
            frame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void updatePgm2Enablement() {
        boolean hasProgram2 = this.secondaryDiffProgram != null;
        boolean inDiff = this.diffControl != null;
        boolean hasHighlights = this.p2DiffHighlight != null && !this.p2DiffHighlight.isEmpty();
        AddressSet possibleAddresses = new AddressSet(this.p1ViewAddrSet);
        if (this.p1ViewAddrSet != null && this.primaryProgram != null && this.p1ViewAddrSet.equals(this.primaryProgram.getMemory())) {
            possibleAddresses.add(this.compatibleOnlyInP2);
        }
        boolean hasSelectionInView = false;
        if (hasProgram2) {
            AddressSet possibleP2Addresses = DiffUtility.getCompatibleAddressSet((AddressSetView)possibleAddresses, (Program)this.secondaryDiffProgram);
            hasSelectionInView = !this.p2Selection.intersect((AddressSetView)possibleP2Addresses).isEmpty();
        }
        this.actionManager.updateActions(this.taskInProgress, inDiff, hasSelectionInView, this.applyIsSet(), hasProgram2, hasHighlights);
    }

    private void codeViewerServiceGoTo(ProgramLocation loc) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.codeViewerService.goTo(loc, false);
        } else {
            Runnable runner = () -> this.codeViewerService.goTo(loc, false);
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException e) {
                SwingUtilities.invokeLater(runner);
            }
            catch (InvocationTargetException e) {
                Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)"Encountered an unexpected exception calling codeViewerService.goTo(ProgramLocation,boolean).", (Throwable)e);
            }
        }
    }

    private void goToServiceGoTo(ProgramLocation loc) {
        this.previousP1Location = this.currentLocation;
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.currentProgram.getMemory().contains(loc.getAddress())) {
                this.goToService.goTo(loc);
            } else {
                this.diffListingPanel.goTo(loc, true);
            }
        } else {
            Runnable runner = () -> this.goToService.goTo(loc);
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException e) {
                SwingUtilities.invokeLater(runner);
            }
            catch (InvocationTargetException e) {
                Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)"Encountered an unexpected exception calling goToService.goTo(ProgramLocation,boolean).", (Throwable)e);
            }
        }
    }

    private void setupOptions() {
        Color c;
        String OPTIONS_TITLE = "Listing Fields";
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        opt.registerOption(DIFF_HIGHLIGHT_COLOR_NAME, (Object)this.diffHighlightColor, new HelpLocation("CodeBrowserPlugin", "Browser_Fields"), "Color used to highlight differences between two programs.");
        this.diffHighlightColor = c = opt.getColor(DIFF_HIGHLIGHT_COLOR_NAME, this.diffHighlightColor);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        this.cursorHighlightColor = opt.getColor("Cursor.Highlight Cursor Line Color", null);
        this.isHighlightCursorLine = opt.getBoolean("Cursor.Highlight Cursor Line", false);
    }

    private MarkerSet getSelectionMarkers() {
        if (this.p2SelectionMarkers != null) {
            return this.p2SelectionMarkers;
        }
        FieldPanel fp = this.diffListingPanel.getFieldPanel();
        this.p2SelectionMarkers = this.markerManager.createAreaMarker("Selection", "Selection Display", this.secondaryDiffProgram, 100, false, true, false, fp.getSelectionColor());
        return this.p2SelectionMarkers;
    }

    private MarkerSet getDiffMarkers() {
        if (this.p2DiffMarkers != null) {
            return this.p2DiffMarkers;
        }
        this.p2DiffMarkers = this.markerManager.createAreaMarker("Difference", "Diff Display", this.secondaryDiffProgram, 80, false, true, true, this.diffHighlightColor);
        return this.p2DiffMarkers;
    }

    private MarkerSet getCursorMarkers() {
        if (this.p2CursorMarkers != null) {
            return this.p2CursorMarkers;
        }
        this.p2CursorMarkers = this.markerManager.createPointMarker("Cursor", "Cursor Location", this.secondaryDiffProgram, 200, true, true, this.isHighlightCursorLine, this.cursorHighlightColor, (Icon)this.CURSOR_LOC_ICON);
        return this.p2CursorMarkers;
    }

    private MarkerSet getCodeViewerMarkers() {
        MarkerService markerService = (MarkerService)this.tool.getService(MarkerService.class);
        if (markerService == null) {
            return null;
        }
        if (this.p1DiffMarkers != null) {
            return this.p1DiffMarkers;
        }
        this.p1DiffMarkers = markerService.createAreaMarker("Difference", "Diff Display", this.primaryProgram, 80, false, true, true, this.diffHighlightColor);
        return this.p1DiffMarkers;
    }

    private void clearMarkers() {
        this.clearSelectionMarkers();
        this.clearDiffMarkers();
        this.clearCursorMarkers();
        this.clearCodeViewerDiffMarkers();
    }

    private void clearSelectionMarkers() {
        if (this.p2SelectionMarkers == null) {
            return;
        }
        this.markerManager.removeMarker(this.p2SelectionMarkers, this.secondaryDiffProgram);
        this.p2SelectionMarkers = null;
    }

    private void clearDiffMarkers() {
        if (this.p2DiffMarkers == null) {
            return;
        }
        this.markerManager.removeMarker(this.p2DiffMarkers, this.secondaryDiffProgram);
        this.p2DiffMarkers = null;
    }

    private void clearCursorMarkers() {
        if (this.p2CursorMarkers == null) {
            return;
        }
        this.markerManager.removeMarker(this.p2CursorMarkers, this.secondaryDiffProgram);
        this.p2CursorMarkers = null;
    }

    private void clearCodeViewerDiffMarkers() {
        if (this.p1DiffMarkers == null) {
            return;
        }
        MarkerService markerService = (MarkerService)this.tool.getService(MarkerService.class);
        if (markerService == null) {
            return;
        }
        markerService.removeMarker(this.p1DiffMarkers, this.primaryProgram);
        this.p1DiffMarkers = null;
    }

    private boolean openSecondProgram(DomainFile df) {
        Program newProgram;
        OpenSecondProgramTask task = new OpenSecondProgramTask(df);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame(), 500);
        if (!task.wasCanceled() && (newProgram = task.getDiffProgram()) != null) {
            return this.openSecondProgram(newProgram, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openSecondProgram(Program newProgram, JComponent selectDialog) {
        int selectedOption;
        if (newProgram == null) {
            this.displayStatus(selectDialog, "Can't Open Selected Program", "Couldn't open second program.", 0);
            return false;
        }
        if (!ProgramMemoryComparator.similarPrograms((Program)this.currentProgram, (Program)newProgram)) {
            newProgram.release((Object)this);
            String message = "Programs languages don't match.\n" + this.currentProgram.getName() + " (" + this.currentProgram.getLanguageID() + ")\n" + newProgram.getName() + " (" + newProgram.getLanguageID() + ")";
            this.displayStatus(selectDialog, "Can't Open Selected Program", message, 0);
            return false;
        }
        ProgramMemoryComparator programMemoryComparator = null;
        try {
            programMemoryComparator = new ProgramMemoryComparator(this.currentProgram, newProgram);
        }
        catch (ProgramConflictException e) {
            Msg.error((Object)this, (Object)"Unexpected exception creating memory comparator", (Throwable)e);
            return false;
        }
        this.addressesOnlyInP1 = programMemoryComparator.getAddressesOnlyInOne();
        this.compatibleOnlyInP2 = programMemoryComparator.getCompatibleAddressesOnlyInTwo();
        AddressSet addressesInCommon = programMemoryComparator.getAddressesInCommon();
        AddressSet combinedAddresses = ProgramMemoryComparator.getCombinedAddresses((Program)this.currentProgram, (Program)newProgram);
        if (addressesInCommon.isEmpty() && (selectedOption = OptionDialog.showYesNoDialog((Component)selectDialog, (String)"No Memory In Common", (String)"The two programs have no memory addresses in common.\nDo you want to continue?")) != 1) {
            newProgram.release((Object)this);
            return false;
        }
        if (this.secondaryDiffProgram != null) {
            this.closeProgram2();
        }
        this.primaryProgram = this.currentProgram;
        this.secondaryDiffProgram = newProgram;
        this.p2AddressFactory = this.secondaryDiffProgram.getAddressFactory();
        this.applyFilter = this.applySettingsMgr.getDefaultApplyFilter();
        this.diffDetails = new ProgramDiffDetails(this.primaryProgram, this.secondaryDiffProgram);
        this.primaryProgram.addListener((DomainObjectListener)this);
        try {
            this.settingLocation = true;
            this.diffListingPanel.setProgram(this.secondaryDiffProgram);
            AddressSet p2ViewAddrSet = DiffUtility.getCompatibleAddressSet((AddressSetView)this.p1ViewAddrSet, (Program)this.secondaryDiffProgram);
            this.diffListingPanel.setView((AddressSetView)p2ViewAddrSet);
            if (this.p1ViewAddrSet.contains((AddressSetView)this.primaryProgram.getMemory())) {
                this.firePluginEvent((PluginEvent)new ViewChangedPluginEvent(this.getName(), null, combinedAddresses));
            }
            FieldPanel fp = this.diffListingPanel.getFieldPanel();
            this.showSecondView();
            AddressIndexMap indexMap = this.diffListingPanel.getAddressIndexMap();
            fp.setBackgroundColorModel((BackgroundColorModel)new MarkerServiceBackgroundColorModel((MarkerService)this.markerManager, this.secondaryDiffProgram, indexMap));
        }
        finally {
            this.settingLocation = false;
        }
        this.setupBookmarkNavigators();
        this.sameProgramContext = ProgramMemoryComparator.sameProgramContextRegisterNames((Program)this.primaryProgram, (Program)this.secondaryDiffProgram);
        this.actionManager.secondProgramOpened();
        this.actionManager.addActions();
        this.diffListingPanel.goTo(this.currentLocation);
        MarkerSet cursorMarkers = this.getCursorMarkers();
        Address currentP2Address = this.currentLocation.getAddress();
        if (this.currentLocation.getProgram() != this.secondaryDiffProgram) {
            currentP2Address = SimpleDiffUtility.getCompatibleAddress((Program)this.currentLocation.getProgram(), (Address)this.currentLocation.getAddress(), (Program)this.secondaryDiffProgram);
        }
        if (currentP2Address != null) {
            cursorMarkers.setAddressSet((AddressSetView)new AddressSet(currentP2Address));
        }
        this.updatePgm2Enablement();
        if (this.diffControl != null) {
            this.clearDiff();
        }
        return true;
    }

    private void runSwing(Runnable r) {
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)r);
    }

    private void showSecondView() {
        this.codeViewerService.setListingPanel(this.diffListingPanel);
        this.activeProgram = this.primaryProgram;
        this.showingSecondProgram = true;
    }

    private void removeSecondView() {
        this.codeViewerService.removeListingPanel(this.diffListingPanel);
        this.showingSecondProgram = false;
        this.actionManager.removeActions();
    }

    private void displayStatus(JComponent parent, String title, String message, int dialogType) {
        Container parentComponent = parent;
        if (parentComponent == null) {
            parentComponent = this.tool.getToolFrame();
        }
        switch (dialogType) {
            case -1: {
                Msg.showInfo(this.getClass(), (Component)parent, (String)title, (Object)message);
                break;
            }
            case 1: {
                Msg.showInfo(this.getClass(), (Component)parent, (String)title, (Object)message);
                break;
            }
            case 2: {
                Msg.showWarn(this.getClass(), (Component)parent, (String)title, (Object)message);
                break;
            }
            case 0: {
                Msg.showError(this.getClass(), (Component)parent, (String)title, (Object)message);
            }
        }
    }

    private AddressSetView getDiffHighlightBlock() {
        if (this.diffControl == null) {
            return new AddressSet();
        }
        Address p1DiffAddress = this.diffControl.getCurrentAddress();
        Address p2DiffAddress = SimpleDiffUtility.getCompatibleAddress((Program)this.primaryProgram, (Address)p1DiffAddress, (Program)this.secondaryDiffProgram);
        AddressRange range = this.p2DiffHighlight.getRangeContaining(p2DiffAddress);
        if (range == null) {
            return new AddressSet();
        }
        return new AddressSet(range);
    }

    private void setupBookmarkNavigators() {
        BookmarkType[] types;
        BookmarkManager bookmarkMgr = this.secondaryDiffProgram.getBookmarkManager();
        BookmarkNavigator.defineBookmarkTypes((Program)this.secondaryDiffProgram);
        for (BookmarkType element : types = bookmarkMgr.getBookmarkTypes()) {
            BookmarkNavigator nav = new BookmarkNavigator((MarkerService)this.markerManager, bookmarkMgr, element);
            nav.updateBookmarkers(new AddressSet(bookmarkMgr.getBookmarkAddresses(element.getTypeString())));
            this.bookmarkMap.put(element, nav);
        }
    }

    private String getDiffCountInfo(Address p1CodeUnitAddress) {
        Address p2CodeUnitAddress = SimpleDiffUtility.getCompatibleAddress((Program)this.primaryProgram, (Address)p1CodeUnitAddress, (Program)this.secondaryDiffProgram);
        if (p2CodeUnitAddress == null) {
            return null;
        }
        int rangeCount = this.p2DiffHighlight.getNumAddressRanges();
        AddressRangeIterator p2DiffIter = this.p2DiffHighlight.getAddressRanges();
        for (int i = 0; i < rangeCount && p2DiffIter.hasNext(); ++i) {
            AddressRange range = (AddressRange)p2DiffIter.next();
            if (!range.contains(p2CodeUnitAddress)) continue;
            return "Diff address range " + Integer.toString(i + 1) + " of " + rangeCount + ".";
        }
        return null;
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (this.secondaryDiffProgram != null && this.diffDetailsProvider != null) {
            this.diffDetailsProvider.refreshDetails(this.currentLocation);
        }
    }

    private class ApplySettingsActionListener
    implements ActionListener {
        private ApplySettingsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String actionCommand = event.getActionCommand();
            if ("Apply Filter Changed".equals(actionCommand)) {
                ProgramDiffPlugin.this.applyFilter = ProgramDiffPlugin.this.diffApplySettingsProvider.getApplyFilter();
                if (ProgramDiffPlugin.this.diffControl != null) {
                    ProgramDiffPlugin.this.diffControl.setMergeFilter(ProgramDiffPlugin.this.applyFilter);
                }
                ProgramDiffPlugin.this.updatePgm2Enablement();
            }
        }
    }

    private class DiffDetailsActionListener
    implements ActionListener {
        private DiffDetailsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String actionCommand = event.getActionCommand();
            if ("Diff Details Hidden".equals(actionCommand) && ProgramDiffPlugin.this.diffDetailsProvider != null) {
                ProgramDiffPlugin.this.tool.showComponentProvider((ComponentProvider)ProgramDiffPlugin.this.diffDetailsProvider, false);
            }
        }
    }

    private class MyFieldMouseListener
    implements FieldMouseListener {
        private MyFieldMouseListener() {
        }

        public void buttonPressed(FieldLocation location, Field field, MouseEvent ev) {
            Address addr;
            if (ev.getButton() != 1) {
                return;
            }
            if (DockingUtils.isControlModifier((MouseEvent)ev) || ev.isShiftDown()) {
                return;
            }
            ListingField lf = (ListingField)field;
            FieldFactory factory = lf.getFieldFactory();
            ProgramLocation pLoc = factory.getProgramLocation(location.getRow(), location.getCol(), lf);
            if (pLoc == null) {
                AddressIndexMap indexMap = ProgramDiffPlugin.this.diffListingPanel.getAddressIndexMap();
                Address addr2 = indexMap.getAddress(location.getIndex());
                if (addr2 != null && ProgramDiffPlugin.this.secondaryDiffProgram != null) {
                    pLoc = new ProgramLocation(ProgramDiffPlugin.this.secondaryDiffProgram, addr2);
                } else {
                    return;
                }
            }
            if (!ProgramDiffPlugin.this.p2Selection.contains(addr = pLoc.getAddress())) {
                AddressRange range;
                AddressSet set = new AddressSet();
                if (ProgramDiffPlugin.this.p2DiffHighlight.contains(addr) && (range = ProgramDiffPlugin.this.p2DiffHighlight.getRangeContaining(addr)) != null) {
                    set = new AddressSet(range);
                }
                if (set.equals((Object)ProgramDiffPlugin.this.p2Selection)) {
                    return;
                }
                MarkerSet selectionMarkers = ProgramDiffPlugin.this.getSelectionMarkers();
                selectionMarkers.clearAll();
                ProgramDiffPlugin.this.programSelectionChanged(new ProgramSelection(ProgramDiffPlugin.this.p2AddressFactory, (AddressSetView)set), EventTrigger.GUI_ACTION);
                ProgramDiffPlugin.this.updatePgm2Enablement();
            }
        }
    }

    private class DiffActionListener
    implements ActionListener {
        private DiffActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String actionCommand = event.getActionCommand();
            if (event.getSource() instanceof ExecuteDiffDialog && "Diff".equals(actionCommand)) {
                ProgramDiffPlugin.this.execDiffFilter = ProgramDiffPlugin.this.executeDiffDialog.getDiffFilter();
                ProgramDiffPlugin.this.isLimitedToSelection = ProgramDiffPlugin.this.executeDiffDialog.isLimitedToSelection();
                AddressSetView displaySet = ProgramDiffPlugin.this.isLimitedToSelection ? ProgramDiffPlugin.this.createLimitingSet() : null;
                try {
                    ProgramMemoryComparator programMemoryComparator = new ProgramMemoryComparator(ProgramDiffPlugin.this.primaryProgram, ProgramDiffPlugin.this.secondaryDiffProgram);
                    ProgramDiffPlugin.this.addressesOnlyInP1 = programMemoryComparator.getAddressesOnlyInOne();
                    ProgramDiffPlugin.this.compatibleOnlyInP2 = programMemoryComparator.getCompatibleAddressesOnlyInTwo();
                }
                catch (ProgramConflictException e) {
                    Msg.showError(this.getClass(), (Component)ProgramDiffPlugin.this.tool.getToolFrame(), (String)"Can't Compare Memory", (Object)("Diff can't compare the two programs memory. " + e.getMessage()));
                    return;
                }
                CreateDiffTask task = new CreateDiffTask(ProgramDiffPlugin.this, ProgramDiffPlugin.this.primaryProgram, ProgramDiffPlugin.this.secondaryDiffProgram, displaySet, ProgramDiffPlugin.this.isLimitedToSelection, ProgramDiffPlugin.this.execDiffFilter, ProgramDiffPlugin.this.applyFilter);
                ProgramDiffPlugin.this.tool.execute((Task)task);
            }
        }
    }

    private class OpenSecondProgramTask
    extends Task {
        private DomainFile domainFile;
        private Program diffProgram;
        private TaskMonitor monitor;

        OpenSecondProgramTask(DomainFile domainFile) {
            super("Opening Program for Diff", true, true, true);
            this.domainFile = domainFile;
        }

        public void run(TaskMonitor tm) {
            block10: {
                this.monitor = tm;
                try {
                    try {
                        this.monitor.setMessage("Waiting on program file...");
                        this.diffProgram = (Program)this.domainFile.getImmutableDomainObject((Object)ProgramDiffPlugin.this, -1, this.monitor);
                    }
                    catch (VersionException e) {
                        if (e.isUpgradable()) {
                            try {
                                this.diffProgram = (Program)this.domainFile.getReadOnlyDomainObject((Object)ProgramDiffPlugin.this, -1, this.monitor);
                            }
                            catch (VersionException exc) {
                                Msg.showError((Object)((Object)this), null, (String)"Error Getting Diff Program", (Object)"Getting read only file failed");
                            }
                            catch (IOException exc) {
                                if (!this.monitor.isCancelled()) {
                                    Msg.showError((Object)((Object)this), null, (String)"Error Getting Diff Program", (Object)"Getting read only file failed", (Throwable)exc);
                                }
                                break block10;
                            }
                        }
                        Msg.showError((Object)((Object)this), null, (String)"Error Getting Diff Program", (Object)"File cannot be upgraded.");
                    }
                    catch (IOException e) {
                        Msg.showError((Object)((Object)this), null, (String)"Error Getting Diff Program", (Object)"Getting read only file failed", (Throwable)e);
                    }
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
            }
            this.monitor.setMessage("");
        }

        boolean wasCanceled() {
            return this.monitor.isCancelled();
        }

        Program getDiffProgram() {
            return this.diffProgram;
        }
    }
}

