(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.   The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.  The type signatures in this interface
 * are an edited version of those generated automatically by running 
 * "bin\fsc.exe -i" on the implementation file.
 *=========================================================================*)

/// Imperative hash tables.  Shallow interface to [[Microsoft.FSharp.Collections]].
///
/// HashTable: Hash tables using the structural "hash" and "equals" functions.  
///
///These tables can be used with keys of any type, but you should check that
///structural hashing and equality are correct for your key type.  
///Structural hashing is efficient but not a suitable choice in all circumstances, 
///e.g. may not hash efficiently on non-reference types and deeply-structured types.
///Better efficiency is typically achieved if key types are F#-generated
///types.
///
///These hash tables may map items to multiple keys (see find_all).
///
///The implementations are not safe for concurrent reading/writing,
///and so users of these tables should take an appropriate lock
///before reading/writing if used in a concurrent setting.
module Microsoft.FSharp.Compatibility.OCaml.Hashtbl

open System
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives
#if CLI_AT_MOST_1_1
open Microsoft.FSharp.Compatibility
#else
open System.Collections.Generic
#endif


/// For use when not opening module, e.g. Hashtbl.t
type ('key,'a) t = Microsoft.FSharp.Collections.HashMultiMap<'key,'a> 

/// Create a hash table with the suggested initial size.  
///
/// Inlined to enable generation of efficient hash routines for the key type in the common case.
val inline create  : int -> HashMultiMap<'key,'a>

/// Add key and data to the table.
val add     : HashMultiMap<'key,'a> -> 'key -> 'a -> unit

/// Create a hash table using the given data
val of_list : ('key * 'a) list -> HashMultiMap<'key,'a> 

/// Create a hash table using the given data
[<System.Obsolete("This function has been renamed. Consider using of_seq instead")>]
val of_IEnumerable : #IEnumerable<'key * 'a>  -> HashMultiMap<'key,'a> 

/// Create hash table using the given data
///
/// Inlined to enable generation of efficient hash routines for the key type in the common case.
val of_seq : #seq<'key * 'a>  -> HashMultiMap<'key,'a> 

/// Empty the table.
val clear   : HashMultiMap<'key,'a> -> unit

/// Create a copy of the table. Remember they are imperative and get mutated. 
val copy    : HashMultiMap<'key,'a> -> HashMultiMap<'key,'a>

/// Lookup key's data in the table.
/// Raises exception is key not in table, if this could happen you should be using tryfind.
val find    : HashMultiMap<'key,'a> -> 'key -> 'a

/// Return all bindings for the given key
val find_all: HashMultiMap<'key,'a> -> 'key -> 'a list

/// Fold over all bindings
val fold    : ('key -> 'a -> 'c -> 'c) -> HashMultiMap<'key,'a> -> 'c -> 'c

///Apply the given function to each binding in the hash table 
val iter    : ('key -> 'a -> unit) -> HashMultiMap<'key,'a> -> unit

/// Test for the existence of any bindings for the given key
val mem    : HashMultiMap<'key,'a> -> 'key -> bool

/// Remove the latest binding for the given key
val remove : HashMultiMap<'key,'a> -> 'key -> unit

/// Replace the latest binding for the given key
val replace: HashMultiMap<'key,'a> -> 'key -> 'a -> unit

/// Lookup the key's data in the table
val tryfind: HashMultiMap<'key,'a> -> 'key -> 'a option

/// Print statistics on a given hash table to the given output channel
val stats: string -> (out_channel -> 'key -> unit) -> out_channel -> HashMultiMap<'key,'a> -> unit 

///A collection of operations for creating and using hash tables based on particular type-tracked hash/equality functions.
///Generated by the Hashtbl.Make and Hashtbl.MakeTagged functors. This type is for use when you wish to
///specify a comparison function once and carry around an object that is a provider of (i.e. a factory for) hashtables 
///that utilize that comparison function.
///
///The 'tag' type parameter is used to track information about the comparison function, which helps ensure 
///that you don't mixup maps created with different comparison functions
type Provider<'key,'a,'tag>  
     when 'tag :> IEqualityComparer<'key> =
  { create  : int -> Tagged.HashMultiMap<'key,'a,'tag>;
    clear   : Tagged.HashMultiMap<'key,'a,'tag> -> unit;
    add     : Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> 'a -> unit;
    copy    : Tagged.HashMultiMap<'key,'a,'tag> -> Tagged.HashMultiMap<'key,'a,'tag>;
    find    : Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> 'a;
    find_all: Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> 'a list;
    tryfind : Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> 'a option;
    mem     : Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> bool;
    remove  : Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> unit;
    replace : Tagged.HashMultiMap<'key,'a,'tag> -> 'key -> 'a -> unit;
    iter    : ('key -> 'a -> unit) -> Tagged.HashMultiMap<'key,'a,'tag> -> unit;
    fold    : 'c. ('key -> 'a -> 'c -> 'c) -> Tagged.HashMultiMap<'key,'a,'tag> -> 'c -> 'c;
    
    /// Provider.stats prints out statistics for all the hash tables ever created
    /// related to this provider.  It also prints out the keys in the longest 
    /// chain ever stored in any hash table managed by this component, using 
    /// the given printing function.  This is useful for debugging poor hash 
    /// functions.
    stats   : string -> (out_channel -> 'key -> unit) -> out_channel -> unit }

type Provider<'key,'a> = Provider<'key,'a,IEqualityComparer<'key>>

/// Same as Make, except track the comparison function being used through an additional type parameter.
///
/// To use this function accurately you need to define a new named class that implements IEqualityComparer and
/// pass an instance of that class as the first argument. For example:
///      type MyHasher = 
///        class
///          new() = { }
///          interface IEqualityComparer&lt;string&gt; with 
///            member self.GetHashCode(x) = ...
///            member self.Equals(x,y) = ...
///          end
///        end
///
/// let MyStringHashProvider : Hashtbl.Provider&lt;string,int&gt; = Hashtbl.MakeTagged(new MyStringHasher())
val MakeTagged: ('tag :> IEqualityComparer<'key>) -> Provider<'key,'a,'tag>

/// Hash on the structure of a value according to the F# structural hashing
/// conventions.  See Pervasives.hash
val hash : 'a -> int 

/// Hash on the identity of an object.   See Pervasives.hashq.
val hashq: 'a -> int 

/// HashTable: Hash tables using structural "hash" and "equals" functions.  
[<Obsolete("Consider using 'Hashtbl.t<'a,'a>' or 'Collections.HashMultiMap<'key,'a>')")>]
type HashTable<'key,'a> = HashMultiMap<'key,'a> 

type CHashTable<'key,'a> = Tagged.HashMultiMap<'key,'a>

[<Obsolete("This type has been renamed to Hashtbl.Provider")>]
type CHashOps<'key,'a> = Provider<'key,'a, IEqualityComparer<'key>>

/// Build a collection of operations for creating and using 
/// hashtables based on the given hash/equality functions. This returns a record
/// that contains the functions you use to create and manipulate tables of
/// this kind.  The returned value is much like an ML module. You should call Make once for 
/// each new pair of key/value types.  You may need to constrain the result 
/// to be an instantiation of Provider.
///
/// let MyStringHashProvider : Provider&lt;string,int&gt; = Hashtbl.Make(myStringHash,myStringEq)
val Make: ('key -> int) * ('key -> 'key -> bool) -> Provider<'key,'a>
