// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Math.Primitives
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core

/// Abstract internal type
type BigNat 

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module BigNat =

    type n = BigNat
    val zero  : n
    val one   : n
    val two   : n

    val add        : n -> n -> n
    val sub        : n -> n -> n
    val mul        : n -> n -> n
    val divmod     : n -> n -> n * n    
    val div        : n -> n -> n
    val rem        : n -> n -> n
    val hcf        : n -> n -> n

    val min        : n -> n -> n
    val max        : n -> n -> n
    val scale      : int -> n -> n    
    val powi       : n -> int -> n
    val pow        : n -> n -> n

    [<System.Obsolete("This function has been renamed to isZero")>]
    val IsZero     : n -> bool
    val isZero     : n -> bool
    val isOne      : n -> bool
    val equal      : n -> n -> bool
    val compare    : n -> n -> int
    val lt         : n -> n -> bool
    val gt         : n -> n -> bool
    val lte        : n -> n -> bool
    val gte        : n -> n -> bool

    val hash       : n -> int
    val to_float   : n -> float
    val to_int     : n -> int
    val of_int     : int -> n
    val to_int64   : n -> int64
    val of_int64   : int64 -> n
    val to_string  : n -> string
    val of_string  : string -> n

    val factorial  : n -> n
    // val randomBits : int -> n    
    val bits       : n -> int
    val is_small   : n -> bool   (* will fit in int32 (but not nec all int32) *)
    val get_small  : n -> int32 (* get the value, if it satisfies is_small *)

