// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators

/// ML-like operations on 32-bit System.Single floating point numbers.
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Float = 

    let add (x:float) (y:float) = x + y
    let div (x:float) (y:float) = x / y
    let mul (x:float) (y:float) = x * y
    let sub (x:float) (y:float) = x - y
    let neg (x:float)   = - x

    let compare (x:float) y = compare x y

    let of_int (x:int) = (# "conv.r8" x : float #)
    let ceil      (x:float)           = System.Math.Ceiling(x)
    let floor     (x:float)           = System.Math.Floor(x)
    let to_int (x:float) = 
#if CLI_AT_MOST_1_1
         System.Convert.ToInt32(if x < 0. then ceil x else floor x)
#else
         System.Convert.ToInt32(System.Math.Truncate(x))
#endif

    let of_int64 (x:int64) = (# "conv.r8" x : float #)
    let to_int64 (x:float) = (# "conv.i8" x : int64 #)

    let of_int32 (x:int32) = (# "conv.r8" x : float #)
    let to_int32 (x:float) = (# "conv.i4" x : int32 #)

    let of_float32 (x:float32) = (# "conv.r8" x : float #)
    let to_float32 (x:float) = (# "conv.r4" x : float32 #)

    let to_string (x:float) = (box x).ToString()
    let of_string (s:string) = 
      (* Note System.Double.Parse doesn't handle -0.0 correctly (it returns +0.0) *)
      let s = s.Trim()  
      let l = s.Length 
      let p = 0 
      let p,sign = if (l >= p + 1 && s.[p] = '-') then 1,false else 0,true 
      let n = 
        try 
          if p >= l then raise (new System.FormatException()) 
          System.Double.Parse(s.[p..],System.Globalization.CultureInfo.InvariantCulture)
        with :? System.FormatException -> failwith "Float.of_string"
      if sign then n else -n

    let of_bits x = Int64.float_of_bits x
    let to_bits x = Int64.bits_of_float x

