// (c) Microsoft Corporation 2005-2007. 

module Microsoft.FSharp.Compatibility.CompatMatrix 
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Collections

(* Define the primitive operations. *)
(* Note: the "type" syntax is for the type parameter for inline *)
(* polymorphic IL. This helps the compiler inline these fragments, *)
(* i.e. work out the correspondence between IL and F# type variables. *)
let
#if CLI_AT_MOST_1_1
 inline
#endif
 length1 (arr: 'a[,]) =  (# "ldlen.multi 2 0" arr : int #)  
let
#if CLI_AT_MOST_1_1
 inline
#endif
 length2 (arr: 'a[,]) =  (# "ldlen.multi 2 1" arr : int #)  
let
#if CLI_AT_MOST_1_1
 inline
#endif
 get (arr: 'a[,]) (n:int) (m:int) =  (# "ldelem.multi 2 !0" type ('a) arr n m : 'a #)  
let
#if CLI_AT_MOST_1_1
 inline
#endif
 set (arr: 'a[,]) (n:int) (m:int) (x:'a) =  (# "stelem.multi 2 !0" type ('a) arr n m x #)  
let
#if CLI_AT_MOST_1_1
 inline
#endif
 zero_create (n:int) (m:int) = (# "newarr.multi 2 !0" type ('a) n m : 'a[,] #)
let
#if CLI_AT_MOST_1_1
 inline
#endif
 make  (n:int) (m:int) (x:'a) =
  let arr = (zero_create n m : 'a[,]) in 
  for i = 0 to n - 1 do 
    for j = 0 to m - 1 do 
      (set arr i j x)
    done;
  done;
  arr

let
#if CLI_AT_MOST_1_1
 inline
#endif
 create (n:int) (m:int) (x:'a) = make n m x
let
#if CLI_AT_MOST_1_1
 inline
#endif
 init (n:int) (m:int) (f: int -> int -> 'a) = 
  let arr = (zero_create n m : 'a[,])  in 
  for i = 0 to n - 1 do 
    for j = 0 to m - 1 do 
      set arr i j (f i j)
    done;
  done;
  arr

let
#if CLI_AT_MOST_1_1
 inline
#endif
 iter (f : 'a -> unit) (arr:'a[,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      f (get arr i j)
    done;
  done

let
#if CLI_AT_MOST_1_1
 inline
#endif
 map (f: 'a -> 'b) (arr:'a[,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let res = (zero_create len1 len2 : 'b[,]) in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      set res i j (f (get arr i j))
    done;
  done;
  res

let
#if CLI_AT_MOST_1_1
 inline
#endif
 iteri (f : int -> int -> 'a -> unit) (arr:'a[,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      f i j (get arr i j)
    done;
  done

let
#if CLI_AT_MOST_1_1
 inline
#endif
 mapi (f: int -> int -> 'a -> 'b) (arr:'a[,]) =
  let len1 = length1 arr in 
  let len2 = length2 arr in 
  let res = (zero_create len1 len2 : 'b[,]) in 
  for i = 0 to len1 - 1 do 
    for j = 0 to len2 - 1 do 
      set res i j (f i j (get arr i j))
    done;
  done;
  res

