/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.ClassType;
import fan.sys.Depend;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanClassLoader;
import fan.sys.FanObj;
import fan.sys.File;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Log;
import fan.sys.Map;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.Type;
import fan.sys.UnknownPodErr;
import fan.sys.UnknownTypeErr;
import fan.sys.UnresolvedErr;
import fan.sys.Uri;
import fan.sys.Version;
import fanx.emit.FPodEmit;
import fanx.fcode.FPod;
import fanx.fcode.FStore;
import fanx.fcode.FType;
import fanx.fcode.FTypeRef;
import fanx.util.TypeParser;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.zip.ZipInputStream;

public class Pod
extends FanObj {
    static HashMap podsByName = new HashMap();
    static List allPodsList = null;
    final String name;
    final FanClassLoader classLoader;
    Uri uri;
    FPod fpod;
    Version version;
    Map meta;
    List depends;
    ClassType[] types;
    HashMap typesByName;
    Class cls;
    List filesList;
    HashMap filesMap = new HashMap(11);
    Log log;
    boolean docLoaded;
    public String doc;

    public static Pod of(Object object) {
        return Type.of(object).pod();
    }

    public static Pod find(String string) {
        return Pod.doFind(string, true, null, null);
    }

    public static Pod find(String string, boolean bl) {
        return Pod.doFind(string, bl, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pod doFind(String string, boolean bl, FPod fPod, HashMap hashMap) {
        try {
            HashMap hashMap2 = podsByName;
            synchronized (hashMap2) {
                SoftReference<Pod> softReference = (SoftReference<Pod>)podsByName.get(string);
                if (softReference == null || softReference.get() == null) {
                    if (hashMap != null && hashMap.containsKey(string)) {
                        throw new Exception("Cyclic dependency on '" + string + "'");
                    }
                    if (fPod == null) {
                        fPod = Pod.readFPod(string);
                    }
                    if (!fPod.podName.equals(string)) {
                        throw new Exception("Mismatched pod name b/w pod.def and pod zip filename: " + fPod.podName + " != " + string);
                    }
                    HashMap<String, String> hashMap3 = new HashMap<String, String>();
                    hashMap3.put(string, string);
                    for (int i = 0; i < fPod.depends.length; ++i) {
                        Depend depend = fPod.depends[i];
                        Pod pod = Pod.doFind(depend.name(), false, null, hashMap3);
                        if (pod == null) {
                            throw new Exception("Missing dependency for '" + string + "': " + depend);
                        }
                        if (depend.match(pod.version())) continue;
                        throw new Exception("Missing dependency for '" + string + "': " + pod.name() + " " + pod.version() + " != " + depend);
                    }
                    softReference = new SoftReference<Pod>(new Pod(fPod));
                    podsByName.put(string, softReference);
                }
                return (Pod)softReference.get();
            }
        }
        catch (UnknownPodErr unknownPodErr) {
            if (!bl) {
                return null;
            }
            throw unknownPodErr;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!bl) {
                return null;
            }
            throw UnknownPodErr.make(string, Err.make(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pod load(InStream inStream) {
        FPod fPod = null;
        try {
            fPod = new FPod(null, null);
            fPod.readFully(new ZipInputStream(SysInStream.java(inStream)));
        }
        catch (Exception exception) {
            throw Err.make(exception);
        }
        String string = fPod.podName;
        HashMap hashMap = podsByName;
        synchronized (hashMap) {
            SoftReference softReference = (SoftReference)podsByName.get(string);
            if (softReference != null && softReference.get() != null) {
                throw Err.make("Duplicate pod name: " + string);
            }
            Pod pod = new Pod(fPod);
            podsByName.put(string, new SoftReference<Pod>(pod));
            return pod;
        }
    }

    public static FPod readFPod(String string) throws Exception {
        Object object;
        FStore fStore = null;
        if (Sys.isJarDist) {
            fStore = FStore.makeJarDist(Pod.class.getClassLoader(), string);
        } else if (string.equals("sys")) {
            fStore = FStore.makeZip(new java.io.File(Sys.podsDir, string + ".pod"));
        } else {
            object = null;
            File file = Env.cur().findPodFile(string);
            if (file != null) {
                object = ((LocalFile)file).file;
            }
            if (object == null || !((java.io.File)object).exists()) {
                throw UnknownPodErr.make(string);
            }
            String string2 = ((java.io.File)object).getCanonicalFile().getName();
            if (!(string2 = string2.substring(0, string2.length() - 4)).equals(string)) {
                throw UnknownPodErr.make("Mismatch case: " + string + " != " + string2);
            }
            fStore = FStore.makeZip((java.io.File)object);
        }
        object = new FPod(string, fStore);
        ((FPod)object).read();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List list() {
        HashMap hashMap = podsByName;
        synchronized (hashMap) {
            if (allPodsList == null) {
                List list = Env.cur().findAllPodNames();
                List list2 = new List(Sys.PodType, list.sz());
                for (int i = 0; i < list.sz(); ++i) {
                    String string = (String)list.get(i);
                    try {
                        list2.add(Pod.doFind(string, true, null, null));
                        continue;
                    }
                    catch (Throwable throwable) {
                        System.out.println("ERROR: Invalid pod file: " + string);
                        throwable.printStackTrace();
                    }
                }
                allPodsList = (List)list2.sort().toImmutable();
            }
            return allPodsList;
        }
    }

    Pod(FPod fPod) {
        this.name = fPod.podName;
        this.classLoader = new FanClassLoader(this);
        this.load(fPod);
    }

    public Type typeof() {
        return Sys.PodType;
    }

    public final String name() {
        return this.name;
    }

    public final Version version() {
        if (this.version == null) {
            this.version = Version.fromStr(this.fpod.podVersion);
        }
        return this.version;
    }

    public final List depends() {
        if (this.depends == null) {
            this.depends = (List)new List(Sys.DependType, this.fpod.depends).toImmutable();
        }
        return this.depends;
    }

    public final Uri uri() {
        if (this.uri == null) {
            this.uri = Uri.fromStr("fan://" + this.name);
        }
        return this.uri;
    }

    public final String toStr() {
        return this.name;
    }

    public final Map meta() {
        if (this.meta == null) {
            try {
                if (this.fpod.meta != null) {
                    this.meta = this.fpod.meta;
                } else {
                    SysInStream sysInStream = new SysInStream(this.fpod.store.read("meta.props"));
                    this.meta = (Map)sysInStream.readProps().toImmutable();
                    ((InStream)sysInStream).close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.meta = Sys.emptyStrStrMap;
            }
        }
        return this.meta;
    }

    public List types() {
        return new List(Sys.TypeType, this.types);
    }

    public Type type(String string) {
        return this.type(string, true);
    }

    public Type type(String string, boolean bl) {
        Type type = (Type)this.typesByName.get(string);
        if (type != null) {
            return type;
        }
        if (bl) {
            throw UnknownTypeErr.make(this.name + "::" + string);
        }
        return null;
    }

    public String doc() {
        if (!this.docLoaded) {
            try {
                FStore.Input input = this.fpod.store.read("doc/pod.fandoc");
                if (input != null) {
                    this.doc = SysInStream.make(input, 1024L).readAllStr();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.docLoaded = true;
        }
        return this.doc;
    }

    public final List files() {
        this.loadFiles();
        return this.filesList;
    }

    public final File file(Uri uri) {
        return this.file(uri, true);
    }

    public final File file(Uri uri, boolean bl) {
        this.loadFiles();
        if (!uri.isPathAbs()) {
            throw ArgErr.make("Pod.files Uri must be path abs: " + uri);
        }
        if (uri.auth() != null && !uri.toStr().startsWith(this.uri().toStr())) {
            throw ArgErr.make("Invalid base uri `" + uri + "` for `" + this.uri() + "`");
        }
        uri = this.uri().plus(uri);
        File file = (File)this.filesMap.get(uri);
        if (file != null || !bl) {
            return file;
        }
        throw UnresolvedErr.make(uri.toStr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles() {
        HashMap hashMap = this.filesMap;
        synchronized (hashMap) {
            if (this.filesList != null) {
                return;
            }
            if (this.fpod.store == null) {
                throw Err.make("Not backed by pod file: " + this.name);
            }
            try {
                this.filesList = (List)this.fpod.store.podFiles(this.uri()).toImmutable();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw Err.make(iOException);
            }
            for (int i = 0; i < this.filesList.sz(); ++i) {
                File file = (File)this.filesList.get(i);
                this.filesMap.put(file.uri(), file);
            }
        }
    }

    public final Log log() {
        if (this.log == null) {
            this.log = Log.get(this.name);
        }
        return this.log;
    }

    public final Map props(Uri uri, Duration duration) {
        return Env.cur().props(this, uri, duration);
    }

    public final String config(String string) {
        return Env.cur().config(this, string);
    }

    public final String config(String string, String string2) {
        return Env.cur().config(this, string, string2);
    }

    public final String locale(String string) {
        return Env.cur().locale(this, string);
    }

    public final String locale(String string, String string2) {
        return Env.cur().locale(this, string, string2);
    }

    void load(FPod fPod) {
        this.fpod = fPod;
        this.typesByName = new HashMap();
        this.types = new ClassType[fPod.types.length];
        for (int i = 0; i < fPod.types.length; ++i) {
            ClassType classType;
            this.types[i] = classType = new ClassType(this, fPod.types[i]);
            if (this.typesByName.put(classType.name, classType) == null) continue;
            throw Err.make("Invalid pod: " + this.name + " type already defined: " + classType.name);
        }
        Type type = Sys.TypeType;
        if (type == null) {
            type = (Type)this.typesByName.get("Type");
        }
        for (int i = 0; i < fPod.types.length; ++i) {
            FType fType = fPod.types[i];
            ClassType classType = this.types[i];
            classType.base = this.type(fType.base);
            Object[] objectArray = new Object[fType.mixins.length];
            for (int j = 0; j < objectArray.length; ++j) {
                objectArray[j] = this.type(fType.mixins[j]);
            }
            classType.mixins = new List(type, objectArray).ro();
        }
    }

    synchronized Class emit() {
        if (this.cls == null) {
            try {
                this.cls = Env.cur().loadPodClass(this);
                FPodEmit.initFields(this.fpod, this.cls);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.toString());
            }
        }
        return this.cls;
    }

    synchronized void precompiled(Class clazz) throws Exception {
        this.cls = clazz;
        FPodEmit.initFields(this.fpod, clazz);
    }

    Type type(int n) {
        if (n == 65535 || n == -1) {
            return null;
        }
        FTypeRef fTypeRef = this.fpod.typeRef(n);
        if (fTypeRef.isGenericInstance()) {
            return TypeParser.load(fTypeRef.signature, true, this);
        }
        String string = fTypeRef.podName;
        String string2 = fTypeRef.typeName;
        if (string.startsWith("[java]")) {
            Type type = Env.cur().loadJavaType(string, string2);
            if (fTypeRef.isNullable()) {
                type = ((Type)type).toNullable();
            }
            return type;
        }
        Pod pod = string.equals(this.name) ? this : Pod.doFind(string, true, null, null);
        Type type = pod.type(string2, false);
        if (type != null) {
            if (fTypeRef.isNullable()) {
                type = type.toNullable();
            }
            return type;
        }
        if (this.name.equals("sys") && (type = Sys.genericParamType(string2)) != null) {
            if (fTypeRef.isNullable()) {
                type = type.toNullable();
            }
            return type;
        }
        throw UnknownTypeErr.make(string + "::" + string2);
    }
}

