/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.DateTime;
import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanObj;
import fan.sys.LogLevel;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;

public class LogRec
extends FanObj {
    public DateTime time;
    public LogLevel level;
    public String logName;
    public String msg;
    public Err err;

    public static LogRec make(DateTime dateTime, LogLevel logLevel, String string, String string2) {
        return LogRec.make(dateTime, logLevel, string, string2, null);
    }

    public static LogRec make(DateTime dateTime, LogLevel logLevel, String string, String string2, Err err) {
        LogRec logRec = new LogRec();
        LogRec.make$(logRec, dateTime, logLevel, string, string2, err);
        return logRec;
    }

    public static void make$(LogRec logRec, DateTime dateTime, LogLevel logLevel, String string, String string2) {
        LogRec.make$(logRec, dateTime, logLevel, string, string2, null);
    }

    public static void make$(LogRec logRec, DateTime dateTime, LogLevel logLevel, String string, String string2, Err err) {
        logRec.time = dateTime;
        logRec.level = logLevel;
        logRec.logName = string;
        logRec.msg = string2;
        logRec.err = err;
    }

    public Type typeof() {
        return Sys.LogRecType;
    }

    public String toStr() {
        String string = this.time.toLocale("hh:mm:ss DD-MMM-YY");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(string).append(']').append(' ').append('[').append(this.level).append(']').append(' ').append('[').append(this.logName).append(']').append(' ').append(this.msg);
        return stringBuilder.toString();
    }

    public void print() {
        this.print(Env.cur().out());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(OutStream outStream) {
        OutStream outStream2 = outStream;
        synchronized (outStream2) {
            outStream.printLine(this.toStr());
            if (this.err != null) {
                this.err.trace(outStream, null, 2, true);
            }
        }
    }
}

