/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Buf;
import fan.sys.DateTime;
import fan.sys.File;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import fan.sys.Uri;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ClassLoaderFile
extends File {
    final ClassLoader loader;
    final String loaderPath;
    private boolean inited;
    private int size;
    private long modified;

    public ClassLoaderFile(ClassLoader classLoader, String string, Uri uri) {
        super(uri);
        this.loader = classLoader;
        this.loaderPath = string;
    }

    public Type typeof() {
        return Sys.ClassLoaderFileType;
    }

    public boolean exists() {
        return true;
    }

    public Long size() {
        this.initMeta();
        if (this.size < 0) {
            return null;
        }
        return this.size;
    }

    public DateTime modified() {
        this.initMeta();
        if (this.modified <= 0L) {
            return null;
        }
        return DateTime.fromJava(this.modified);
    }

    public void modified(DateTime dateTime) {
        throw IOErr.make("ClassLoaderFile is readonly");
    }

    public String osPath() {
        return null;
    }

    public File parent() {
        return null;
    }

    public List list() {
        return new List(Sys.FileType, 0);
    }

    public File normalize() {
        return this;
    }

    public File plus(Uri uri, boolean bl) {
        throw UnsupportedErr.make("ClassLoaderFile.plus");
    }

    public File create() {
        throw IOErr.make("ClassLoaderFile is readonly");
    }

    public File moveTo(File file) {
        throw IOErr.make("ClassLoaderFile is readonly");
    }

    public void delete() {
        throw IOErr.make("ClassLoaderFile is readonly");
    }

    public File deleteOnExit() {
        throw IOErr.make("ClassLoaderFile is readonly");
    }

    public Buf open(String string) {
        throw UnsupportedErr.make("ClassLoaderFile.open");
    }

    public Buf mmap(String string, long l, Long l2) {
        throw UnsupportedErr.make("ClassLoaderFile.mmap");
    }

    public InStream in(Long l) {
        InputStream inputStream = this.loader.getResourceAsStream(this.loaderPath);
        if (l != null && l != 0L) {
            inputStream = new BufferedInputStream(inputStream, l.intValue());
        }
        return new SysInStream(inputStream);
    }

    public OutStream out(boolean bl, Long l) {
        throw IOErr.make("ClassLoaderFile is readonly");
    }

    private void initMeta() {
        if (this.inited) {
            return;
        }
        try {
            URL uRL = this.loader.getResource(this.loaderPath);
            URLConnection uRLConnection = uRL.openConnection();
            this.size = uRLConnection.getContentLength();
            this.modified = uRLConnection.getLastModified();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.inited = true;
    }
}

