/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;

public abstract class FoldedMos {
    private static final GateSpace useMinSp = new GateSpace(){

        @Override
        public double getExtraSpace(double requiredExtraSpace, int foldNdx, int nbFolds, int spaceNdx, int nbGates) {
            return requiredExtraSpace;
        }
    };
    private PortInst[] diffVias;
    private TechType.MosInst[] moss;
    private PortInst[] internalDiffs;
    private double difContWid;
    private double gateWidth;
    private double physWidth;
    private double mosY;
    private TechType tech;
    private final EditingPreferences ep;

    FoldedMos(EditingPreferences ep) {
        this.ep = ep;
    }

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private boolean isPmos() {
        return this instanceof FoldedPmos;
    }

    private void newDiffArc(ArcProto diff2, double y, PortInst p1, PortInst p2) {
        double x1 = this.tech.roundToGrid(LayoutLib.roundCenterX(p1));
        double x2 = this.tech.roundToGrid(LayoutLib.roundCenterX(p2));
        NodeInst ni1 = p1.getNodeInst();
        NodeInst ni2 = p2.getNodeInst();
        Poly poly1 = ni1.getShapeOfPort(p1.getPortProto());
        Poly poly2 = ni2.getShapeOfPort(p2.getPortProto());
        if (!poly1.contains(x1, y) || !poly2.contains(x2, y)) {
            LayoutLib.newArcInst(diff2, this.ep, Double.POSITIVE_INFINITY, p1, p2);
        } else {
            LayoutLib.newArcInst(diff2, this.ep, Double.POSITIVE_INFINITY, p1, x1, y, p2, x2, y);
        }
    }

    private void addM1ForMinArea(PortInst diffContPort, double difContHei, char justify) {
        double metalW;
        double diffOverM1 = (this.tech.getDiffContWidth() - this.tech.getDiffCont_m1Width()) / 2.0;
        double metalH = difContHei - diffOverM1 * 2.0;
        double area = metalH * (metalW = this.tech.getDiffCont_m1Width());
        if (area >= this.tech.getM1MinArea()) {
            return;
        }
        Cell cell = diffContPort.getNodeInst().getParent();
        double reqH = this.tech.getM1MinArea() / metalW;
        reqH = Math.ceil(reqH / 0.2) * 0.2;
        double x = diffContPort.getCenter().getX();
        double y = diffContPort.getCenter().getY();
        if (justify == 'T') {
            double yHi = y + metalH / 2.0 - metalW / 2.0;
            PortInst piHi = LayoutLib.newNodeInst(this.tech.m1pin(), this.ep, x, yHi, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(this.tech.m1(), this.ep, metalW, diffContPort, piHi);
            double yLo = yHi - reqH + metalW;
            PortInst piLo = LayoutLib.newNodeInst(this.tech.m1pin(), this.ep, x, yLo, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(this.tech.m1(), this.ep, metalW, diffContPort, piLo);
        } else {
            double yLo = y - metalH / 2.0 + metalW / 2.0;
            PortInst piLo = LayoutLib.newNodeInst(this.tech.m1pin(), this.ep, x, yLo, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(this.tech.m1(), this.ep, metalW, diffContPort, piLo);
            double yHi = y + reqH - metalW;
            PortInst piHi = LayoutLib.newNodeInst(this.tech.m1pin(), this.ep, x, yHi, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(this.tech.m1(), this.ep, metalW, diffContPort, piHi);
        }
    }

    FoldedMos(char type, double x, double y, int nbFolds, int nbSeries, double gateWidth, GateSpace gateSpace, char justifyDiffCont, Cell f, TechType tech, EditingPreferences ep) {
        FoldedMos.error(type != 'P' && type != 'N', "FoldedMos: type must be 'P' or 'N': " + type);
        this.tech = tech;
        this.ep = ep;
        this.gateWidth = gateWidth;
        this.physWidth = Math.max(tech.getDiffContWidth(), gateWidth);
        this.diffVias = new PortInst[nbFolds + 1];
        this.moss = new TechType.MosInst[nbFolds * nbSeries];
        this.internalDiffs = new PortInst[nbFolds * (nbSeries - 1)];
        if (gateSpace == null) {
            gateSpace = useMinSp;
        }
        PrimitiveNode diffCont = this.isPmos() ? tech.pdm1() : tech.ndm1();
        ArcProto diff2 = this.isPmos() ? tech.pdiff() : tech.ndiff();
        PrimitiveNode difNod = this.isPmos() ? tech.pdNode() : tech.ndNode();
        int diffNdx = 0;
        int mosNdx = 0;
        int internalDiffNdx = 0;
        double difConIncr = tech.getDiffContIncr();
        this.difContWid = Math.max(tech.getDiffContWidth(), (double)((int)(gateWidth / difConIncr)) * difConIncr);
        double difContSlop = Math.max(0.0, (gateWidth - this.difContWid) / 2.0);
        double difContY = y;
        switch (justifyDiffCont) {
            case 'T': {
                difContY += difContSlop;
                break;
            }
            case 'B': {
                difContY -= difContSlop;
                break;
            }
            case 'C': {
                this.difContWid = gateWidth;
                break;
            }
            default: {
                FoldedMos.error(true, "FoldedMos: justifyDiffCont must be 'T', or 'B'");
            }
        }
        this.mosY = y;
        if (gateWidth < tech.getDiffContWidth()) {
            double mosBotY = y - gateWidth / 2.0;
            double misAlign = Math.IEEEremainder(mosBotY, 0.5);
            this.mosY -= misAlign;
        }
        double extraDiffPolySpace = gateWidth >= tech.getDiffContWidth() ? 0.0 : tech.getGateToDiffContSpaceDogBone() - tech.getGateToDiffContSpace();
        double viaToMosPitch = tech.getDiffContWidth() / 2.0 + tech.getGateToDiffContSpace() + tech.getGateLength() / 2.0;
        double mosToMosPitch = tech.getGateLength() + tech.getGateToGateSpace();
        PortInst prevPort = null;
        int i = 0;
        while (true) {
            PortInst newPort = LayoutLib.newNodeInst(diffCont, ep, x, difContY, Double.POSITIVE_INFINITY, this.difContWid, 0.0, f).getOnlyPortInst();
            ArcInst redundantAi = LayoutLib.newArcInst(diff2, ep, tech.getDiffCont_m1Width(), newPort, newPort);
            if (justifyDiffCont == 'C') {
                redundantAi.setHeadExtended(false);
                redundantAi.setTailExtended(false);
            }
            this.addM1ForMinArea(newPort, this.difContWid, justifyDiffCont);
            this.diffVias[diffNdx++] = newPort;
            if (prevPort != null) {
                this.newDiffArc(diff2, difContY, prevPort, newPort);
            }
            prevPort = newPort;
            if (i >= nbFolds) break;
            for (int j = 0; j < nbSeries; ++j) {
                double extraSp = gateSpace.getExtraSpace(j == 0 ? extraDiffPolySpace : 0.0, i, nbFolds, j, nbSeries);
                if (j == 0 && extraSp != 0.0) {
                    double w = Math.ceil(extraSp);
                    NodeInst dn = LayoutLib.newNodeInst(difNod, ep, x + w / 2.0, this.mosY, w, gateWidth, 0.0, f);
                    this.newDiffArc(diff2, difContY, prevPort, dn.getOnlyPortInst());
                }
                TechType.MosInst m = this.isPmos() ? tech.newPmosInst(x, this.mosY, gateWidth, tech.getGateLength(), f, ep) : tech.newNmosInst(x += (j == 0 ? viaToMosPitch : mosToMosPitch) + extraSp, this.mosY, gateWidth, tech.getGateLength(), f, ep);
                this.moss[mosNdx++] = m;
                this.newDiffArc(diff2, difContY, prevPort, m.leftDiff());
                prevPort = m.rightDiff();
                if (j == 0) continue;
                this.internalDiffs[internalDiffNdx++] = m.leftDiff();
            }
            double extraSp = gateSpace.getExtraSpace(extraDiffPolySpace, i, nbFolds, nbSeries, nbSeries);
            x += viaToMosPitch + extraSp;
            if (extraSp != 0.0) {
                double w = Math.ceil(extraSp);
                NodeInst dn = LayoutLib.newNodeInst(difNod, ep, x - w / 2.0, this.mosY, w, gateWidth, 0.0, f);
                this.newDiffArc(diff2, difContY, prevPort, dn.getOnlyPortInst());
            }
            ++i;
        }
    }

    public double getGateWidth() {
        return this.gateWidth;
    }

    public double getPhysWidth() {
        return this.physWidth;
    }

    public double getMosCenterY() {
        return this.mosY;
    }

    public double getDiffContWidth() {
        return this.difContWid;
    }

    public int nbSrcDrns() {
        return this.diffVias.length;
    }

    public PortInst getSrcDrn(int col) {
        return this.diffVias[col];
    }

    public int nbGates() {
        return this.moss.length;
    }

    public PortInst getGate(int mosNdx, char pos) {
        FoldedMos.error(pos != 'T' && pos != 'B', "pos must be 'T' or 'B': " + pos);
        return pos == 'T' ? this.moss[mosNdx].topPoly() : this.moss[mosNdx].botPoly();
    }

    public int nbInternalSrcDrns() {
        return this.internalDiffs.length;
    }

    public PortInst getInternalSrcDrn(int col) {
        return this.internalDiffs[col];
    }

    public static interface GateSpace {
        public double getExtraSpace(double var1, int var3, int var4, int var5, int var6);
    }
}

