/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.logicaleffort.Pin;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;

public class Instance {
    private String name;
    private Type type;
    private float leSU;
    private float leX;
    private int level;
    private ArrayList<Pin> pins;
    private VarContext context;
    private int parallelGroup;
    private double mfactor;
    private Nodable no;

    protected Instance(String name, Type type, float leSU, float leX, Nodable no) {
        this.name = name;
        this.type = type;
        this.leSU = leSU;
        this.leX = leX;
        this.level = 0;
        this.no = no;
        this.parallelGroup = 0;
        this.mfactor = 1.0;
        this.pins = new ArrayList();
    }

    protected ArrayList<Pin> getAllPins() {
        return this.pins;
    }

    protected ArrayList<Pin> getOutputPins() {
        return Pin.getOutputPins(this.pins);
    }

    protected ArrayList getInputPins() {
        return Pin.getInputPins(this.pins);
    }

    protected ArrayList getInoutPins() {
        return Pin.getInoutPins(this.pins);
    }

    protected boolean isLeGate() {
        return this.type == Type.LEGATE || this.type == Type.LEKEEPER;
    }

    protected boolean isGate() {
        return this.type == Type.LEGATE || this.type == Type.LEKEEPER || this.type == Type.STATICGATE;
    }

    protected Type getType() {
        return this.type;
    }

    protected String getName() {
        return this.name;
    }

    protected int getLevel() {
        return this.level;
    }

    protected void setLevel(int level) {
        this.level = level;
    }

    protected float getLeSU() {
        return this.leSU;
    }

    protected void setLeSU(float leSU) {
        this.leSU = leSU;
    }

    protected float getLeX() {
        return this.leX;
    }

    protected void setLeX(float LeX) {
        this.leX = LeX;
    }

    protected VarContext getContext() {
        return this.context;
    }

    protected void setContext(VarContext context) {
        this.context = context;
    }

    protected Nodable getNodable() {
        return this.no;
    }

    protected int getParallelGroup() {
        return this.parallelGroup;
    }

    protected void setParallelGroup(int group) {
        this.parallelGroup = group;
    }

    protected double getMfactor() {
        return this.mfactor;
    }

    protected void setMfactor(double m) {
        this.mfactor = m;
    }

    protected void setPins(ArrayList<Pin> pins) {
        this.pins = pins;
        if (!this.isLeGate()) {
            return;
        }
        int outputPinCount = 0;
        StringBuffer err2 = new StringBuffer("LETool leGate '" + this.name + "' error: more than one output pin: ");
        for (Pin p : pins) {
            if (p.getDir() != Pin.Dir.OUTPUT) continue;
            ++outputPinCount;
            err2.append(p.getName() + ", ");
        }
        if (outputPinCount == 0) {
            System.out.println("LETool leGate '" + this.name + "' error: no output pin, or no 'le' logical effort defined on output pin");
        }
        if (outputPinCount > 1) {
            System.out.println(err2.substring(0, err2.length() - 2));
        }
    }

    protected void print() {
        System.out.println(this.type.toString() + ": " + this.name);
        System.out.println("    Size    \t= " + this.leX);
        System.out.println("    Step-up \t= " + this.leSU);
        System.out.println("    Level   \t= " + this.level);
        System.out.println("    Parallel Group\t= " + this.parallelGroup);
        System.out.println("    M Factor\t= " + this.mfactor);
    }

    protected void printShortInfo() {
        if (this.mfactor > 1.0) {
            System.out.println(this.type.toString() + ": Size=" + TextUtils.formatDouble((double)this.leX * this.mfactor, 2) + " (M=" + TextUtils.formatDouble(this.mfactor, 1) + "), " + this.name);
        } else {
            System.out.println(this.type.toString() + ": Size=" + TextUtils.formatDouble(this.leX, 2) + ", " + this.name);
        }
    }

    protected float printLoadInfo(Pin pin, float alpha) {
        float load;
        StringBuffer buf = new StringBuffer();
        buf.append(this.type.toString());
        buf.append("\t" + this.name);
        buf.append("\tSize=" + TextUtils.formatDouble((double)this.leX * this.mfactor, 2));
        buf.append("\tLE=" + TextUtils.formatDouble(pin.getLE(), 2));
        buf.append("\tM=" + TextUtils.formatDouble(this.mfactor, 2));
        if (pin.getDir() == Pin.Dir.OUTPUT) {
            load = (float)((double)(this.leX * pin.getLE()) * this.mfactor * (double)alpha);
            buf.append("\tAlpha=" + alpha);
            buf.append("\tLoad=" + TextUtils.formatDouble(load, 2));
        } else {
            load = (float)((double)(this.leX * pin.getLE()) * this.mfactor);
            buf.append("\tLoad=" + TextUtils.formatDouble(load, 2));
        }
        System.out.println(buf.toString());
        return load;
    }

    protected static class Type {
        private final String name;
        protected static final Type STATICGATE = new Type("Static Gate");
        protected static final Type LOAD = new Type("Load");
        protected static final Type WIRE = new Type("Wire");
        protected static final Type LEGATE = new Type("LE Gate");
        protected static final Type LEKEEPER = new Type("LE Keeper");
        protected static final Type CAPACITOR = new Type("Capacitor");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

