/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.netty4.ESLoggingHandler;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import org.elasticsearch.transport.netty4.Netty4OpenChannelsHandler;
import org.elasticsearch.transport.netty4.Netty4SizeHeaderFrameDecoder;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.elasticsearch.transport.netty4.NettyTcpChannel;

public class Netty4Transport
extends TcpTransport {
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    protected final RecvByteBufAllocator recvByteBufAllocator;
    protected final int workerCount;
    protected final ByteSizeValue receivePredictorMin;
    protected final ByteSizeValue receivePredictorMax;
    volatile Netty4OpenChannelsHandler serverOpenChannels;
    protected volatile Bootstrap bootstrap;
    protected final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();
    static final AttributeKey<NettyTcpChannel> CHANNEL_KEY;

    public Netty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        Netty4Utils.setAvailableProcessors((Integer)EsExecutors.PROCESSORS_SETTING.get(settings));
        this.workerCount = (Integer)WORKER_COUNT.get(settings);
        this.receivePredictorMin = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = (ByteSizeValue)NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.recvByteBufAllocator = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedRecvByteBufAllocator((int)this.receivePredictorMax.getBytes()) : new AdaptiveRecvByteBufAllocator((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            this.bootstrap = this.createBootstrap();
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                Netty4OpenChannelsHandler openChannels;
                this.serverOpenChannels = openChannels = new Netty4OpenChannelsHandler(this.logger);
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.createServerBootstrap(profileSettings);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private Bootstrap createBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_client_boss")));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler(this.getClientChannelInitializer());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.toIntExact(this.defaultConnectionProfile.getConnectTimeout().millis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, TCP_NO_DELAY.get(this.settings));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, TCP_KEEP_ALIVE.get(this.settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
        }
        bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(this.settings);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        bootstrap.validate();
        return bootstrap;
    }

    private void createServerBootstrap(TcpTransport.ProfileSettings profileSettings) {
        String name = profileSettings.profileName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", new Object[]{name, this.workerCount, profileSettings.portOrRange, profileSettings.bindHosts, profileSettings.publishHosts, this.compress, this.defaultConnectionProfile.getConnectTimeout(), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.RECOVERY), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.BULK), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.REG), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.STATE), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.PING), this.receivePredictorMin, this.receivePredictorMax});
        }
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory((Settings)this.settings, (String[])new String[]{"transport_server_worker", name});
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, workerFactory));
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.childHandler(this.getServerChannelInitializer(name));
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)profileSettings.tcpNoDelay);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)profileSettings.tcpKeepAlive);
        if (profileSettings.sendBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(profileSettings.sendBufferSize.getBytes()));
        }
        if (profileSettings.receiveBufferSize.getBytes() != -1L) {
            serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(profileSettings.receiveBufferSize.bytesAsInt()));
        }
        serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)profileSettings.reuseAddress);
        serverBootstrap.validate();
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        return new ServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new ClientChannelInitializer();
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable t = unwrapped != null ? unwrapped : cause;
        Channel channel = ctx.channel();
        this.onException((TcpChannel)channel.attr(CHANNEL_KEY).get(), t instanceof Exception ? (Exception)t : new ElasticsearchException(t));
    }

    public long getNumOpenServerConnections() {
        Netty4OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    protected NettyTcpChannel initiateChannel(DiscoveryNode node, TimeValue connectTimeout, ActionListener<Void> listener) throws IOException {
        ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)node.getAddress().address());
        Channel channel = channelFuture.channel();
        if (channel == null) {
            Netty4Utils.maybeDie(channelFuture.cause());
            throw new IOException(channelFuture.cause());
        }
        this.addClosedExceptionLogger(channel);
        NettyTcpChannel nettyChannel = new NettyTcpChannel(channel);
        channel.attr(CHANNEL_KEY).set((Object)nettyChannel);
        channelFuture.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    Netty4Utils.maybeDie(cause);
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        });
        return nettyChannel;
    }

    protected NettyTcpChannel bind(String name, InetSocketAddress address) {
        Channel channel = this.serverBootstraps.get(name).bind((SocketAddress)address).syncUninterruptibly().channel();
        NettyTcpChannel esChannel = new NettyTcpChannel(channel);
        channel.attr(CHANNEL_KEY).set((Object)esChannel);
        return esChannel;
    }

    TcpTransport.ScheduledPing getPing() {
        return this.scheduledPing;
    }

    @SuppressForbidden(reason="debug")
    protected void stopInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.serverOpenChannels, () -> {
            ArrayList<Tuple> serverBootstrapCloseFutures = new ArrayList<Tuple>(this.serverBootstraps.size());
            for (Map.Entry<String, ServerBootstrap> entry : this.serverBootstraps.entrySet()) {
                serverBootstrapCloseFutures.add(Tuple.tuple((Object)entry.getKey(), (Object)entry.getValue().config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS)));
            }
            for (Tuple future : serverBootstrapCloseFutures) {
                ((Future)future.v2()).awaitUninterruptibly();
                if (((Future)future.v2()).isSuccess()) continue;
                this.logger.debug(() -> new ParameterizedMessage("Error closing server bootstrap for profile [{}]", future.v1()), ((Future)future.v2()).cause());
            }
            this.serverBootstraps.clear();
            if (this.bootstrap != null) {
                this.bootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
                this.bootstrap = null;
            }
        }});
    }

    private void addClosedExceptionLogger(Channel channel) {
        channel.closeFuture().addListener(f -> {
            if (!f.isSuccess()) {
                this.logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), f.cause());
            }
        });
    }

    static {
        Netty4Utils.setup();
        WORKER_COUNT = new Setting("transport.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"transport.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting((String)"transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        NETTY_BOSS_COUNT = Setting.intSetting((String)"transport.netty.boss_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        CHANNEL_KEY = AttributeKey.newInstance((String)"es-channel");
    }

    protected class ServerChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final String name;

        protected ServerChannelInitializer(String name) {
            this.name = name;
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4Transport.this.addClosedExceptionLogger(ch);
            NettyTcpChannel nettyTcpChannel = new NettyTcpChannel(ch);
            ch.attr(CHANNEL_KEY).set((Object)nettyTcpChannel);
            Netty4Transport.this.serverAcceptedChannel(nettyTcpChannel);
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("open_channels", (ChannelHandler)Netty4Transport.this.serverOpenChannels);
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, this.name));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected class ClientChannelInitializer
    extends ChannelInitializer<Channel> {
        protected ClientChannelInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("logging", (ChannelHandler)new ESLoggingHandler());
            ch.pipeline().addLast("size", (ChannelHandler)new Netty4SizeHeaderFrameDecoder());
            ch.pipeline().addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(Netty4Transport.this, ".client"));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Netty4Utils.maybeDie(cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

