/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class UnmappedTerms
extends InternalTerms<UnmappedTerms, Bucket> {
    public static final String NAME = "umterms";

    public UnmappedTerms(String name, BucketOrder order, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, order, requiredSize, minDocCount, pipelineAggregators, metaData);
    }

    public UnmappedTerms(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected void writeTermTypeInfoTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getType() {
        return "sterms";
    }

    @Override
    public UnmappedTerms create(List<Bucket> buckets) {
        return new UnmappedTerms(this.name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        throw new UnsupportedOperationException("not supported for UnmappedTerms");
    }

    @Override
    protected UnmappedTerms create(String name, List<Bucket> buckets, long docCountError, long otherDocCount) {
        throw new UnsupportedOperationException("not supported for UnmappedTerms");
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation agg : aggregations) {
            if (agg instanceof UnmappedTerms) continue;
            return agg.reduce(aggregations, reduceContext);
        }
        return this;
    }

    @Override
    public final XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return UnmappedTerms.doXContentCommon(builder, params, 0L, 0L, Collections.emptyList());
    }

    @Override
    protected void setDocCountError(long docCountError) {
    }

    @Override
    protected int getShardSize() {
        return 0;
    }

    @Override
    public long getDocCountError() {
        return 0L;
    }

    @Override
    public long getSumOfOtherDocCounts() {
        return 0L;
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.emptyList();
    }

    @Override
    public Bucket getBucketByKey(String term) {
        return null;
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    protected static abstract class Bucket
    extends InternalTerms.Bucket<Bucket> {
        private Bucket(long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat formatter) {
            super(docCount, aggregations, showDocCountError, docCountError, formatter);
        }
    }
}

