/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.MinScoreScorer;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    public static final float DEFAULT_MAX_BOOST = Float.MAX_VALUE;
    final Query subQuery;
    final ScoreFunction[] functions;
    final ScoreMode scoreMode;
    final float maxBoost;
    private final Float minScore;
    protected final CombineFunction combineFunction;

    public FunctionScoreQuery(Query subQuery, Float minScore, float maxBoost) {
        this(subQuery, ScoreMode.FIRST, new ScoreFunction[0], CombineFunction.MULTIPLY, minScore, maxBoost);
    }

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this(subQuery, function, CombineFunction.MULTIPLY, null, Float.MAX_VALUE);
    }

    public FunctionScoreQuery(Query subQuery, ScoreFunction function, CombineFunction combineFunction, Float minScore, float maxBoost) {
        this(subQuery, ScoreMode.FIRST, new ScoreFunction[]{function}, combineFunction, minScore, maxBoost);
    }

    public FunctionScoreQuery(Query subQuery, ScoreMode scoreMode, ScoreFunction[] functions, CombineFunction combineFunction, Float minScore, float maxBoost) {
        if (Arrays.stream(functions).anyMatch(func -> func == null)) {
            throw new IllegalArgumentException("Score function should not be null");
        }
        this.subQuery = subQuery;
        this.scoreMode = scoreMode;
        this.functions = functions;
        this.maxBoost = maxBoost;
        this.combineFunction = combineFunction;
        this.minScore = minScore;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction[] getFunctions() {
        return this.functions;
    }

    public Float getMinScore() {
        return this.minScore;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        Query newQ = this.subQuery.rewrite(reader);
        ScoreFunction[] newFunctions = new ScoreFunction[this.functions.length];
        boolean needsRewrite = newQ != this.subQuery;
        for (int i = 0; i < this.functions.length; ++i) {
            newFunctions[i] = this.functions[i].rewrite(reader);
            needsRewrite |= newFunctions[i] != this.functions[i];
        }
        if (needsRewrite) {
            return new FunctionScoreQuery(newQ, this.scoreMode, newFunctions, this.combineFunction, this.minScore, this.maxBoost);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        if (!needsScores && this.minScore == null) {
            return this.subQuery.createWeight(searcher, needsScores, boost);
        }
        boolean subQueryNeedsScores = this.combineFunction != CombineFunction.REPLACE;
        Weight[] filterWeights = new Weight[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            subQueryNeedsScores |= this.functions[i].needsScores();
            if (!(this.functions[i] instanceof FilterScoreFunction)) continue;
            Query filter = ((FilterScoreFunction)this.functions[i]).filter;
            filterWeights[i] = searcher.createNormalizedWeight(filter, false);
        }
        Weight subQueryWeight = this.subQuery.createWeight(searcher, subQueryNeedsScores, boost);
        return new CustomBoostFactorWeight(this, subQueryWeight, filterWeights, subQueryNeedsScores);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(", functions: [");
        for (ScoreFunction function : this.functions) {
            sb.append("{" + (function == null ? "" : function.toString()) + "}");
        }
        sb.append("])");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)((Object)o);
        return Objects.equals(this.subQuery, other.subQuery) && this.maxBoost == other.maxBoost && Objects.equals(this.combineFunction, other.combineFunction) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.scoreMode, other.scoreMode) && Arrays.equals(this.functions, other.functions);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.subQuery, Float.valueOf(this.maxBoost), this.combineFunction, this.minScore, this.scoreMode, Arrays.hashCode(this.functions));
    }

    static class FunctionFactorScorer
    extends FilterScorer {
        private final ScoreFunction[] functions;
        private final ScoreMode scoreMode;
        private final LeafScoreFunction[] leafFunctions;
        private final Bits[] docSets;
        private final CombineFunction scoreCombiner;
        private final float maxBoost;
        private final boolean needsScores;

        private FunctionFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreMode scoreMode, ScoreFunction[] functions, float maxBoost, LeafScoreFunction[] leafFunctions, Bits[] docSets, CombineFunction scoreCombiner, boolean needsScores) throws IOException {
            super(scorer, (Weight)w);
            this.scoreMode = scoreMode;
            this.functions = functions;
            this.leafFunctions = leafFunctions;
            this.docSets = docSets;
            this.scoreCombiner = scoreCombiner;
            this.maxBoost = maxBoost;
            this.needsScores = needsScores;
        }

        public float score() throws IOException {
            float subQueryScore;
            int docId = this.docID();
            float f = subQueryScore = this.needsScores ? super.score() : 0.0f;
            if (this.leafFunctions.length == 0) {
                return subQueryScore;
            }
            double factor = this.computeScore(docId, subQueryScore);
            float finalScore = this.scoreCombiner.combine(subQueryScore, factor, this.maxBoost);
            if (finalScore == Float.NEGATIVE_INFINITY || Float.isNaN(finalScore)) {
                throw new ElasticsearchException("function score query returned an invalid score: " + finalScore + " for doc: " + docId, new Object[0]);
            }
            return finalScore;
        }

        protected double computeScore(int docId, float subQueryScore) throws IOException {
            double factor = 1.0;
            block0 : switch (this.scoreMode) {
                case FIRST: {
                    for (int i = 0; i < this.leafFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        factor = this.leafFunctions[i].score(docId, subQueryScore);
                        break block0;
                    }
                    break;
                }
                case MAX: {
                    double maxFactor = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < this.leafFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        maxFactor = Math.max(this.leafFunctions[i].score(docId, subQueryScore), maxFactor);
                    }
                    if (maxFactor == Double.NEGATIVE_INFINITY) break;
                    factor = maxFactor;
                    break;
                }
                case MIN: {
                    double minFactor = Double.POSITIVE_INFINITY;
                    for (int i = 0; i < this.leafFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        minFactor = Math.min(this.leafFunctions[i].score(docId, subQueryScore), minFactor);
                    }
                    if (minFactor == Double.POSITIVE_INFINITY) break;
                    factor = minFactor;
                    break;
                }
                case MULTIPLY: {
                    for (int i = 0; i < this.leafFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        factor *= this.leafFunctions[i].score(docId, subQueryScore);
                    }
                    break;
                }
                default: {
                    double totalFactor = 0.0;
                    double weightSum = 0.0;
                    for (int i = 0; i < this.leafFunctions.length; ++i) {
                        if (!this.docSets[i].get(docId)) continue;
                        totalFactor += this.leafFunctions[i].score(docId, subQueryScore);
                        weightSum += (double)this.functions[i].getWeight();
                    }
                    if (weightSum == 0.0) break;
                    factor = totalFactor;
                    if (this.scoreMode != ScoreMode.AVG) break;
                    factor /= weightSum;
                }
            }
            return factor;
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;
        final Weight[] filterWeights;
        final boolean needsScores;

        CustomBoostFactorWeight(Query parent, Weight subQueryWeight, Weight[] filterWeights, boolean needsScores) throws IOException {
            super(parent);
            this.subQueryWeight = subQueryWeight;
            this.filterWeights = filterWeights;
            this.needsScores = needsScores;
        }

        public void extractTerms(Set<Term> terms) {
            this.subQueryWeight.extractTerms(terms);
        }

        private FunctionFactorScorer functionScorer(LeafReaderContext context) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context);
            if (subQueryScorer == null) {
                return null;
            }
            LeafScoreFunction[] leafFunctions = new LeafScoreFunction[FunctionScoreQuery.this.functions.length];
            Bits[] docSets = new Bits[FunctionScoreQuery.this.functions.length];
            for (int i = 0; i < FunctionScoreQuery.this.functions.length; ++i) {
                ScoreFunction function = FunctionScoreQuery.this.functions[i];
                leafFunctions[i] = function.getLeafScoreFunction(context);
                if (this.filterWeights[i] != null) {
                    ScorerSupplier filterScorerSupplier = this.filterWeights[i].scorerSupplier(context);
                    docSets[i] = Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorerSupplier);
                    continue;
                }
                docSets[i] = new Bits.MatchAllBits(context.reader().maxDoc());
            }
            return new FunctionFactorScorer(this, subQueryScorer, FunctionScoreQuery.this.scoreMode, FunctionScoreQuery.this.functions, FunctionScoreQuery.this.maxBoost, leafFunctions, docSets, FunctionScoreQuery.this.combineFunction, this.needsScores);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Object scorer = this.functionScorer(context);
            if (scorer != null && FunctionScoreQuery.this.minScore != null) {
                scorer = new MinScoreScorer(this, (Scorer)scorer, FunctionScoreQuery.this.minScore.floatValue());
            }
            return scorer;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            boolean singleFunction;
            Explanation expl = this.subQueryWeight.explain(context, doc);
            if (!expl.isMatch()) {
                return expl;
            }
            boolean bl = singleFunction = FunctionScoreQuery.this.functions.length == 1 && !(FunctionScoreQuery.this.functions[0] instanceof FilterScoreFunction);
            if (FunctionScoreQuery.this.functions.length > 0) {
                Explanation factorExplanation;
                ArrayList<Explanation> functionsExplanations = new ArrayList<Explanation>();
                for (int i = 0; i < FunctionScoreQuery.this.functions.length; ++i) {
                    Bits docSet;
                    if (this.filterWeights[i] != null && !(docSet = Lucene.asSequentialAccessBits(context.reader().maxDoc(), this.filterWeights[i].scorerSupplier(context))).get(doc)) continue;
                    ScoreFunction function = FunctionScoreQuery.this.functions[i];
                    Explanation functionExplanation = function.getLeafScoreFunction(context).explainScore(doc, expl);
                    if (function instanceof FilterScoreFunction) {
                        double factor = functionExplanation.getValue();
                        float sc = (float)factor;
                        Query filterQuery = ((FilterScoreFunction)function).filter;
                        Explanation filterExplanation = Explanation.match((float)sc, (String)"function score, product of:", (Explanation[])new Explanation[]{Explanation.match((float)1.0f, (String)("match filter: " + filterQuery.toString()), (Explanation[])new Explanation[0]), functionExplanation});
                        functionsExplanations.add(filterExplanation);
                        continue;
                    }
                    functionsExplanations.add(functionExplanation);
                }
                if (functionsExplanations.size() == 0) {
                    factorExplanation = Explanation.match((float)1.0f, (String)"No function matched", Collections.emptyList());
                } else if (singleFunction && functionsExplanations.size() == 1) {
                    factorExplanation = (Explanation)functionsExplanations.get(0);
                } else {
                    FunctionFactorScorer scorer = this.functionScorer(context);
                    int actualDoc = scorer.iterator().advance(doc);
                    assert (actualDoc == doc);
                    double score = scorer.computeScore(doc, expl.getValue());
                    factorExplanation = Explanation.match((float)((float)score), (String)("function score, score mode [" + FunctionScoreQuery.this.scoreMode.toString().toLowerCase(Locale.ROOT) + "]"), functionsExplanations);
                }
                expl = FunctionScoreQuery.this.combineFunction.explain(expl, factorExplanation, FunctionScoreQuery.this.maxBoost);
            }
            if (FunctionScoreQuery.this.minScore != null && FunctionScoreQuery.this.minScore.floatValue() > expl.getValue()) {
                expl = Explanation.noMatch((String)("Score value is too low, expected at least " + FunctionScoreQuery.this.minScore + " but got " + expl.getValue()), (Explanation[])new Explanation[]{expl});
            }
            return expl;
        }
    }

    public static enum ScoreMode implements Writeable
    {
        FIRST,
        AVG,
        MAX,
        SUM,
        MIN,
        MULTIPLY;


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public static ScoreMode readFromStream(StreamInput in) throws IOException {
            return in.readEnum(ScoreMode.class);
        }

        public static ScoreMode fromString(String scoreMode) {
            return ScoreMode.valueOf(scoreMode.toUpperCase(Locale.ROOT));
        }
    }

    public static class FilterScoreFunction
    extends ScoreFunction {
        public final Query filter;
        public final ScoreFunction function;

        public FilterScoreFunction(Query filter, ScoreFunction function) {
            super(function.getDefaultScoreCombiner());
            this.filter = filter;
            this.function = function;
        }

        @Override
        public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
            return this.function.getLeafScoreFunction(ctx);
        }

        @Override
        public boolean needsScores() {
            return this.function.needsScores();
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            if (this.getClass() != other.getClass()) {
                return false;
            }
            FilterScoreFunction that = (FilterScoreFunction)other;
            return Objects.equals(this.filter, that.filter) && Objects.equals(this.function, that.function);
        }

        @Override
        protected int doHashCode() {
            return Objects.hash(this.filter, this.function);
        }

        @Override
        protected ScoreFunction rewrite(IndexReader reader) throws IOException {
            Query newFilter = this.filter.rewrite(reader);
            if (newFilter == this.filter) {
                return this;
            }
            return new FilterScoreFunction(newFilter, this.function);
        }

        @Override
        public float getWeight() {
            return this.function.getWeight();
        }
    }
}

