/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.open;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OpenIndexResponse
extends AcknowledgedResponse {
    private boolean shardsAcknowledged;

    OpenIndexResponse() {
    }

    OpenIndexResponse(boolean acknowledged, boolean shardsAcknowledged) {
        super(acknowledged);
        assert (acknowledged || !shardsAcknowledged);
        this.shardsAcknowledged = shardsAcknowledged;
    }

    public boolean isShardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.readAcknowledged(in);
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.shardsAcknowledged = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeAcknowledged(out);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.shardsAcknowledged);
        }
    }
}

