/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private ByteSizeValue totalCompressedSize;

    public ClusterStateResponse() {
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, long sizeInBytes) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.totalCompressedSize = new ByteSizeValue(sizeInBytes);
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public ByteSizeValue getTotalCompressedSize() {
        return this.totalCompressedSize;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = ClusterState.readFrom(in, null);
        this.totalCompressedSize = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? new ByteSizeValue(in) : new ByteSizeValue(0L);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        this.clusterState.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            this.totalCompressedSize.writeTo(out);
        }
    }
}

