/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import java.util.Stack;
import java.util.TreeSet;

public class Cfg {
    private static boolean notThrow(Value s) {
        switch (s.et) {
            case E0: {
                switch (s.vt) {
                    case CONSTANT: 
                    case LOCAL: {
                        return true;
                    }
                }
                break;
            }
            case E1: {
                Value.E1Expr e1 = (Value.E1Expr)s;
                switch (s.vt) {
                    case CAST: 
                    case NEG: {
                        return Cfg.notThrow(e1.op.value);
                    }
                }
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)s;
                switch (s.vt) {
                    case ADD: 
                    case AND: 
                    case LCMP: 
                    case FCMPG: 
                    case FCMPL: 
                    case DCMPG: 
                    case DCMPL: 
                    case EQ: 
                    case GE: 
                    case GT: 
                    case LE: 
                    case LT: 
                    case MUL: 
                    case NE: 
                    case OR: 
                    case REM: 
                    case SHL: 
                    case SHR: 
                    case SUB: 
                    case USHR: 
                    case XOR: {
                        return Cfg.notThrow(e2.op1.value) && Cfg.notThrow(e2.op2.value);
                    }
                }
            }
        }
        return false;
    }

    public static boolean notThrow(Stmt s) {
        switch (s.st) {
            case GOTO: 
            case IDENTITY: 
            case LABEL: 
            case NOP: 
            case RETURN_VOID: {
                return true;
            }
            case ASSIGN: {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)s;
                return Cfg.notThrow(e2.op1.value) && Cfg.notThrow(e2.op2.value);
            }
            case IF: 
            case LOOKUP_SWITCH: 
            case RETURN: 
            case TABLE_SWITCH: {
                return Cfg.notThrow(((Stmt.E1Stmt)s).op.value);
            }
        }
        return false;
    }

    public static void createCfgForLiveAnalyze(IrMethod jm) {
        int n;
        for (Stmt st : jm.stmts) {
            st._ls_forward_frame = null;
            if (st._cfg_froms == null) {
                st._cfg_froms = new TreeSet<Stmt>(jm.stmts);
            } else {
                st._cfg_froms.clear();
            }
            if (st._cfg_tos == null) {
                st._cfg_tos = new TreeSet<Stmt>(jm.stmts);
                continue;
            }
            st._cfg_tos.clear();
        }
        for (Trap t : jm.traps) {
            Stmt s = t.start;
            while (s != t.end) {
                LabelStmt[] labelStmtArray = t.handlers;
                n = t.handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    LabelStmt handler = labelStmtArray[n2];
                    Cfg.link(s, handler);
                    ++n2;
                }
                s = s.getNext();
            }
        }
        block11: for (Stmt st : jm.stmts) {
            switch (st.st) {
                case GOTO: {
                    Cfg.link(st, ((JumpStmt)st).target);
                    break;
                }
                case IF: {
                    Cfg.link(st, ((JumpStmt)st).target);
                    Cfg.link(st, st.getNext());
                    break;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)st;
                    Cfg.link(st, lss.defaultTarget);
                    LabelStmt[] labelStmtArray = lss.targets;
                    n = lss.targets.length;
                    int n3 = 0;
                    while (n3 < n) {
                        LabelStmt ls = labelStmtArray[n3];
                        Cfg.link(st, ls);
                        ++n3;
                    }
                    continue block11;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)st;
                    Cfg.link(st, tss.defaultTarget);
                    LabelStmt[] labelStmtArray = tss.targets;
                    int n4 = tss.targets.length;
                    n = 0;
                    while (n < n4) {
                        LabelStmt ls = labelStmtArray[n];
                        Cfg.link(st, ls);
                        ++n;
                    }
                    continue block11;
                }
                case RETURN: 
                case RETURN_VOID: 
                case THROW: {
                    break;
                }
                default: {
                    Cfg.link(st, st.getNext());
                }
            }
        }
    }

    public static void createCFG(IrMethod jm) {
        int n;
        for (Stmt st : jm.stmts) {
            st._ls_forward_frame = null;
            if (st._cfg_froms == null) {
                st._cfg_froms = new TreeSet<Stmt>(jm.stmts);
            } else {
                st._cfg_froms.clear();
            }
            if (st._cfg_tos == null) {
                st._cfg_tos = new TreeSet<Stmt>(jm.stmts);
                continue;
            }
            st._cfg_tos.clear();
        }
        for (Trap t : jm.traps) {
            Stmt s = t.start.getNext();
            while (s != t.end) {
                if (!Cfg.notThrow(s)) {
                    LabelStmt[] labelStmtArray = t.handlers;
                    n = t.handlers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LabelStmt handler = labelStmtArray[n2];
                        Cfg.link(s.getPre(), handler);
                        ++n2;
                    }
                }
                s = s.getNext();
            }
        }
        block11: for (Stmt st : jm.stmts) {
            switch (st.st) {
                case GOTO: {
                    Cfg.link(st, ((JumpStmt)st).target);
                    break;
                }
                case IF: {
                    Cfg.link(st, ((JumpStmt)st).target);
                    Cfg.link(st, st.getNext());
                    break;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)st;
                    Cfg.link(st, lss.defaultTarget);
                    LabelStmt[] labelStmtArray = lss.targets;
                    n = lss.targets.length;
                    int n3 = 0;
                    while (n3 < n) {
                        LabelStmt ls = labelStmtArray[n3];
                        Cfg.link(st, ls);
                        ++n3;
                    }
                    continue block11;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)st;
                    Cfg.link(st, tss.defaultTarget);
                    LabelStmt[] labelStmtArray = tss.targets;
                    int n4 = tss.targets.length;
                    n = 0;
                    while (n < n4) {
                        LabelStmt ls = labelStmtArray[n];
                        Cfg.link(st, ls);
                        ++n;
                    }
                    continue block11;
                }
                case RETURN: 
                case RETURN_VOID: 
                case THROW: {
                    break;
                }
                default: {
                    Cfg.link(st, st.getNext());
                }
            }
        }
    }

    public static <T> void Forward(IrMethod jm, StmtVisitor<T> sv) {
        if (jm.stmts.getSize() == 0) {
            return;
        }
        for (Stmt st : jm.stmts) {
            st._cfg_visited = false;
        }
        Stack<Stmt> toVisitQueue = new Stack<Stmt>();
        boolean isFv = sv instanceof FrameVisitor;
        FrameVisitor fv = isFv ? (FrameVisitor)sv : null;
        toVisitQueue.add(jm.stmts.getFirst());
        while (!toVisitQueue.isEmpty()) {
            Stmt currentStmt = (Stmt)toVisitQueue.pop();
            if (currentStmt == null || currentStmt._cfg_visited) continue;
            currentStmt._cfg_visited = true;
            toVisitQueue.addAll(currentStmt._cfg_tos);
            T afterExecFrame = sv.exec(currentStmt);
            if (!isFv) continue;
            for (Stmt dist : currentStmt._cfg_tos) {
                fv.merge(afterExecFrame, dist);
            }
        }
    }

    private static void link(Stmt from, Stmt to) {
        if (to == null) {
            return;
        }
        from._cfg_tos.add(to);
        to._cfg_froms.add(from);
    }

    public static interface FrameVisitor<T>
    extends StmtVisitor<T> {
        public void merge(T var1, Stmt var2);
    }

    public static interface StmtVisitor<T> {
        public T exec(Stmt var1);
    }
}

