/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.Insn;
import jas.InsnOperand;
import jas.RuntimeConstants;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class LdcOperand
extends InsnOperand
implements RuntimeConstants {
    CP cpe;
    Insn source;
    boolean wide;

    @Override
    int size(ClassEnv ce, CodeAttr code) throws jasError {
        if (this.wide) {
            return 2;
        }
        short idx = ce.getCPIndex(this.cpe);
        if (idx > 255) {
            this.wide = true;
            this.source.opc = 19;
            return 2;
        }
        return 1;
    }

    LdcOperand(Insn s, CP cpe) {
        this.source = s;
        this.cpe = cpe;
        this.wide = true;
    }

    LdcOperand(Insn s, CP cpe, boolean wide) {
        this.source = s;
        this.cpe = cpe;
        this.wide = wide;
    }

    @Override
    void resolve(ClassEnv e) {
        e.addCPItem(this.cpe);
    }

    @Override
    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        short idx = e.getCPIndex(this.cpe);
        if (this.wide) {
            out.writeShort(idx);
        } else {
            if (idx > 255) {
                throw new jasError("exceeded size for small cpidx" + this.cpe);
            }
            out.writeByte((byte)(0xFF & idx));
        }
    }
}

