//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;

/**
 * The exception table data of a method. Contained either in a separate attribute
 * ("Exceptions") or directly after the code in a "Code" attribute.
 */
public class JcfExceptionTable
{
  public short catExceptTableSize;
  public short catExceptStartPC[];
  public short catExceptEndPC[];
  public short catExceptHandlerPC[];
  public short catExceptCatchType[];
  protected JcfCodeAttribute parent;
    public final JcfCodeAttribute getParent() { return parent; }

  /** Allocates catExceptXXX arrays, then reads each exception descriptor into the
   * appropriate arrays. */
  public JcfExceptionTable (JcfClassInput ist, JcfCodeAttribute p) throws IOException
  {
    parent = p;
    catExceptTableSize = ist.readShort();
    catExceptStartPC = new short[catExceptTableSize];
    catExceptEndPC = new short[catExceptTableSize];
    catExceptHandlerPC = new short[catExceptTableSize];
    catExceptCatchType = new short[catExceptTableSize];
    int codeLength = parent.catCode.length;
    for (int i = 0; i < catExceptTableSize; i++)
    {
      catExceptStartPC[i] = ist.readShortMax(codeLength);
      catExceptEndPC[i] = ist.readShortMax(codeLength);
      catExceptHandlerPC[i] = ist.readShortMax(codeLength);
      catExceptCatchType[i] = ist.readCPRef();
    }
  }
  
  /** For each exception descriptor, writes from the appropriate array to ost. */
  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeShort(catExceptTableSize);
    int codeLength = parent.catCode.length;
    for (int i = 0; i < catExceptTableSize; i++)
    {
      ost.writeShortMax(catExceptStartPC[i], codeLength);
      ost.writeShortMax(catExceptEndPC[i], codeLength);
      ost.writeShortMax(catExceptHandlerPC[i], codeLength);
      // this is usually a CP ref, but can be 0 if no handler defined:
      ost.writeCPRef(catExceptCatchType[i]);
    }
  }
}
