/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.basic.AbstractBasicConverter;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;
import com.thoughtworks.xstream.io.path.RelativePathCalculator;

public class ReferenceByXPathMarshaller
extends TreeMarshaller {
    private PathTracker pathTracker = new PathTracker();
    private ObjectIdDictionary references = new ObjectIdDictionary();
    private RelativePathCalculator relativePathCalculator = new RelativePathCalculator();

    public ReferenceByXPathMarshaller(HierarchicalStreamWriter hierarchicalStreamWriter, ConverterLookup converterLookup, ClassMapper classMapper) {
        super(hierarchicalStreamWriter, converterLookup, classMapper);
        this.writer = new PathTrackingWriter(hierarchicalStreamWriter, this.pathTracker);
    }

    public void convertAnother(Object object) {
        Converter converter = this.converterLookup.lookupConverterForType(object.getClass());
        if (this.isImmutableBasicType(converter)) {
            converter.marshal(object, this.writer, this);
        } else {
            String string = this.pathTracker.getCurrentPath();
            String string2 = this.references.lookupId(object);
            if (string2 != null) {
                String string3 = this.relativePathCalculator.relativePath(string, string2);
                this.writer.addAttribute("reference", string3);
            } else {
                this.references.associateId(object, string);
                converter.marshal(object, this.writer, this);
            }
        }
    }

    private boolean isImmutableBasicType(Converter converter) {
        return converter instanceof AbstractBasicConverter;
    }
}

