/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.servlet;

import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class HttpSessionHashModel
implements TemplateHashModel {
    private HttpSession session;
    private final ObjectWrapper wrapper;
    private final FreemarkerServlet servlet;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public HttpSessionHashModel(HttpSession session, ObjectWrapper wrapper) {
        this.session = session;
        this.wrapper = wrapper;
        this.servlet = null;
        this.request = null;
        this.response = null;
    }

    public HttpSessionHashModel(FreemarkerServlet servlet, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        this.wrapper = wrapper;
        this.servlet = servlet;
        this.request = request;
        this.response = response;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        this.checkSessionExistence();
        return this.wrapper.wrap(this.session != null ? this.session.getAttribute(key) : null);
    }

    private void checkSessionExistence() throws TemplateModelException {
        if (this.session == null) {
            this.session = this.request.getSession(false);
            if (this.session != null && this.servlet != null) {
                try {
                    this.servlet.initializeSession(this.request, this.response);
                }
                catch (Exception e) {
                    throw new TemplateModelException(e);
                }
            }
        }
    }

    public boolean isEmpty() throws TemplateModelException {
        this.checkSessionExistence();
        return this.session == null || !this.session.getAttributeNames().hasMoreElements();
    }
}

