/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.bytecode.Attribute;
import com.google.turbine.bytecode.ClassFile;
import java.util.ArrayList;
import java.util.List;

public final class LowerAttributes {
    static List<Attribute> classAttributes(ClassFile classfile) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (!classfile.innerClasses().isEmpty()) {
            attributes.add(new Attribute.InnerClasses(classfile.innerClasses()));
        }
        LowerAttributes.addAllAnnotations(attributes, classfile.annotations());
        LowerAttributes.addAllTypeAnnotations(attributes, classfile.typeAnnotations());
        if (classfile.signature() != null) {
            attributes.add(new Attribute.Signature(classfile.signature()));
        }
        if (classfile.module() != null) {
            attributes.add(new Attribute.Module(classfile.module()));
        }
        if (classfile.nestHost() != null) {
            attributes.add(new Attribute.NestHost(classfile.nestHost()));
        }
        if (!classfile.nestMembers().isEmpty()) {
            attributes.add(new Attribute.NestMembers(classfile.nestMembers()));
        }
        if (classfile.record() != null) {
            attributes.add(LowerAttributes.recordAttribute(classfile.record()));
        }
        if (!classfile.permits().isEmpty()) {
            attributes.add(new Attribute.PermittedSubclasses(classfile.permits()));
        }
        if (classfile.transitiveJar() != null) {
            attributes.add(new Attribute.TurbineTransitiveJar(classfile.transitiveJar()));
        }
        return attributes;
    }

    private static Attribute recordAttribute(ClassFile.RecordInfo record) {
        ImmutableList.Builder components = ImmutableList.builder();
        for (ClassFile.RecordInfo.RecordComponentInfo component : record.recordComponents()) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            if (component.signature() != null) {
                attributes.add(new Attribute.Signature(component.signature()));
            }
            LowerAttributes.addAllAnnotations(attributes, component.annotations());
            LowerAttributes.addAllTypeAnnotations(attributes, component.typeAnnotations());
            components.add((Object)new Attribute.Record.Component(component.name(), component.descriptor(), attributes));
        }
        return new Attribute.Record((ImmutableList<Attribute.Record.Component>)components.build());
    }

    static List<Attribute> methodAttributes(ClassFile.MethodInfo method) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        LowerAttributes.addAllAnnotations(attributes, method.annotations());
        LowerAttributes.addAllTypeAnnotations(attributes, method.typeAnnotations());
        if (method.signature() != null) {
            attributes.add(new Attribute.Signature(method.signature()));
        }
        LowerAttributes.addParameterAnnotations(attributes, method.parameterAnnotations());
        if (!method.exceptions().isEmpty()) {
            attributes.add(new Attribute.ExceptionsAttribute(method.exceptions()));
        }
        if (method.defaultValue() != null) {
            attributes.add(new Attribute.AnnotationDefault(method.defaultValue()));
        }
        if (!method.parameters().isEmpty()) {
            attributes.add(new Attribute.MethodParameters(method.parameters()));
        }
        return attributes;
    }

    static List<Attribute> fieldAttributes(ClassFile.FieldInfo field) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (field.signature() != null) {
            attributes.add(new Attribute.Signature(field.signature()));
        }
        if (field.value() != null) {
            attributes.add(new Attribute.ConstantValue(field.value()));
        }
        LowerAttributes.addAllAnnotations(attributes, field.annotations());
        LowerAttributes.addAllTypeAnnotations(attributes, field.typeAnnotations());
        return attributes;
    }

    static void addAllAnnotations(List<Attribute> attributes, List<ClassFile.AnnotationInfo> annotations) {
        ArrayList<ClassFile.AnnotationInfo> visible = new ArrayList<ClassFile.AnnotationInfo>();
        ArrayList<ClassFile.AnnotationInfo> invisible = new ArrayList<ClassFile.AnnotationInfo>();
        for (ClassFile.AnnotationInfo annotation : annotations) {
            if (annotation.typeName().equals("Ljava/lang/Deprecated;")) {
                attributes.add(Attribute.DEPRECATED);
            }
            (annotation.isRuntimeVisible() ? visible : invisible).add(annotation);
        }
        if (!visible.isEmpty()) {
            attributes.add(new Attribute.RuntimeVisibleAnnotations(visible));
        }
        if (!invisible.isEmpty()) {
            attributes.add(new Attribute.RuntimeInvisibleAnnotations(invisible));
        }
    }

    private static void addAllTypeAnnotations(List<Attribute> attributes, ImmutableList<ClassFile.TypeAnnotationInfo> annotations) {
        ArrayList<ClassFile.TypeAnnotationInfo> visible = new ArrayList<ClassFile.TypeAnnotationInfo>();
        ArrayList invisible = new ArrayList();
        for (ClassFile.TypeAnnotationInfo annotation : annotations) {
            (annotation.anno().isRuntimeVisible() ? visible : invisible).add(annotation);
        }
        if (!visible.isEmpty()) {
            attributes.add(new Attribute.RuntimeVisibleTypeAnnotations((ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.copyOf(visible)));
        }
        if (!invisible.isEmpty()) {
            attributes.add(new Attribute.RuntimeInvisibleTypeAnnotations((ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.copyOf(invisible)));
        }
    }

    static void addParameterAnnotations(List<Attribute> attributes, ImmutableList<ImmutableList<ClassFile.AnnotationInfo>> annotations) {
        ArrayList<List<ClassFile.AnnotationInfo>> visibles = new ArrayList<List<ClassFile.AnnotationInfo>>();
        ArrayList<List<ClassFile.AnnotationInfo>> invisibles = new ArrayList<List<ClassFile.AnnotationInfo>>();
        boolean hasVisible = false;
        boolean hasInvisible = false;
        for (List parameterAnnotations : annotations) {
            ArrayList<ClassFile.AnnotationInfo> visible = new ArrayList<ClassFile.AnnotationInfo>();
            ArrayList<ClassFile.AnnotationInfo> invisible = new ArrayList<ClassFile.AnnotationInfo>();
            for (ClassFile.AnnotationInfo annotation : parameterAnnotations) {
                if (annotation.isRuntimeVisible()) {
                    hasVisible = true;
                    visible.add(annotation);
                    continue;
                }
                hasInvisible = true;
                invisible.add(annotation);
            }
            visibles.add(visible);
            invisibles.add(invisible);
        }
        if (hasVisible) {
            attributes.add(new Attribute.RuntimeVisibleParameterAnnotations(visibles));
        }
        if (hasInvisible) {
            attributes.add(new Attribute.RuntimeInvisibleParameterAnnotations(invisibles));
        }
    }

    private LowerAttributes() {
    }
}

