/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.apidiff;

import com.google.common.io.Resources;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.apidiff.ApiDiff;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffChecker;
import com.google.errorprone.bugpatterns.apidiff.ApiDiffProto;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import javax.inject.Inject;

@BugPattern(name="AndroidJdkLibsChecker", altNames={"AndroidApiChecker"}, summary="Use of class, field, or method that is not compatible with legacy Android devices", severity=BugPattern.SeverityLevel.ERROR)
public class AndroidJdkLibsChecker
extends ApiDiffChecker {
    private final boolean allowJava8;
    private static final Matcher<ExpressionTree> FOREACH_ON_COLLECTION = MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("forEach").withParameters("java.util.function.Consumer", new String[0]);

    private static ApiDiff loadApiDiff(boolean allowJava8) {
        try {
            byte[] diffData = Resources.toByteArray((URL)Resources.getResource(AndroidJdkLibsChecker.class, (String)(allowJava8 ? "android_java8.binarypb" : "android.binarypb")));
            ApiDiffProto.Diff diff = ((ApiDiffProto.Diff.Builder)ApiDiffProto.Diff.newBuilder().mergeFrom(diffData, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry())).build();
            return ApiDiff.fromProto(diff);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Inject
    AndroidJdkLibsChecker(ErrorProneFlags flags) {
        this(flags.getBoolean("Android:Java8Libs").orElse(false));
    }

    public AndroidJdkLibsChecker() {
        this(false);
    }

    private AndroidJdkLibsChecker(boolean allowJava8) {
        super(AndroidJdkLibsChecker.loadApiDiff(allowJava8));
        this.allowJava8 = allowJava8;
    }

    @Override
    protected Description check(ExpressionTree tree, VisitorState state) {
        Description description = super.check(tree, state);
        if (description.equals(Description.NO_MATCH)) {
            return Description.NO_MATCH;
        }
        if (this.allowJava8 && FOREACH_ON_COLLECTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return description;
    }
}

