/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;

@BugPattern(summary="Specify a `Locale` when calling `String#to{Lower,Upper}Case`. (Note: there are multiple suggested fixes; the third may be most appropriate if you're dealing with ASCII Strings.)", severity=BugPattern.SeverityLevel.WARNING)
public final class StringCaseLocaleUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> DEFAULT_LOCALE_CASE_CONVERSION = MethodMatchers.instanceMethod().onExactClass(String.class.getName()).namedAnyOf(new String[]{"toLowerCase", "toUpperCase"}).withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!DEFAULT_LOCALE_CASE_CONVERSION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        int closingParenPosition = StringCaseLocaleUsage.getClosingParenPosition(tree, state);
        if (closingParenPosition == -1) {
            return this.describeMatch(tree);
        }
        return this.buildDescription(tree).addFix((Fix)StringCaseLocaleUsage.suggestLocale(closingParenPosition, "Locale.ROOT")).addFix((Fix)StringCaseLocaleUsage.suggestLocale(closingParenPosition, "Locale.getDefault()")).addFix((Fix)StringCaseLocaleUsage.suggestAscii(tree, state)).build();
    }

    private static SuggestedFix suggestLocale(int insertPosition, String locale) {
        return SuggestedFix.builder().addImport("java.util.Locale").replace(insertPosition, insertPosition, locale).build();
    }

    private static SuggestedFix suggestAscii(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (receiver == null) {
            return SuggestedFix.emptyFix();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription("Replace with Ascii.toLower/UpperCase; this changes behaviour for non-ASCII Strings");
        String ascii = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.google.common.base.Ascii");
        fix.replace((Tree)tree, String.format("%s.%s(%s)", ascii, ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName(), state.getSourceForNode((Tree)receiver)));
        return fix.build();
    }

    private static int getClosingParenPosition(MethodInvocationTree tree, VisitorState state) {
        int startPosition = ASTHelpers.getStartPosition((Tree)tree);
        if (startPosition == -1) {
            return -1;
        }
        return Streams.findLast(ErrorProneTokens.getTokens((String)state.getSourceForNode((Tree)tree), (Context)state.context).stream().filter(t -> t.kind() == Tokens.TokenKind.RPAREN)).map(token -> startPosition + token.pos()).orElse(-1);
    }
}

