/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Optional;

@BugPattern(summary="Calling toString on an array does not provide useful information", severity=BugPattern.SeverityLevel.ERROR)
public class ArrayToString
extends AbstractToString {
    private static final Matcher<ExpressionTree> GET_STACK_TRACE = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Throwable").named("getStackTrace");
    private static final TypePredicate IS_ARRAY = TypePredicates.isArray();

    @Override
    protected TypePredicate typePredicate() {
        return IS_ARRAY;
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return this.toStringFix(tree, tree, state);
    }

    @Override
    protected boolean allowableToStringKind(AbstractToString.ToStringKind toStringKind) {
        return toStringKind == AbstractToString.ToStringKind.FLOGGER || toStringKind == AbstractToString.ToStringKind.FORMAT_METHOD;
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        if (GET_STACK_TRACE.matches((Tree)tree, state)) {
            return Optional.of(SuggestedFix.builder().addImport("com.google.common.base.Throwables").replace(parent, String.format("Throwables.getStackTraceAsString(%s)", state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)))).build());
        }
        return ArrayToString.fix(parent, tree, state);
    }

    private static Optional<Fix> fix(Tree replace, Tree with, VisitorState state) {
        String method = ArrayToString.isNestedArray(with, state) ? "deepToString" : "toString";
        return Optional.of(SuggestedFix.builder().addImport("java.util.Arrays").replace(replace, String.format("Arrays.%s(%s)", method, state.getSourceForNode(with))).build());
    }

    private static boolean isNestedArray(Tree with, VisitorState state) {
        Types types = state.getTypes();
        Type withType = ASTHelpers.getType((Tree)with);
        return withType != null && types.isArray(withType) && types.isArray(types.elemtype(withType));
    }
}

