/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.Set;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassVersionSetter
implements ClassVisitor {
    private final int classVersion;
    private final Set newerClassVersions;

    public ClassVersionSetter(int classVersion) {
        this(classVersion, null);
    }

    public ClassVersionSetter(int classVersion, Set newerClassVersions) {
        this.classVersion = classVersion;
        this.newerClassVersions = newerClassVersions;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.u4version > this.classVersion && this.newerClassVersions != null) {
            this.newerClassVersions.add(new Integer(programClass.u4version));
        }
        programClass.u4version = this.classVersion;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }
}

