/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;

@BugPattern(name="MissingBraces", summary="The Google Java Style Guide requires braces to be used with if, else, for, do and while statements, even when the body is empty or contains only a single statement.", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"}, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s4.1.1-braces-always-used")
public class MissingBraces
extends BugChecker
implements BugChecker.IfTreeMatcher,
BugChecker.ForLoopTreeMatcher,
BugChecker.DoWhileLoopTreeMatcher,
BugChecker.WhileLoopTreeMatcher,
BugChecker.EnhancedForLoopTreeMatcher {
    public Description matchIf(IfTree tree, VisitorState state) {
        this.check(tree.getThenStatement(), state);
        if (tree.getElseStatement() != null && !tree.getElseStatement().getKind().equals((Object)Tree.Kind.IF)) {
            this.check(tree.getElseStatement(), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchDoWhileLoop(DoWhileLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    public Description matchForLoop(ForLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    public Description matchWhileLoop(WhileLoopTree tree, VisitorState state) {
        this.check(tree.getStatement(), state);
        return Description.NO_MATCH;
    }

    void check(StatementTree tree, VisitorState state) {
        if (tree != null && !(tree instanceof BlockTree)) {
            state.reportMatch(this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)tree, "{").postfixWith((Tree)tree, "}").build()));
        }
    }
}

