/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.EnumDeclaration;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.ListAccessor;
import lombok.ast.MethodDeclaration;
import lombok.ast.ModifiersTemplate;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableDefinition;

public class Modifiers
extends AbstractNode {
    ListAccessor<Annotation, Modifiers> annotations = ListAccessor.of(this, Annotation.class, "Modifiers.annotations");
    ListAccessor<KeywordModifier, Modifiers> keywords = ListAccessor.of(this, KeywordModifier.class, "Modifiers.keywords");

    public InterfaceDeclaration upToInterfaceDeclaration() {
        if (!(this.getParent() instanceof InterfaceDeclaration)) {
            return null;
        }
        InterfaceDeclaration out = (InterfaceDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public TypeDeclaration upToTypeDeclaration() {
        if (!(this.getParent() instanceof TypeDeclaration)) {
            return null;
        }
        TypeDeclaration out = (TypeDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public AnnotationDeclaration upToAnnotationDeclaration() {
        if (!(this.getParent() instanceof AnnotationDeclaration)) {
            return null;
        }
        AnnotationDeclaration out = (AnnotationDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public ClassDeclaration upToClassDeclaration() {
        if (!(this.getParent() instanceof ClassDeclaration)) {
            return null;
        }
        ClassDeclaration out = (ClassDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public MethodDeclaration upToMethodDeclaration() {
        if (!(this.getParent() instanceof MethodDeclaration)) {
            return null;
        }
        MethodDeclaration out = (MethodDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public VariableDefinition upToVariableDefinition() {
        if (!(this.getParent() instanceof VariableDefinition)) {
            return null;
        }
        VariableDefinition out = (VariableDefinition)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public EnumDeclaration upToEnumDeclaration() {
        if (!(this.getParent() instanceof EnumDeclaration)) {
            return null;
        }
        EnumDeclaration out = (EnumDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public ConstructorDeclaration upToConstructorDeclaration() {
        if (!(this.getParent() instanceof ConstructorDeclaration)) {
            return null;
        }
        ConstructorDeclaration out = (ConstructorDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public AnnotationMethodDeclaration upToAnnotationMethodDeclaration() {
        if (!(this.getParent() instanceof AnnotationMethodDeclaration)) {
            return null;
        }
        AnnotationMethodDeclaration out = (AnnotationMethodDeclaration)this.getParent();
        if (out.astModifiers() != this) {
            return null;
        }
        return out;
    }

    public RawListAccessor<Annotation, Modifiers> rawAnnotations() {
        return this.annotations.asRaw();
    }

    public StrictListAccessor<Annotation, Modifiers> astAnnotations() {
        return this.annotations.asStrict();
    }

    public RawListAccessor<KeywordModifier, Modifiers> rawKeywords() {
        return this.keywords.asRaw();
    }

    public StrictListAccessor<KeywordModifier, Modifiers> astKeywords() {
        return this.keywords.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.annotations.backingList());
        result.addAll(this.keywords.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.rawAnnotations().replace(original, replacement)) {
            return true;
        }
        return this.rawKeywords().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.rawAnnotations().remove(child)) {
            return true;
        }
        return this.rawKeywords().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitModifiers(this)) {
            return;
        }
        for (AbstractNode child : this.annotations.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.keywords.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitModifiers(this);
        visitor.endVisit(this);
    }

    @Override
    public Modifiers copy() {
        Modifiers result = new Modifiers();
        for (AbstractNode n : this.annotations.backingList()) {
            result.rawAnnotations().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.keywords.backingList()) {
            result.rawKeywords().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    public int getExplicitModifierFlags() {
        return ModifiersTemplate.getExplicitModifierFlags(this);
    }

    public int getEffectiveModifierFlags() {
        return ModifiersTemplate.getEffectiveModifierFlags(this);
    }

    public boolean isPublic() {
        return ModifiersTemplate.isPublic(this);
    }

    public boolean isProtected() {
        return ModifiersTemplate.isProtected(this);
    }

    public boolean isPrivate() {
        return ModifiersTemplate.isPrivate(this);
    }

    public boolean isPackagePrivate() {
        return ModifiersTemplate.isPackagePrivate(this);
    }

    public boolean isStatic() {
        return ModifiersTemplate.isStatic(this);
    }

    public boolean isFinal() {
        return ModifiersTemplate.isFinal(this);
    }

    public boolean isAbstract() {
        return ModifiersTemplate.isAbstract(this);
    }

    public boolean isTransient() {
        return ModifiersTemplate.isTransient(this);
    }

    public boolean isEmpty() {
        return ModifiersTemplate.isEmpty(this);
    }
}

