/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Catch;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.ListAccessor;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableDefinitionTemplate;

public class VariableDefinition
extends AbstractNode {
    private AbstractNode modifiers = this.adopt(new Modifiers());
    private AbstractNode typeReference = null;
    private boolean varargs = false;
    ListAccessor<VariableDefinitionEntry, VariableDefinition> variables = ListAccessor.of(this, VariableDefinitionEntry.class, "VariableDefinition.variables");

    public Catch upToCatch() {
        if (!(this.getParent() instanceof Catch)) {
            return null;
        }
        Catch out = (Catch)this.getParent();
        if (out.rawExceptionDeclaration() != this) {
            return null;
        }
        return out;
    }

    public ConstructorDeclaration upIfParameterToConstructorDeclaration() {
        if (!(this.getParent() instanceof ConstructorDeclaration)) {
            return null;
        }
        ConstructorDeclaration out = (ConstructorDeclaration)this.getParent();
        if (!out.rawParameters().contains(this)) {
            return null;
        }
        return out;
    }

    public MethodDeclaration upIfParameterToMethodDeclaration() {
        if (!(this.getParent() instanceof MethodDeclaration)) {
            return null;
        }
        MethodDeclaration out = (MethodDeclaration)this.getParent();
        if (!out.rawParameters().contains(this)) {
            return null;
        }
        return out;
    }

    public VariableDeclaration upToVariableDeclaration() {
        if (!(this.getParent() instanceof VariableDeclaration)) {
            return null;
        }
        VariableDeclaration out = (VariableDeclaration)this.getParent();
        if (out.rawDefinition() != this) {
            return null;
        }
        return out;
    }

    public For upToFor() {
        if (!(this.getParent() instanceof For)) {
            return null;
        }
        For out = (For)this.getParent();
        if (out.rawVariableDeclaration() != this) {
            return null;
        }
        return out;
    }

    public ForEach upToForEach() {
        if (!(this.getParent() instanceof ForEach)) {
            return null;
        }
        ForEach out = (ForEach)this.getParent();
        if (out.rawVariable() != this) {
            return null;
        }
        return out;
    }

    public Modifiers astModifiers() {
        if (!(this.modifiers instanceof Modifiers)) {
            return null;
        }
        return (Modifiers)this.modifiers;
    }

    public VariableDefinition astModifiers(Modifiers modifiers) {
        return this.rawModifiers(modifiers);
    }

    private VariableDefinition rawModifiers(Node modifiers) {
        if (modifiers == this.modifiers) {
            return this;
        }
        if (modifiers != null) {
            this.adopt((AbstractNode)modifiers);
        }
        if (this.modifiers != null) {
            this.disown(this.modifiers);
        }
        this.modifiers = (AbstractNode)modifiers;
        return this;
    }

    public TypeReference astTypeReference() {
        if (!(this.typeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.typeReference;
    }

    public VariableDefinition astTypeReference(TypeReference typeReference) {
        if (typeReference == null) {
            throw new NullPointerException("typeReference is mandatory");
        }
        return this.rawTypeReference(typeReference);
    }

    public Node rawTypeReference() {
        return this.typeReference;
    }

    public VariableDefinition rawTypeReference(Node typeReference) {
        if (typeReference == this.typeReference) {
            return this;
        }
        if (typeReference != null) {
            this.adopt((AbstractNode)typeReference);
        }
        if (this.typeReference != null) {
            this.disown(this.typeReference);
        }
        this.typeReference = (AbstractNode)typeReference;
        return this;
    }

    public boolean astVarargs() {
        return this.varargs;
    }

    public VariableDefinition astVarargs(boolean varargs) {
        this.varargs = varargs;
        return this;
    }

    public RawListAccessor<VariableDefinitionEntry, VariableDefinition> rawVariables() {
        return this.variables.asRaw();
    }

    public StrictListAccessor<VariableDefinitionEntry, VariableDefinition> astVariables() {
        return this.variables.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.modifiers != null) {
            result.add(this.modifiers);
        }
        if (this.typeReference != null) {
            result.add(this.typeReference);
        }
        result.addAll(this.variables.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.modifiers == original) {
            if (replacement instanceof Modifiers) {
                this.astModifiers((Modifiers)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Modifiers", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.typeReference == original) {
            this.rawTypeReference(replacement);
            return true;
        }
        return this.rawVariables().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.modifiers == child) {
            this.disown((AbstractNode)child);
            this.modifiers = null;
            return true;
        }
        if (this.typeReference == child) {
            this.disown((AbstractNode)child);
            this.typeReference = null;
            return true;
        }
        return this.rawVariables().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitVariableDefinition(this)) {
            return;
        }
        if (this.modifiers != null) {
            this.modifiers.accept(visitor);
        }
        if (this.typeReference != null) {
            this.typeReference.accept(visitor);
        }
        for (AbstractNode child : this.variables.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitVariableDefinition(this);
        visitor.endVisit(this);
    }

    @Override
    public VariableDefinition copy() {
        VariableDefinition result = new VariableDefinition();
        if (this.modifiers != null) {
            result.rawModifiers(this.modifiers.copy());
        }
        if (this.typeReference != null) {
            result.rawTypeReference(this.typeReference.copy());
        }
        result.varargs = this.varargs;
        for (AbstractNode n : this.variables.backingList()) {
            result.rawVariables().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    public TypeDeclaration upUpIfFieldToTypeDeclaration() {
        return VariableDefinitionTemplate.upUpIfFieldToTypeDeclaration(this);
    }

    public Block upUpIfLocalVariableToBlock() {
        return VariableDefinitionTemplate.upUpIfLocalVariableToBlock(this);
    }
}

