/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.tree.JCTree;

public final class SideEffectAnalysis
extends TreeScanner<Void, Void> {
    private boolean hasSideEffect = false;

    private SideEffectAnalysis() {
    }

    public static boolean hasSideEffect(ExpressionTree expression) {
        if (expression == null) {
            return false;
        }
        SideEffectAnalysis analyzer = new SideEffectAnalysis();
        expression.accept(analyzer, null);
        return analyzer.hasSideEffect;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree tree, Void unused) {
        this.hasSideEffect = true;
        return null;
    }

    @Override
    public Void visitUnary(UnaryTree tree, Void unused) {
        JCTree.JCUnary unary = (JCTree.JCUnary)tree;
        switch (unary.getKind()) {
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: {
                this.hasSideEffect = true;
                break;
            }
        }
        return (Void)super.visitUnary(tree, unused);
    }
}

