/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import lombok.ast.Message;
import lombok.ast.TypeReference;
import lombok.ast.syntaxChecks.MessageKey;

public class TypeChecks {
    public void checkNoPrimitivesInGenerics(TypeReference node) {
        if (!node.isPrimitive()) {
            return;
        }
        if (node.upIfTypeArgumentToTypeReferencePart() != null) {
            node.addMessage(Message.error(MessageKey.TYPEARGUMENT_PRIMITIVE_NOT_ALLOWED, "Primitive types aren't allowed in type arguments."));
            return;
        }
        if (node.upIfTypeVariableBoundToTypeVariable() != null) {
            node.addMessage(Message.error(MessageKey.TYPEVARIABLE_PRIMITIVE_NOT_ALLOWED, "Primitive types aren't allowed in type variable bounds."));
            return;
        }
    }

    public void checkVoidNotLegalJustAboutEverywhere(TypeReference node) {
        if (!node.isVoid()) {
            return;
        }
        if (node.astArrayDimensions() > 0) {
            node.addMessage(Message.error(MessageKey.TYPEREFERENCE_VOID_NOT_ALLOWED, "Array of void type is not legal."));
            return;
        }
        if (node.upIfReturnTypeToMethodDeclaration() != null) {
            return;
        }
        if (node.upToClassLiteral() != null) {
            return;
        }
        node.addMessage(Message.error(MessageKey.TYPEREFERENCE_VOID_NOT_ALLOWED, "The void type is not legal here."));
    }
}

