/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ForkJoinTask;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeKind;

@BugPattern(name="FutureReturnValueIgnored", summary="Return value of methods returning Future must be checked. Ignoring returned Futures suppresses exceptions thrown from the code that completes the Future.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class FutureReturnValueIgnored
extends AbstractReturnValueIgnored
implements BugChecker.ReturnTreeMatcher {
    private static final Matcher<ExpressionTree> BLACKLIST = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(ForkJoinTask.class.getName()).named("fork").withParameters(new String[0]), MethodMatchers.instanceMethod().onDescendantOf(CompletionService.class.getName()).named("submit"), MethodMatchers.instanceMethod().onDescendantOf("com.intellij.openapi.application.Application").named("executeOnPooledThread"), MethodMatchers.instanceMethod().onDescendantOf("io.netty.channel.ChannelFuture").withNameMatching(Pattern.compile("addListeners?")), MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.CompletableFuture").withNameMatching(Pattern.compile("completeAsync|orTimeout|completeOnTimeout"))});
    private static final Matcher<ExpressionTree> MATCHER = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type futureType = state.getTypeFromString("java.util.concurrent.Future");
            if (futureType == null) {
                return false;
            }
            Symbol untypedSymbol = ASTHelpers.getSymbol((Tree)tree);
            if (!(untypedSymbol instanceof Symbol.MethodSymbol)) {
                Type resultType = ASTHelpers.getResultType((ExpressionTree)tree);
                return resultType != null && ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)resultType, (Types)state.getTypes()), (Type)futureType, (VisitorState)state);
            }
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)untypedSymbol;
            if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, (VisitorState)state)) {
                return false;
            }
            for (Symbol.MethodSymbol superSym : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)sym, (Types)state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, (VisitorState)state) || !ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)superSym.getReturnType(), (Types)state.getTypes()), (Type)futureType, (VisitorState)state)) continue;
                return false;
            }
            if (BLACKLIST.matches((Tree)tree, state)) {
                return false;
            }
            Type returnType = sym.getReturnType();
            return ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnType, (Types)state.getTypes()), (Type)futureType, (VisitorState)state);
        }
    };
    private static final ImmutableSet<String> WHITELISTED_TYPES = ImmutableSet.of((Object)"org.mockito.stubbing.Answer", (Object)"graphql.schema.DataFetcher", (Object)"org.jmock.lib.action.CustomAction", (Object)"net.sf.cglib.proxy.MethodInterceptor", (Object)"org.aopalliance.intercept.MethodInterceptor", (Object)InvocationHandler.class.getName(), (Object[])new String[0]);

    public Matcher<ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Description description = super.matchMethodInvocation(tree, state);
        if (Description.NO_MATCH == description) {
            return this.checkLostType(tree, state);
        }
        return description;
    }

    private Description checkLostType(MethodInvocationTree tree, VisitorState state) {
        Type futureType = state.getTypeFromString("java.util.concurrent.Future");
        if (futureType == null) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Type returnType = ASTHelpers.getResultType((ExpressionTree)tree);
        Type returnedFutureType = state.getTypes().asSuper(returnType, futureType.tsym);
        if (returnedFutureType != null && !returnedFutureType.hasTag(TypeTag.ERROR) && !returnedFutureType.isRaw()) {
            if (ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnedFutureType.getTypeArguments().get(0), (Types)state.getTypes()), (Type)futureType, (VisitorState)state)) {
                return this.buildDescription(tree).setMessage(String.format("Method returns a nested type, %s", returnType)).build();
            }
            Type methodReturnType = sym.getReturnType();
            List typeParameters = sym.getTypeParameters();
            HashSet<Symbol.TypeVariableSymbol> returnTypeChoosing = new HashSet<Symbol.TypeVariableSymbol>();
            for (Symbol.TypeVariableSymbol tvs : typeParameters) {
                ArrayDeque<Symbol.TypeVariableSymbol> queue = new ArrayDeque<Symbol.TypeVariableSymbol>();
                queue.add(tvs);
                while (!queue.isEmpty()) {
                    Symbol.TypeVariableSymbol currentTypeParam = (Symbol.TypeVariableSymbol)queue.poll();
                    for (Type typeParam : methodReturnType.getTypeArguments()) {
                        if (typeParam.tsym != currentTypeParam) continue;
                        returnTypeChoosing.add(tvs);
                    }
                    for (Type toAdd : currentTypeParam.getBounds()) {
                        if (!(toAdd.tsym instanceof Symbol.TypeVariableSymbol)) continue;
                        queue.add((Symbol.TypeVariableSymbol)toAdd.tsym);
                    }
                }
            }
            if (!returnTypeChoosing.isEmpty()) {
                Multimap<Symbol.TypeVariableSymbol, TypeInfo> resolved = FutureReturnValueIgnored.getResolvedGenerics(tree);
                for (Symbol.TypeVariableSymbol returnTypeChoosingSymbol : returnTypeChoosing) {
                    Collection types = resolved.get((Object)returnTypeChoosingSymbol);
                    for (TypeInfo type : types) {
                        if (!ASTHelpers.isSubtype((Type)type.resolvedVariableType, (Type)futureType, (VisitorState)state)) continue;
                        return this.buildDescription(type.tree).setMessage(String.format("Invocation produces a nested type - Type variable %s, as part of return type %s resolved to %s.", returnTypeChoosingSymbol, methodReturnType, type.resolvedVariableType)).build();
                    }
                }
            }
        }
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode(FutureReturnValueIgnored::isObjectReturningLambdaExpression), Matchers.not(AbstractReturnValueIgnored::expectedExceptionTest)}), this.specializedMatcher(), Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)t), (VisitorState)s))}).matches((Tree)tree, state)) {
            return this.describe(tree, state);
        }
        return Description.NO_MATCH;
    }

    private static Multimap<Symbol.TypeVariableSymbol, TypeInfo> getResolvedGenerics(MethodInvocationTree tree) {
        Type type = ASTHelpers.getType((Tree)tree.getMethodSelect());
        ArrayList<Type> from = new ArrayList<Type>();
        ArrayList<Type> to = new ArrayList<Type>();
        FutureReturnValueIgnored.getSubst(type, from, to);
        Multimap result = (Multimap)Streams.zip(from.stream(), to.stream(), (f, t) -> new TypeInfo((Symbol.TypeVariableSymbol)f.asElement(), (Type)t, tree)).collect(Multimaps.toMultimap(k -> ((TypeInfo)k).sym, k -> k, () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.linkedHashKeys().arrayListValues()).build()));
        return result;
    }

    public static void getSubst(Type m, List<Type> from, List<Type> to) {
        try {
            Field substField = m.getClass().getDeclaredField("this$0");
            substField.setAccessible(true);
            Object subst = substField.get(m);
            Field fromField = subst.getClass().getDeclaredField("from");
            Field toField = subst.getClass().getDeclaredField("to");
            fromField.setAccessible(true);
            toField.setAccessible(true);
            from.addAll((Collection)fromField.get(subst));
            to.addAll((Collection)toField.get(subst));
        }
        catch (ReflectiveOperationException e) {
            return;
        }
    }

    private static boolean isObjectReturningMethodReferenceExpression(MemberReferenceTree tree, VisitorState state) {
        return FutureReturnValueIgnored.functionalInterfaceReturnsObject(((JCTree.JCMemberReference)tree).type, state);
    }

    private static boolean isObjectReturningLambdaExpression(Tree tree, VisitorState state) {
        if (!(tree instanceof LambdaExpressionTree)) {
            return false;
        }
        Type type = ((JCTree.JCLambda)tree).type;
        return FutureReturnValueIgnored.functionalInterfaceReturnsObject(type, state) && !FutureReturnValueIgnored.isWhitelistedInterfaceType(type, state);
    }

    private static boolean functionalInterfaceReturnsObject(Type interfaceType, VisitorState state) {
        Type objectType = state.getTypeFromString("java.lang.Object");
        return ASTHelpers.isSubtype((Type)objectType, (Type)ASTHelpers.getUpperBound((Type)state.getTypes().findDescriptorType(interfaceType).getReturnType(), (Types)state.getTypes()), (VisitorState)state);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Description description = super.matchMemberReference(tree, state);
        if (Description.NO_MATCH == description && Matchers.allOf((Matcher[])new Matcher[]{(Matcher & Serializable)(t, s) -> t.getMode() == MemberReferenceTree.ReferenceMode.INVOKE, FutureReturnValueIgnored::isObjectReturningMethodReferenceExpression, Matchers.not((Matcher & Serializable)(t, s) -> FutureReturnValueIgnored.isWhitelistedInterfaceType(((JCTree.JCMemberReference)t).type, s)), Matchers.not((Matcher & Serializable)(t, s) -> FutureReturnValueIgnored.isThrowingFunctionalInterface(s, ((JCTree.JCMemberReference)t).type)), this.specializedMatcher()}).matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return description;
    }

    private static boolean isWhitelistedInterfaceType(Type type, VisitorState state) {
        return WHITELISTED_TYPES.stream().map(arg_0 -> ((VisitorState)state).getTypeFromString(arg_0)).anyMatch(whitelistedType -> ASTHelpers.isSubtype((Type)type, (Type)whitelistedType, (VisitorState)state));
    }

    private static boolean isWhitelistedInterfaceMethod(Symbol.MethodSymbol symbol, VisitorState state) {
        return FutureReturnValueIgnored.isWhitelistedInterfaceType(ASTHelpers.enclosingClass((Symbol)symbol).type, state);
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        Type objectType = state.getTypeFromString("java.lang.Object");
        Type futureType = state.getTypeFromString("java.util.concurrent.Future");
        if (futureType == null) {
            return Description.NO_MATCH;
        }
        Type resultType = ASTHelpers.getResultType((ExpressionTree)tree.getExpression());
        if (resultType == null) {
            return Description.NO_MATCH;
        }
        if (resultType.getKind() == TypeKind.NULL || resultType.getKind() == TypeKind.NONE) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype((Type)resultType, (Type)futureType, (VisitorState)state)) {
            for (Tree enclosing : state.getPath()) {
                if (enclosing instanceof MethodTree) {
                    MethodTree methodTree = (MethodTree)enclosing;
                    Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)methodTree);
                    if (!ASTHelpers.isSubtype((Type)objectType, (Type)symbol.getReturnType(), (VisitorState)state) || FutureReturnValueIgnored.isWhitelistedInterfaceMethod(symbol, state)) break;
                    return this.buildDescription(tree).setMessage(String.format("Returning %s from method that returns %s. Errors from the returned future may be ignored.", resultType, symbol.getReturnType())).build();
                }
                if (!(enclosing instanceof LambdaExpressionTree)) continue;
                LambdaExpressionTree lambdaTree = (LambdaExpressionTree)enclosing;
                if (!FutureReturnValueIgnored.isObjectReturningLambdaExpression(lambdaTree, state)) break;
                return this.buildDescription(tree).setMessage(String.format("Returning %s from method that returns Object. Errors from the returned future will be ignored.", resultType)).build();
            }
        }
        return Description.NO_MATCH;
    }

    private static final class TypeInfo {
        private final Symbol.TypeVariableSymbol sym;
        private final Type resolvedVariableType;
        private final Tree tree;

        private TypeInfo(Symbol.TypeVariableSymbol sym, Type resolvedVariableType, Tree tree) {
            this.sym = sym;
            this.resolvedVariableType = resolvedVariableType;
            this.tree = tree;
        }
    }
}

