/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@BugPattern(name="ImmutableRefactoring", summary="Refactors uses of the JSR 305 @Immutable to Error Prone's annotation", severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ImmutableRefactoring
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableChecker immutableChecker = new ImmutableChecker((ImmutableSet<String>)ImmutableSet.of((Object)Immutable.class.getName(), (Object)com.google.errorprone.annotations.Immutable.class.getName()));
        Optional<ImportTree> immutableImport = tree.getImports().stream().filter(i -> {
            Symbol s = ASTHelpers.getSymbol((Tree)i.getQualifiedIdentifier());
            return s != null && s.getQualifiedName().contentEquals(Immutable.class.getName());
        }).findFirst();
        if (!immutableImport.isPresent()) {
            return Description.NO_MATCH;
        }
        final boolean[] ok = new boolean[]{true};
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                if (immutableChecker.matchClass(node, this.createVisitorState().withPath(this.getCurrentPath())) != Description.NO_MATCH) {
                    ok[0] = false;
                }
                return (Void)super.visitClass(node, null);
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                if (immutableChecker.matchNewClass(node, this.createVisitorState().withPath(this.getCurrentPath())) != Description.NO_MATCH) {
                    ok[0] = false;
                }
                return (Void)super.visitNewClass(node, null);
            }

            private VisitorState createVisitorState() {
                return VisitorState.createConfiguredForCompilation((Context)state.context, description -> {
                    ok2[0] = false;
                }, (Map)ImmutableMap.of(), (ErrorProneOptions)state.errorProneOptions());
            }
        }.scan(state.getPath(), (Void)null);
        if (!ok[0]) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(immutableImport.get(), (Fix)SuggestedFix.builder().removeImport(Immutable.class.getName()).addImport(com.google.errorprone.annotations.Immutable.class.getName()).build());
    }
}

