/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@BugPattern(name="UnusedMethod", altNames={"Unused", "unused", "UnusedParameters"}, summary="Unused.", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnusedMethod
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String GWT_JAVASCRIPT_OBJECT = "com.google.gwt.core.client.JavaScriptObject";
    private static final String EXEMPT_PREFIX = "unused";
    private static final String JUNIT_PARAMS_VALUE = "value";
    private static final String JUNIT_PARAMS_ANNOTATION_TYPE = "junitparams.Parameters";
    private static final Supplier<Type> OBJECT = Suppliers.typeFromString((String)"java.lang.Object");
    private static final Matcher<MethodTree> SPECIAL_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readObject"), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.isSameType((String)"java.io.ObjectInputStream")})}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"writeObject"), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.isSameType((String)"java.io.ObjectOutputStream")})}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readObjectNoData"), Matchers.methodReturns((Matcher)Matchers.isVoidType())}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readResolve"), Matchers.methodReturns(OBJECT)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"writeReplace"), Matchers.methodReturns(OBJECT)})});
    private static final ImmutableSet<String> EXEMPTING_METHOD_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.Provides", (Object)"com.google.inject.Inject", (Object)"javax.inject.Inject");
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashMap unusedMethods = new HashMap();
        if (UnusedMethod.hasNativeMethods(tree)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean ignoreUnusedMethods = new AtomicBoolean(false);
        class MethodFinder
        extends TreePathScanner<Void, Void> {
            MethodFinder() {
            }

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                if (UnusedMethod.this.isSuppressed(tree) || this.exemptedBySuperType(ASTHelpers.getType((ClassTree)tree), state)) {
                    return null;
                }
                return (Void)super.visitClass(tree, null);
            }

            private boolean exemptedBySuperType(Type type, VisitorState state2) {
                return EXEMPTING_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)((Type)Suppliers.typeFromString((String)t).get(state2)), (VisitorState)state2));
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (this.hasJUnitParamsParametersForMethodAnnotation(tree.getModifiers().getAnnotations())) {
                    ignoreUnusedMethods.set(true);
                }
                if (UnusedMethod.this.isSuppressed(tree)) {
                    return null;
                }
                if (this.isMethodSymbolEligibleForChecking(tree)) {
                    unusedMethods.put(ASTHelpers.getSymbol((MethodTree)tree), this.getCurrentPath());
                }
                return (Void)super.visitMethod(tree, unused);
            }

            private boolean hasJUnitParamsParametersForMethodAnnotation(Collection<? extends AnnotationTree> annotations) {
                for (AnnotationTree annotationTree : annotations) {
                    JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
                    if (annotation.getAnnotationType().type == null || !annotation.getAnnotationType().type.toString().equals(UnusedMethod.JUNIT_PARAMS_ANNOTATION_TYPE)) continue;
                    if (((List)annotation.getArguments()).isEmpty()) {
                        return true;
                    }
                    for (JCTree.JCExpression arg : annotation.getArguments()) {
                        if (arg.getKind() != Tree.Kind.ASSIGNMENT) {
                            return false;
                        }
                        JCTree.JCExpression var = ((JCTree.JCAssign)arg).getVariable();
                        if (var.getKind() != Tree.Kind.IDENTIFIER || ((IdentifierTree)((Object)var)).getName().contentEquals(UnusedMethod.JUNIT_PARAMS_VALUE)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean isMethodSymbolEligibleForChecking(MethodTree tree) {
                Type lastParamType;
                if (UnusedMethod.exemptedByName(tree.getName())) {
                    return false;
                }
                if (UnusedMethod.exemptedByAnnotation(tree.getModifiers().getAnnotations(), state)) {
                    return false;
                }
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
                if (methodSymbol == null || methodSymbol.getKind() == ElementKind.CONSTRUCTOR || SPECIAL_METHODS.matches((Tree)tree, state)) {
                    return false;
                }
                if (!tree.getParameters().isEmpty() && (lastParamType = ASTHelpers.getType((Tree)((Tree)Iterables.getLast(tree.getParameters())))) != null && lastParamType.toString().equals(UnusedMethod.GWT_JAVASCRIPT_OBJECT)) {
                    return false;
                }
                return tree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE);
            }
        }
        new MethodFinder().scan(state.getPath(), null);
        class FilterUsedMethods
        extends TreePathScanner<Void, Void> {
            FilterUsedMethods() {
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)memberSelectTree);
                unusedMethods.remove(symbol);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                super.visitMemberReference(tree, null);
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
                unusedMethods.remove(symbol);
                if (symbol != null) {
                    symbol.getParameters().forEach(unusedMethods::remove);
                }
                return null;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
                if (methodSymbol != null) {
                    unusedMethods.remove(methodSymbol);
                }
                super.visitMethodInvocation(tree, null);
                return null;
            }
        }
        new FilterUsedMethods().scan(state.getPath(), null);
        if (ignoreUnusedMethods.get()) {
            return Description.NO_MATCH;
        }
        for (TreePath unusedPath : unusedMethods.values()) {
            Tree unusedTree = unusedPath.getLeaf();
            String message = String.format("Private method '%s' is never used.", ((MethodTree)unusedTree).getName());
            state.reportMatch(this.buildDescription(unusedTree).addFix((Fix)SuggestedFixes.replaceIncludingComments((TreePath)unusedPath, (String)"", (VisitorState)state)).setMessage(message).build());
        }
        return Description.NO_MATCH;
    }

    static boolean hasNativeMethods(CompilationUnitTree tree) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(tree, null);
        return hasAnyNativeMethods.get();
    }

    private static boolean exemptedByAnnotation(java.util.List<? extends AnnotationTree> annotations, VisitorState state) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            if (((JCTree.JCAnnotation)annotationTree).type == null || !EXEMPTING_METHOD_ANNOTATIONS.contains((Object)(tsym = ((JCTree.JCAnnotation)annotationTree).type.tsym).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean exemptedByName(Name name) {
        return Ascii.toLowerCase((String)name.toString()).startsWith(EXEMPT_PREFIX);
    }
}

