/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.Duration;
import java.time.ZoneId;
import java.util.TimeZone;

@BugPattern(name="ThreeLetterTimeZoneID", summary="Three-letter time zone identifiers are deprecated, may be ambiguous, and might not do what you intend; the full IANA time zone ID should be used instead.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ThreeLetterTimeZoneID
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    static final String SUMMARY = "Three-letter time zone identifiers are deprecated, may be ambiguous, and might not do what you intend; the full IANA time zone ID should be used instead.";
    private static final Matcher<ExpressionTree> METHOD_MATCHER = MethodMatchers.staticMethod().onClass("java.util.TimeZone").withSignature("getTimeZone(java.lang.String)");
    private static final Matcher<ExpressionTree> JODATIME_METHOD_MATCHER = MethodMatchers.staticMethod().onClass("org.joda.time.DateTimeZone").withSignature("forTimeZone(java.util.TimeZone)");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String value = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0), String.class);
        if (value == null) {
            return Description.NO_MATCH;
        }
        Replacement replacement = ThreeLetterTimeZoneID.getReplacement(value, ThreeLetterTimeZoneID.isInJodaTimeContext(state));
        if (replacement.replacements.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree).setMessage(replacement.message);
        for (String r : replacement.replacements) {
            builder.addFix((Fix)SuggestedFix.replace((Tree)tree.getArguments().get(0), (String)state.getTreeMaker().Literal(r).toString()));
        }
        return builder.build();
    }

    static Replacement getReplacement(String id, boolean inJodaTimeContext) {
        long hours;
        long millis;
        TimeZone timeZone;
        switch (id) {
            case "EST": {
                return ThreeLetterTimeZoneID.handleNonDaylightSavingsZone(inJodaTimeContext, "America/New_York", "Etc/GMT+5");
            }
            case "HST": {
                return ThreeLetterTimeZoneID.handleNonDaylightSavingsZone(inJodaTimeContext, "Pacific/Honolulu", "Etc/GMT+10");
            }
            case "MST": {
                return ThreeLetterTimeZoneID.handleNonDaylightSavingsZone(inJodaTimeContext, "America/Denver", "Etc/GMT+7");
            }
        }
        String zoneIdReplacement = ZoneId.SHORT_IDS.get(id);
        if (zoneIdReplacement == null) {
            return Replacement.NO_REPLACEMENT;
        }
        if (id.endsWith("ST") && (timeZone = TimeZone.getTimeZone(id)).observesDaylightTime() && (millis = Duration.ofHours(hours = Duration.ofMillis(timeZone.getRawOffset()).toHours()).toMillis()) == (long)timeZone.getRawOffset()) {
            String fixedOffset = String.format("Etc/GMT%+d", -hours);
            String newDescription = "Three-letter time zone identifiers are deprecated, may be ambiguous, and might not do what you intend; the full IANA time zone ID should be used instead.\n\n" + ThreeLetterTimeZoneID.observesDaylightSavingsMessage("TimeZone", zoneIdReplacement, fixedOffset);
            return new Replacement(newDescription, (ImmutableList<String>)ImmutableList.of((Object)zoneIdReplacement, (Object)fixedOffset));
        }
        return new Replacement(SUMMARY, (ImmutableList<String>)ImmutableList.of((Object)zoneIdReplacement));
    }

    static Replacement handleNonDaylightSavingsZone(boolean inJodaTimeContext, String daylightSavingsZone, String fixedOffset) {
        if (inJodaTimeContext) {
            String newDescription = "Three-letter time zone identifiers are deprecated, may be ambiguous, and might not do what you intend; the full IANA time zone ID should be used instead.\n\n" + ThreeLetterTimeZoneID.observesDaylightSavingsMessage("DateTimeZone", daylightSavingsZone, fixedOffset);
            return new Replacement(newDescription, (ImmutableList<String>)ImmutableList.of((Object)daylightSavingsZone, (Object)fixedOffset));
        }
        String newDescription = "Three-letter time zone identifiers are deprecated, may be ambiguous, and might not do what you intend; the full IANA time zone ID should be used instead.\n\nThis TimeZone will not observe daylight savings. If this is intended, use " + fixedOffset + " instead; to observe daylight savings, use " + daylightSavingsZone + ".";
        return new Replacement(newDescription, (ImmutableList<String>)ImmutableList.of((Object)fixedOffset, (Object)daylightSavingsZone));
    }

    private static String observesDaylightSavingsMessage(String type, String daylightSavingsZone, String fixedOffset) {
        return "This " + type + " will observe daylight savings. If this is intended, use " + daylightSavingsZone + " instead; otherwise use " + fixedOffset + ".";
    }

    private static boolean isInJodaTimeContext(VisitorState state) {
        Tree parentLeaf;
        return state.getPath().getParentPath() != null && (parentLeaf = state.getPath().getParentPath().getLeaf()) instanceof ExpressionTree && JODATIME_METHOD_MATCHER.matches((Tree)((ExpressionTree)parentLeaf), state);
    }

    @VisibleForTesting
    static final class Replacement {
        static final Replacement NO_REPLACEMENT = new Replacement("", (ImmutableList<String>)ImmutableList.of());
        final String message;
        final ImmutableList<String> replacements;

        Replacement(String message, ImmutableList<String> replacements) {
            this.message = message;
            this.replacements = replacements;
        }
    }
}

