/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Iterator;

@BugPattern(name="ShortCircuitBoolean", summary="Prefer the short-circuiting boolean operators && and || to & and |.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ShortCircuitBoolean
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case AND: 
            case OR: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)state.getSymtab().booleanType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Iterator<Tree> stateIterator = state.getPath().getParentPath().iterator();
        Tree parent = stateIterator.next();
        if (parent instanceof BinaryTree && (parent.getKind() == Tree.Kind.AND || parent.getKind() == Tree.Kind.OR)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        new TreeScannerBinary(state).scan(tree, fix);
        return this.describeMatch(tree, (Fix)fix.build());
    }

    public static class TreeScannerBinary
    extends TreeScanner<Void, SuggestedFix.Builder> {
        public VisitorState state;

        public TreeScannerBinary(VisitorState currState) {
            this.state = currState;
        }

        @Override
        public Void visitBinary(BinaryTree tree, SuggestedFix.Builder p) {
            if (tree.getKind() == Tree.Kind.AND || tree.getKind() == Tree.Kind.OR) {
                p.replace(this.state.getEndPosition((Tree)tree.getLeftOperand()), ((JCTree)((Object)tree.getRightOperand())).getStartPosition(), tree.getKind() == Tree.Kind.AND ? " && " : " || ");
            }
            return (Void)super.visitBinary(tree, p);
        }
    }
}

