/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MisusedWeekYear", summary="Use of \"YYYY\" (week year) in a date pattern without \"ww\" (week in year). You probably meant to use \"yyyy\" (year) instead.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class MisusedWeekYear
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String JAVA_SIMPLE_DATE_FORMAT = "java.text.SimpleDateFormat";
    private static final String ICU_SIMPLE_DATE_FORMAT = "com.ibm.icu.text.SimpleDateFormat";
    private static final Matcher<NewClassTree> PATTERN_CTOR_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String"}), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.text.DateFormatSymbols"}), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.util.Locale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "com.ibm.icu.text.DateFormatSymbols"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "com.ibm.icu.text.DateFormatSymbols", "com.ibm.icu.util.ULocale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.util.Locale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.lang.String", "com.ibm.icu.util.ULocale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "com.ibm.icu.util.ULocale"})});
    private static final Matcher<ExpressionTree> PATTERN_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("java.text.SimpleDateFormat").named("applyPattern"), Matchers.instanceMethod().onExactClass("java.text.SimpleDateFormat").named("applyLocalizedPattern"), Matchers.instanceMethod().onExactClass("com.ibm.icu.text.SimpleDateFormat").named("applyPattern"), Matchers.instanceMethod().onExactClass("com.ibm.icu.text.SimpleDateFormat").named("applyLocalizedPattern"), MethodMatchers.staticMethod().onClass("java.time.format.DateTimeFormatter").named("ofPattern")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!PATTERN_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.constructDescription(tree, tree.getArguments().get(0), state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!PATTERN_CTOR_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.constructDescription(tree, tree.getArguments().get(0), state);
    }

    private Description constructDescription(Tree tree, ExpressionTree patternArg, VisitorState state) {
        String pattern = (String)ASTHelpers.constValue((Tree)patternArg);
        if (pattern != null && pattern.contains("Y") && !pattern.contains("w")) {
            Description.Builder description = this.buildDescription(tree);
            this.getFix(patternArg, state).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
            return description.build();
        }
        return Description.NO_MATCH;
    }

    private Optional<SuggestedFix> getFix(ExpressionTree patternArg, final VisitorState state) {
        if (patternArg.getKind() == Tree.Kind.STRING_LITERAL) {
            String replacement = state.getSourceForNode((Tree)patternArg).replace('Y', 'y');
            return Optional.of(SuggestedFix.replace((Tree)patternArg, (String)replacement));
        }
        final Symbol sym = ASTHelpers.getSymbol((Tree)patternArg);
        if (sym instanceof Symbol.VarSymbol && sym.getKind() == ElementKind.FIELD) {
            final SuggestedFix[] fix = new SuggestedFix[]{null};
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitVariable(VariableTree node, Void aVoid) {
                    String replacement;
                    String source;
                    if (sym.equals(ASTHelpers.getSymbol((VariableTree)node)) && node.getInitializer() != null && node.getInitializer().getKind() == Tree.Kind.STRING_LITERAL && !(source = state.getSourceForNode((Tree)node.getInitializer())).equals(replacement = source.replace('Y', 'y'))) {
                        fix[0] = SuggestedFix.replace((Tree)node.getInitializer(), (String)replacement);
                    }
                    return (Void)super.visitVariable(node, aVoid);
                }
            }.scan(state.getPath().getCompilationUnit(), null);
            return Optional.ofNullable(fix[0]);
        }
        return Optional.empty();
    }
}

