/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import java.util.Objects;

@BugPattern(name="ComplexBooleanConstant", summary="Non-trivial compile time constant boolean expressions shouldn't be used.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ComplexBooleanConstant
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        Boolean constValue = this.booleanValue(tree);
        if (constValue == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFix.replace((Tree)tree, (String)constValue.toString())).setMessage(String.format("This expression always evalutes to `%s`, prefer a boolean literal for clarity.", constValue)).build();
    }

    Boolean booleanValue(BinaryTree tree) {
        if (tree.getLeftOperand() instanceof JCTree.JCLiteral && tree.getRightOperand() instanceof JCTree.JCLiteral) {
            return (Boolean)ASTHelpers.constValue((Tree)tree, Boolean.class);
        }
        SimpleTreeVisitor<Boolean, Void> boolValue = new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitLiteral(LiteralTree node, Void aVoid) {
                if (node.getValue() instanceof Boolean) {
                    return (Boolean)node.getValue();
                }
                return null;
            }

            @Override
            public Boolean visitUnary(UnaryTree node, Void aVoid) {
                Boolean r = node.getExpression().accept(this, null);
                if (r == null) {
                    return null;
                }
                switch (node.getKind()) {
                    case LOGICAL_COMPLEMENT: {
                        return r == false;
                    }
                }
                return null;
            }
        };
        Boolean lhs = tree.getLeftOperand().accept(boolValue, null);
        Boolean rhs = tree.getRightOperand().accept(boolValue, null);
        switch (tree.getKind()) {
            case CONDITIONAL_AND: 
            case AND: {
                if (lhs != null && rhs != null) {
                    return lhs != false && rhs != false;
                }
                if (!Objects.equals(lhs, Boolean.FALSE) && !Objects.equals(rhs, Boolean.FALSE)) break;
                return false;
            }
            case CONDITIONAL_OR: 
            case OR: {
                if (lhs != null && rhs != null) {
                    return lhs != false || rhs != false;
                }
                if (!Objects.equals(lhs, Boolean.TRUE) && !Objects.equals(rhs, Boolean.TRUE)) break;
                return true;
            }
        }
        return null;
    }
}

