/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.shellsupport.doc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public abstract class JavadocHelper
implements AutoCloseable {
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public static JavadocHelper create(JavacTask javacTask, Collection<? extends Path> collection) {
        StandardJavaFileManager standardJavaFileManager = compiler.getStandardFileManager(null, null, null);
        try {
            standardJavaFileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, collection);
            return new OnDemandJavadocHelper(javacTask, standardJavaFileManager);
        }
        catch (IOException iOException) {
            try {
                standardJavaFileManager.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return new JavadocHelper(){

                @Override
                public String getResolvedDocComment(Element element) throws IOException {
                    return null;
                }

                @Override
                public Element getSourceElement(Element element) throws IOException {
                    return element;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public abstract String getResolvedDocComment(Element var1) throws IOException;

    public abstract Element getSourceElement(Element var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    private static final class OnDemandJavadocHelper
    extends JavadocHelper {
        private final JavacTask mainTask;
        private final JavaFileManager baseFileManager;
        private final StandardJavaFileManager fm;
        private final Map<String, Pair<JavacTask, TreePath>> signature2Source = new HashMap<String, Pair<JavacTask, TreePath>>();

        private OnDemandJavadocHelper(JavacTask javacTask, StandardJavaFileManager standardJavaFileManager) {
            this.mainTask = javacTask;
            this.baseFileManager = ((JavacTaskImpl)javacTask).getContext().get(JavaFileManager.class);
            this.fm = standardJavaFileManager;
        }

        @Override
        public String getResolvedDocComment(Element element) throws IOException {
            Pair<JavacTask, TreePath> pair = this.getSourceElement(this.mainTask, element);
            if (pair == null) {
                return null;
            }
            return this.getResolvedDocComment((JavacTask)pair.fst, (TreePath)pair.snd);
        }

        @Override
        public Element getSourceElement(Element element) throws IOException {
            Pair<JavacTask, TreePath> pair = this.getSourceElement(this.mainTask, element);
            if (pair == null) {
                return element;
            }
            Element element2 = Trees.instance((JavaCompiler.CompilationTask)pair.fst).getElement((TreePath)pair.snd);
            if (element2 == null) {
                return element;
            }
            return element2;
        }

        private String getResolvedDocComment(final JavacTask javacTask, final TreePath treePath) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DocTrees docTrees = DocTrees.instance(javacTask);
            final Element element = docTrees.getElement(treePath);
            String string = docTrees.getDocComment(treePath);
            if (string == null && element.getKind() == ElementKind.METHOD) {
                object4 = (ExecutableElement)element;
                object3 = () -> this.superTypeForInheritDoc(javacTask, element.getEnclosingElement()).iterator();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Element)object2.next();
                    for (ExecutableElement object5 : ElementFilter.methodsIn(object.getEnclosedElements())) {
                        String string2;
                        Pair<JavacTask, TreePath> pair;
                        TypeElement typeElement = (TypeElement)object4.getEnclosingElement();
                        if (!javacTask.getElements().overrides((ExecutableElement)object4, object5, typeElement) || (pair = this.getSourceElement(javacTask, object5)) == null || (string2 = this.getResolvedDocComment((JavacTask)pair.fst, (TreePath)pair.snd)) == null) continue;
                        return string2;
                    }
                }
            }
            object4 = this.parseDocComment(javacTask, string);
            object3 = new IOException[1];
            object2 = new TreeMap((nArray, nArray2) -> nArray2[0] - nArray[0]);
            new DocTreeScanner<Void, Void>((DocCommentTree)object4, (IOException[])object3, docTrees, (Map)object2){
                private Stack<DocTree> interestingParent = new Stack();
                private DocCommentTree dcTree;
                private JavacTask inheritedJavacTask;
                private TreePath inheritedTreePath;
                private String inherited;
                private Map<DocTree, String> syntheticTrees = new IdentityHashMap<DocTree, String>();
                private long lastPos = 0L;
                private boolean inSynthetic;
                private final List<DocTree.Kind> tagOrder = Arrays.asList(DocTree.Kind.PARAM, DocTree.Kind.THROWS, DocTree.Kind.RETURN);
                final /* synthetic */ DocCommentTree val$docCommentTree;
                final /* synthetic */ IOException[] val$exception;
                final /* synthetic */ DocTrees val$trees;
                final /* synthetic */ Map val$replace;
                {
                    this.val$docCommentTree = docCommentTree;
                    this.val$exception = iOExceptionArray;
                    this.val$trees = docTrees;
                    this.val$replace = map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
                    this.dcTree = docCommentTree;
                    this.interestingParent.push(docCommentTree);
                    try {
                        ExecutableElement executableElement;
                        this.scan(docCommentTree.getFirstSentence(), void_);
                        this.scan(docCommentTree.getBody(), void_);
                        ArrayList<DocTree> arrayList = new ArrayList<DocTree>(docCommentTree.getBlockTags());
                        if (element.getKind() == ElementKind.METHOD) {
                            DocTree docTree;
                            executableElement = (ExecutableElement)element;
                            List<String> list = executableElement.getParameters().stream().map(variableElement -> variableElement.getSimpleName().toString()).collect(Collectors.toList());
                            List<String> list2 = executableElement.getThrownTypes().stream().map(TypeMirror::toString).collect(Collectors.toList());
                            HashSet hashSet = new HashSet(list);
                            HashSet hashSet2 = new HashSet(list2);
                            boolean bl = false;
                            for (DocTree object : arrayList) {
                                switch (object.getKind()) {
                                    case PARAM: {
                                        hashSet.remove(((ParamTree)object).getName().getName().toString());
                                        break;
                                    }
                                    case THROWS: {
                                        hashSet2.remove(this.getThrownException(javacTask, treePath, this.val$docCommentTree, (ThrowsTree)object));
                                        break;
                                    }
                                    case RETURN: {
                                        bl = true;
                                    }
                                }
                            }
                            for (String string : hashSet) {
                                docTree = this.parseBlockTag(javacTask, "@param " + string + " {@inheritDoc}");
                                this.syntheticTrees.put(docTree, "@param " + string + " ");
                                this.insertTag(arrayList, docTree, list, list2);
                            }
                            for (String string : hashSet2) {
                                docTree = this.parseBlockTag(javacTask, "@throws " + string + " {@inheritDoc}");
                                this.syntheticTrees.put(docTree, "@throws " + string + " ");
                                this.insertTag(arrayList, docTree, list, list2);
                            }
                            if (!bl) {
                                DocTree docTree2 = this.parseBlockTag(javacTask, "@return {@inheritDoc}");
                                this.syntheticTrees.put(docTree2, "@return ");
                                this.insertTag(arrayList, docTree2, list, list2);
                            }
                        }
                        this.scan(arrayList, void_);
                        executableElement = null;
                        return executableElement;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitParam(ParamTree paramTree, Void void_) {
                    this.interestingParent.push(paramTree);
                    try {
                        Void void_2 = (Void)super.visitParam(paramTree, void_);
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitThrows(ThrowsTree throwsTree, Void void_) {
                    this.interestingParent.push(throwsTree);
                    try {
                        Void void_2 = (Void)super.visitThrows(throwsTree, void_);
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitReturn(ReturnTree returnTree, Void void_) {
                    this.interestingParent.push(returnTree);
                    try {
                        Void void_2 = (Void)super.visitReturn(returnTree, void_);
                        return void_2;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                @Override
                public Void visitInheritDoc(InheritDocTree inheritDocTree, Void void_) {
                    Iterable<Object> iterable;
                    Object object;
                    block16: {
                        if (this.inherited == null) {
                            try {
                                if (element.getKind() != ElementKind.METHOD) break block16;
                                object = (ExecutableElement)element;
                                iterable = () -> this.superTypeForInheritDoc(javacTask, element.getEnclosingElement()).iterator();
                                for (Object object2 : iterable) {
                                    for (ExecutableElement executableElement : ElementFilter.methodsIn(object2.getEnclosedElements())) {
                                        String string;
                                        Pair pair;
                                        if (!javacTask.getElements().overrides((ExecutableElement)object, executableElement, (TypeElement)object.getEnclosingElement()) || (pair = this.getSourceElement(javacTask, executableElement)) == null || (string = this.getResolvedDocComment((JavacTask)pair.fst, (TreePath)pair.snd)) == null) continue;
                                        this.inheritedJavacTask = (JavacTask)pair.fst;
                                        this.inheritedTreePath = (TreePath)pair.snd;
                                        this.inherited = string;
                                        break block16;
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                this.val$exception[0] = iOException;
                                return null;
                            }
                        }
                    }
                    if (this.inherited == null) {
                        return null;
                    }
                    object = this.parseDocComment(this.inheritedJavacTask, this.inherited);
                    iterable = new ArrayList();
                    DocTree docTree = this.interestingParent.peek();
                    switch (docTree.getKind()) {
                        case DOC_COMMENT: {
                            iterable.add(object.getFullBody());
                            break;
                        }
                        case PARAM: {
                            Object object2;
                            object2 = ((ParamTree)docTree).getName().getName().toString();
                            new DocTreeScanner<Void, Void>((String)object2, iterable){
                                final /* synthetic */ String val$paramName;
                                final /* synthetic */ List val$inheritedText;
                                {
                                    this.val$paramName = string;
                                    this.val$inheritedText = list;
                                }

                                @Override
                                public Void visitParam(ParamTree paramTree, Void void_) {
                                    if (paramTree.getName().getName().contentEquals(this.val$paramName)) {
                                        this.val$inheritedText.add(paramTree.getDescription());
                                    }
                                    return (Void)super.visitParam(paramTree, void_);
                                }
                            }.scan((DocTree)object, null);
                            break;
                        }
                        case THROWS: {
                            String string = this.getThrownException(javacTask, treePath, this.val$docCommentTree, (ThrowsTree)docTree);
                            new DocTreeScanner<Void, Void>((DocCommentTree)object, string, iterable){
                                final /* synthetic */ DocCommentTree val$inheritedDocTree;
                                final /* synthetic */ String val$thrownName;
                                final /* synthetic */ List val$inheritedText;
                                {
                                    this.val$inheritedDocTree = docCommentTree;
                                    this.val$thrownName = string;
                                    this.val$inheritedText = list;
                                }

                                @Override
                                public Void visitThrows(ThrowsTree throwsTree, Void void_) {
                                    if (Objects.equals(this.getThrownException(inheritedJavacTask, inheritedTreePath, this.val$inheritedDocTree, throwsTree), this.val$thrownName)) {
                                        this.val$inheritedText.add(throwsTree.getDescription());
                                    }
                                    return (Void)super.visitThrows(throwsTree, void_);
                                }
                            }.scan((DocTree)object, null);
                            break;
                        }
                        case RETURN: {
                            new DocTreeScanner<Void, Void>(){

                                @Override
                                public Void visitReturn(ReturnTree returnTree, Void void_) {
                                    iterable.add(returnTree.getDescription());
                                    return (Void)super.visitReturn(returnTree, void_);
                                }
                            }.scan((DocTree)object, null);
                        }
                    }
                    if (!iterable.isEmpty()) {
                        long l = this.val$trees.getSourcePositions().getStartPosition(null, (DocCommentTree)object, (DocTree)object);
                        long l2 = Long.MAX_VALUE;
                        long l3 = Long.MIN_VALUE;
                        for (DocTree docTree2 : (List)iterable.get(0)) {
                            l2 = Math.min(l2, this.val$trees.getSourcePositions().getStartPosition(null, (DocCommentTree)object, docTree2) - l);
                            l3 = Math.max(l3, this.val$trees.getSourcePositions().getEndPosition(null, (DocCommentTree)object, docTree2) - l);
                        }
                        String string = this.inherited.substring((int)l2, (int)l3);
                        if (this.syntheticTrees.containsKey(docTree)) {
                            this.val$replace.put(new int[]{(int)this.lastPos + 1, (int)this.lastPos}, "\n" + this.syntheticTrees.get(docTree) + (String)string);
                        } else {
                            long l4 = this.val$trees.getSourcePositions().getStartPosition(null, this.dcTree, inheritDocTree);
                            long l5 = this.val$trees.getSourcePositions().getEndPosition(null, this.dcTree, inheritDocTree);
                            this.val$replace.put(new int[]{(int)l4, (int)l5}, string);
                        }
                    }
                    return (Void)super.visitInheritDoc(inheritDocTree, void_);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void scan(DocTree docTree, Void void_) {
                    if (this.val$exception[0] != null) {
                        return null;
                    }
                    boolean bl = this.inSynthetic;
                    try {
                        this.inSynthetic |= this.syntheticTrees.containsKey(docTree);
                        Void void_2 = (Void)super.scan(docTree, void_);
                        return void_2;
                    }
                    finally {
                        if (!this.inSynthetic) {
                            this.lastPos = this.val$trees.getSourcePositions().getEndPosition(null, this.dcTree, docTree);
                        }
                        this.inSynthetic = bl;
                    }
                }

                private void insertTag(List<DocTree> list, DocTree docTree, List<String> list2, List<String> list3) {
                    Comparator comparator = (docTree2, docTree3) -> {
                        if (docTree2.getKind() == docTree3.getKind()) {
                            switch (docTree.getKind()) {
                                case PARAM: {
                                    ParamTree paramTree = (ParamTree)docTree2;
                                    ParamTree paramTree2 = (ParamTree)docTree3;
                                    int n = list2.indexOf(paramTree.getName().getName().toString());
                                    int n2 = list2.indexOf(paramTree2.getName().getName().toString());
                                    return n - n2;
                                }
                                case THROWS: {
                                    ThrowsTree throwsTree = (ThrowsTree)docTree2;
                                    ThrowsTree throwsTree2 = (ThrowsTree)docTree3;
                                    int n = list3.indexOf(this.getThrownException(javacTask, treePath, this.val$docCommentTree, throwsTree));
                                    int n3 = list3.indexOf(this.getThrownException(javacTask, treePath, this.val$docCommentTree, throwsTree2));
                                    return n - n3;
                                }
                            }
                        }
                        int n = this.tagOrder.indexOf((Object)docTree2.getKind());
                        int n4 = this.tagOrder.indexOf((Object)docTree3.getKind());
                        return n - n4;
                    };
                    for (int i = 0; i < list.size(); ++i) {
                        if (comparator.compare(list.get(i), docTree) < 0) continue;
                        list.add(i, docTree);
                        return;
                    }
                    list.add(docTree);
                }
            }.scan((DocTree)object4, (Void)null);
            if (object2.isEmpty()) {
                return string;
            }
            object = new StringBuilder(string);
            int n = (int)docTrees.getSourcePositions().getStartPosition(null, (DocCommentTree)object4, (DocTree)object4);
            for (Map.Entry entry : object2.entrySet()) {
                ((StringBuilder)object).delete(((int[])entry.getKey())[0] - n, ((int[])entry.getKey())[1] - n + 1);
                ((StringBuilder)object).insert(((int[])entry.getKey())[0] - n, (String)entry.getValue());
            }
            return ((StringBuilder)object).toString();
        }

        private Stream<Element> superTypeForInheritDoc(JavacTask javacTask, Element element2) {
            TypeElement typeElement = (TypeElement)element2;
            Stream<Element> stream = this.interfaces(typeElement);
            stream = Stream.concat(stream, this.interfaces(typeElement).flatMap(element -> this.superTypeForInheritDoc(javacTask, (Element)element)));
            if (typeElement.getSuperclass().getKind() == TypeKind.DECLARED) {
                Element element3 = ((DeclaredType)typeElement.getSuperclass()).asElement();
                stream = Stream.concat(stream, Stream.of(element3));
                stream = Stream.concat(stream, this.superTypeForInheritDoc(javacTask, element3));
            }
            return stream;
        }

        private Stream<Element> interfaces(TypeElement typeElement) {
            return typeElement.getInterfaces().stream().filter(typeMirror -> typeMirror.getKind() == TypeKind.DECLARED).map(typeMirror -> ((DeclaredType)typeMirror).asElement());
        }

        private DocTree parseBlockTag(JavacTask javacTask, String string) {
            DocCommentTree docCommentTree = this.parseDocComment(javacTask, string);
            return docCommentTree.getBlockTags().get(0);
        }

        private DocCommentTree parseDocComment(JavacTask javacTask, final String string) {
            DocTrees docTrees = DocTrees.instance(javacTask);
            try {
                return docTrees.getDocCommentTree(new SimpleJavaFileObject(new URI("mem://doc.html"), JavaFileObject.Kind.HTML){

                    @Override
                    public CharSequence getCharContent(boolean bl) throws IOException {
                        return "<body>" + string + "</body>";
                    }
                });
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        private String getThrownException(JavacTask javacTask, TreePath treePath, DocCommentTree docCommentTree, ThrowsTree throwsTree) {
            DocTrees docTrees = DocTrees.instance(javacTask);
            Element element = docTrees.getElement(new DocTreePath(new DocTreePath(treePath, docCommentTree), throwsTree.getExceptionName()));
            return element != null ? element.toString() : null;
        }

        private Pair<JavacTask, TreePath> getSourceElement(JavacTask javacTask, Element element) throws IOException {
            String string = this.elementSignature(element);
            Pair<JavacTask, TreePath> pair = this.signature2Source.get(string);
            if (pair != null) {
                return pair.fst != null ? pair : null;
            }
            TypeElement typeElement = this.topLevelType(element);
            if (typeElement == null) {
                return null;
            }
            Elements elements = javacTask.getElements();
            String string2 = elements.getBinaryName(typeElement).toString();
            ModuleElement moduleElement = elements.getModuleOf(typeElement);
            String string3 = moduleElement == null || moduleElement.isUnnamed() ? null : moduleElement.getQualifiedName().toString();
            Pair<JavacTask, CompilationUnitTree> pair2 = this.findSource(string3, string2);
            if (pair2 == null) {
                return null;
            }
            this.fillElementCache((JavacTask)pair2.fst, (CompilationUnitTree)pair2.snd);
            pair = this.signature2Source.get(string);
            if (pair != null) {
                return pair;
            }
            this.signature2Source.put(string, Pair.of(null, null));
            return null;
        }

        private String elementSignature(Element element) {
            switch (element.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    return ((TypeElement)element).getQualifiedName().toString();
                }
                case FIELD: {
                    return this.elementSignature(element.getEnclosingElement()) + "." + element.getSimpleName() + ":" + element.asType();
                }
                case ENUM_CONSTANT: {
                    return this.elementSignature(element.getEnclosingElement()) + "." + element.getSimpleName();
                }
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case RESOURCE_VARIABLE: {
                    return element.getSimpleName() + ":" + element.asType();
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.elementSignature(element.getEnclosingElement()));
                    if (element.getKind() == ElementKind.METHOD) {
                        stringBuilder.append(".");
                        stringBuilder.append(element.getSimpleName());
                    }
                    stringBuilder.append("(");
                    String string = "";
                    ExecutableElement executableElement = (ExecutableElement)element;
                    for (VariableElement variableElement : executableElement.getParameters()) {
                        stringBuilder.append(string);
                        stringBuilder.append(variableElement.asType());
                        string = ", ";
                    }
                    stringBuilder.append(")");
                    return stringBuilder.toString();
                }
            }
            return element.toString();
        }

        private TypeElement topLevelType(Element element) {
            if (element.getKind() == ElementKind.PACKAGE) {
                return null;
            }
            while (element != null && element.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                element = element.getEnclosingElement();
            }
            return element != null && (element.getKind().isClass() || element.getKind().isInterface()) ? (TypeElement)element : null;
        }

        private void fillElementCache(final JavacTask javacTask, CompilationUnitTree compilationUnitTree) throws IOException {
            final Trees trees = Trees.instance(javacTask);
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitMethod(MethodTree methodTree, Void void_) {
                    this.handleDeclaration();
                    return null;
                }

                @Override
                public Void visitClass(ClassTree classTree, Void void_) {
                    this.handleDeclaration();
                    return (Void)super.visitClass(classTree, void_);
                }

                @Override
                public Void visitVariable(VariableTree variableTree, Void void_) {
                    this.handleDeclaration();
                    return (Void)super.visitVariable(variableTree, void_);
                }

                private void handleDeclaration() {
                    Element element = trees.getElement(this.getCurrentPath());
                    if (element != null) {
                        signature2Source.put(this.elementSignature(element), Pair.of(javacTask, this.getCurrentPath()));
                    }
                }
            }.scan(compilationUnitTree, null);
        }

        private Pair<JavacTask, CompilationUnitTree> findSource(String string, String string2) throws IOException {
            JavaFileObject javaFileObject = this.fm.getJavaFileForInput(StandardLocation.SOURCE_PATH, string2, JavaFileObject.Kind.SOURCE);
            if (javaFileObject == null) {
                return null;
            }
            List<JavaFileObject> list = Arrays.asList(javaFileObject);
            JavaFileManager javaFileManager = string != null ? new PatchModuleFileManager(this.baseFileManager, javaFileObject, string) : this.baseFileManager;
            JavacTaskImpl javacTaskImpl = (JavacTaskImpl)compiler.getTask(null, javaFileManager, diagnostic -> {}, null, null, list);
            Iterable<? extends CompilationUnitTree> iterable = javacTaskImpl.parse();
            javacTaskImpl.enter();
            return Pair.of(javacTaskImpl, iterable.iterator().next());
        }

        @Override
        public void close() throws IOException {
            this.fm.close();
        }

        private static final class PatchModuleFileManager
        extends ForwardingJavaFileManager<JavaFileManager> {
            private final JavaFileObject file;
            private final String moduleName;
            private static final JavaFileManager.Location PATCH_LOCATION = new JavaFileManager.Location(){

                @Override
                public String getName() {
                    return "PATCH_LOCATION";
                }

                @Override
                public boolean isOutputLocation() {
                    return false;
                }

                @Override
                public boolean isModuleOrientedLocation() {
                    return false;
                }
            };

            public PatchModuleFileManager(JavaFileManager javaFileManager, JavaFileObject javaFileObject, String string) {
                super(javaFileManager);
                this.file = javaFileObject;
                this.moduleName = string;
            }

            @Override
            public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
                return javaFileObject == this.file ? PATCH_LOCATION : super.getLocationForModule(location, javaFileObject);
            }

            @Override
            public String inferModuleName(JavaFileManager.Location location) throws IOException {
                return location == PATCH_LOCATION ? this.moduleName : super.inferModuleName(location);
            }

            @Override
            public boolean hasLocation(JavaFileManager.Location location) {
                return location == StandardLocation.PATCH_MODULE_PATH || super.hasLocation(location);
            }
        }
    }
}

