/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.CacheMergePolicy;
import com.hazelcast.cache.impl.operation.AbstractCacheOperation;
import com.hazelcast.cache.impl.operation.CachePutBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class CacheMergeOperation
extends AbstractCacheOperation
implements BackupAwareOperation,
MutatingOperation {
    private CacheMergePolicy mergePolicy;
    private CacheEntryView<Data, Data> mergingEntry;

    public CacheMergeOperation() {
    }

    public CacheMergeOperation(String name, Data key, CacheEntryView<Data, Data> entryView, CacheMergePolicy policy) {
        super(name, key);
        this.mergingEntry = entryView;
        this.mergePolicy = policy;
    }

    @Override
    public void run() throws Exception {
        this.backupRecord = this.cache.merge(this.mergingEntry, this.mergePolicy);
    }

    @Override
    public boolean shouldBackup() {
        return this.backupRecord != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutBackupOperation(this.name, this.key, this.backupRecord);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (CacheEntryView)in.readObject();
        this.mergePolicy = (CacheMergePolicy)in.readObject();
    }

    @Override
    public int getId() {
        return 38;
    }
}

