/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="StaticQualifiedUsingExpression", summary="A static variable or method should be qualified with a class name, not expression", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, altNames={"static", "static-access", "StaticAccessedFromInstance"})
public class StaticQualifiedUsingExpression
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final String MESSAGE_TEMPLATE = "Static %s %s should not be accessed from an object instance; instead use %s";
    private static final Matcher<ExpressionTree> staticAccessedFromInstanceMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod(), Matchers.staticFieldAccess()}), Matchers.kindIs((Tree.Kind)Tree.Kind.MEMBER_SELECT), Matchers.selectedIsInstance()});

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        String replacement;
        if (!staticAccessedFromInstanceMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol staticMemberSym = ASTHelpers.getSymbol((Tree)tree);
        if (staticMemberSym == null) {
            return Description.NO_MATCH;
        }
        boolean isMethod = staticMemberSym instanceof Symbol.MethodSymbol;
        Symbol ownerSym = staticMemberSym.owner;
        Symbol.ClassSymbol whereAccessedSym = ASTHelpers.getSymbol((ClassTree)((ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath().getParentPath(), ClassTree.class)));
        if (!(ownerSym instanceof Symbol.ClassSymbol) || !(whereAccessedSym instanceof Symbol.ClassSymbol)) {
            return Description.NO_MATCH;
        }
        boolean staticMemberDefinedHere = whereAccessedSym.equals(ownerSym);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (staticMemberDefinedHere && isMethod) {
            replacement = tree.getIdentifier().toString();
        } else {
            replacement = ownerSym.getSimpleName() + "." + tree.getIdentifier();
            Symbol.PackageSymbol packageSym = ownerSym.packge();
            if (!((Symbol)packageSym).toString().equals("java.lang") && !packageSym.equals(whereAccessedSym.packge())) {
                fix.addImport(ownerSym.toString());
            }
        }
        fix.replace((Tree)tree, replacement);
        String memberName = staticMemberSym.getSimpleName().toString();
        String methodOrVariable = isMethod ? "method" : "variable";
        String customDiagnosticMessage = String.format(MESSAGE_TEMPLATE, methodOrVariable, memberName, replacement);
        return this.buildDescription(tree).setMessage(customDiagnosticMessage).addFix((Fix)fix.build()).build();
    }
}

