/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.server.ServerMain;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.Terminable;
import java.util.Timer;
import java.util.TimerTask;

public class IdleResetSjavac
implements Sjavac {
    private final Sjavac delegate;
    private final Terminable toShutdown;
    private final Timer idlenessTimer = new Timer();
    private final long idleTimeout;
    private int outstandingCalls = 0;
    private TimerTask idlenessTimerTask;

    public IdleResetSjavac(Sjavac sjavac, Terminable terminable, long l) {
        this.delegate = sjavac;
        this.toShutdown = terminable;
        this.idleTimeout = l;
        this.scheduleTimeout();
    }

    @Override
    public Main.Result compile(String[] stringArray) {
        this.startCall();
        try {
            Main.Result result = this.delegate.compile(stringArray);
            return result;
        }
        finally {
            this.endCall();
        }
    }

    private synchronized void startCall() {
        if (++this.outstandingCalls == 1) {
            if (this.idlenessTimerTask == null) {
                throw new IllegalStateException("Idle timeout already cancelled");
            }
            this.idlenessTimerTask.cancel();
            this.idlenessTimerTask = null;
        }
    }

    private synchronized void endCall() {
        if (--this.outstandingCalls == 0) {
            this.scheduleTimeout();
        }
    }

    private void scheduleTimeout() {
        if (this.idlenessTimerTask != null) {
            throw new IllegalStateException("Idle timeout already scheduled");
        }
        this.idlenessTimerTask = new TimerTask(){

            @Override
            public void run() {
                Log.setLogForCurrentThread(ServerMain.getErrorLog());
                IdleResetSjavac.this.toShutdown.shutdown("Server has been idle for " + IdleResetSjavac.this.idleTimeout / 1000L + " seconds.");
            }
        };
        this.idlenessTimer.schedule(this.idlenessTimerTask, this.idleTimeout);
    }

    @Override
    public void shutdown() {
        this.idlenessTimer.cancel();
        this.delegate.shutdown();
    }
}

