/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.type.Type;

public class Erasure {
    public static Type erase(Type ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        switch (ty.tyKind()) {
            case PRIM_TY: 
            case VOID_TY: {
                return ty;
            }
            case CLASS_TY: {
                return Erasure.eraseClassTy((Type.ClassTy)ty);
            }
            case ARRAY_TY: {
                return Erasure.eraseArrayTy((Type.ArrayTy)ty, tenv);
            }
            case TY_VAR: {
                return Erasure.eraseTyVar((Type.TyVar)ty, tenv);
            }
            case INTERSECTION_TY: {
                return Erasure.eraseIntersectionTy((Type.IntersectionTy)ty, tenv);
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private static Type eraseIntersectionTy(Type.IntersectionTy ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return Erasure.erase((Type)ty.bounds().get(0), tenv);
    }

    private static Type eraseTyVar(Type.TyVar ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        TypeBoundClass.TyVarInfo info = (TypeBoundClass.TyVarInfo)tenv.apply((Object)ty.sym());
        return Erasure.erase(info.bound(), tenv);
    }

    private static Type.ArrayTy eraseArrayTy(Type.ArrayTy ty, Function<TyVarSymbol, TypeBoundClass.TyVarInfo> tenv) {
        return Type.ArrayTy.create(Erasure.erase(ty.elementType(), tenv), ty.annos());
    }

    public static Type.ClassTy eraseClassTy(Type.ClassTy ty) {
        ImmutableList.Builder classes = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy c : ty.classes()) {
            if (c.targs().isEmpty()) {
                classes.add((Object)c);
                continue;
            }
            classes.add((Object)Type.ClassTy.SimpleClassTy.create(c.sym(), (ImmutableList<Type>)ImmutableList.of(), c.annos()));
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)classes.build());
    }
}

