/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server.log;

import com.sun.tools.sjavac.Log;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LazyInitFileLog
extends Log {
    String baseFilename;
    Path destination = null;

    public LazyInitFileLog(String baseFilename) {
        super(null, null);
        this.baseFilename = baseFilename;
    }

    @Override
    protected void printLogMsg(Log.Level msgLevel, String msg) {
        try {
            if (this.out == null && this.isLevelLogged(msgLevel)) {
                this.destination = this.getAvailableDestination();
                this.out = this.err = new PrintWriter((Writer)new FileWriter(this.destination.toFile()), true);
            }
            super.printLogMsg(msgLevel, msg);
        }
        catch (IOException e) {
            System.out.println("IO error occurred: " + e.getMessage());
            System.out.println("Original message: [" + msgLevel + "] " + msg);
        }
    }

    private Path getAvailableDestination() {
        Path p = Paths.get(this.baseFilename, new String[0]);
        int i = 1;
        while (Files.exists(p, new LinkOption[0])) {
            p = Paths.get(this.baseFilename + "." + i++, new String[0]);
        }
        return p;
    }

    public Path getLogDestination() {
        return this.destination;
    }
}

